/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.http;

import com.conveyal.gtfs.GTFSFeed;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import com.google.transit.realtime.GtfsRealtime;
import com.graphhopper.config.Profile;
import com.graphhopper.gtfs.GraphExplorer;
import com.graphhopper.gtfs.GraphHopperGtfs;
import com.graphhopper.gtfs.GtfsStorage;
import com.graphhopper.gtfs.RealtimeFeed;
import com.graphhopper.gtfs.Transfers;
import com.graphhopper.http.FeedConfiguration;
import com.graphhopper.http.GraphHopperBundleConfiguration;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.Graph;
import com.graphhopper.util.PMap;
import io.dropwizard.lifecycle.Managed;
import jakarta.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.glassfish.hk2.api.Factory;

public class RealtimeFeedLoadingCache
implements Factory<RealtimeFeed>,
Managed {
    private final HttpClient httpClient;
    private final GraphHopperGtfs graphHopper;
    private final GraphHopperBundleConfiguration bundleConfiguration;
    private ExecutorService executor;
    private LoadingCache<String, RealtimeFeed> cache;
    private Map<String, Transfers> transfers;

    @Inject
    RealtimeFeedLoadingCache(GraphHopperGtfs graphHopper, HttpClient httpClient, GraphHopperBundleConfiguration bundleConfiguration) {
        this.graphHopper = graphHopper;
        this.bundleConfiguration = bundleConfiguration;
        this.httpClient = httpClient;
    }

    public void start() {
        this.transfers = new HashMap<String, Transfers>();
        for (Map.Entry entry : this.graphHopper.getGtfsStorage().getGtfsFeeds().entrySet()) {
            this.transfers.put((String)entry.getKey(), new Transfers((GTFSFeed)entry.getValue()));
        }
        this.executor = Executors.newSingleThreadExecutor();
        this.cache = CacheBuilder.newBuilder().maximumSize(1L).refreshAfterWrite(1L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, RealtimeFeed>(){

            public RealtimeFeed load(String key) {
                return RealtimeFeedLoadingCache.this.fetchFeedsAndCreateGraph();
            }

            public ListenableFuture<RealtimeFeed> reload(String key, RealtimeFeed oldValue) {
                ListenableFutureTask task = ListenableFutureTask.create(() -> RealtimeFeedLoadingCache.this.fetchFeedsAndCreateGraph());
                RealtimeFeedLoadingCache.this.executor.execute((Runnable)task);
                return task;
            }
        });
    }

    public RealtimeFeed provide() {
        try {
            return (RealtimeFeed)this.cache.get((Object)"pups");
        }
        catch (RuntimeException | ExecutionException e) {
            e.printStackTrace();
            return RealtimeFeed.empty();
        }
    }

    public void dispose(RealtimeFeed instance) {
        this.executor.shutdown();
    }

    public void stop() {
    }

    private RealtimeFeed fetchFeedsAndCreateGraph() {
        HashMap<String, GtfsRealtime.FeedMessage> feedMessageMap = new HashMap<String, GtfsRealtime.FeedMessage>();
        for (FeedConfiguration configuration : this.bundleConfiguration.gtfsrealtime().getFeeds()) {
            try {
                switch (configuration.getUrl().getProtocol()) {
                    case "http": {
                        GtfsRealtime.FeedMessage feedMessage = (GtfsRealtime.FeedMessage)this.httpClient.execute((ClassicHttpRequest)new HttpGet(configuration.getUrl().toURI()), response -> GtfsRealtime.FeedMessage.parseFrom((InputStream)response.getEntity().getContent()));
                        feedMessageMap.put(configuration.getFeedId(), feedMessage);
                        break;
                    }
                    case "file": {
                        GtfsRealtime.FeedMessage feedMessage = GtfsRealtime.FeedMessage.parseFrom((InputStream)configuration.getUrl().openStream());
                        feedMessageMap.put(configuration.getFeedId(), feedMessage);
                        break;
                    }
                }
            }
            catch (IOException | URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        return RealtimeFeed.fromProtobuf((GtfsStorage)this.graphHopper.getGtfsStorage(), this.transfers, feedMessageMap);
    }

    private void validate(RealtimeFeed realtimeFeed) {
        Profile foot = this.graphHopper.getProfile("foot");
        Weighting weighting = this.graphHopper.createWeighting(foot, new PMap(), false);
        GraphExplorer graphExplorer = new GraphExplorer((Graph)this.graphHopper.getBaseGraph(), this.graphHopper.getGtfsStorage().getPtGraph(), weighting, this.graphHopper.getGtfsStorage(), realtimeFeed, false, false, false, 6.0, true, 0);
        EnumSet<GtfsStorage.EdgeType> edgeTypes = EnumSet.noneOf(GtfsStorage.EdgeType.class);
        for (int streetNode = 0; streetNode < this.graphHopper.getBaseGraph().getNodes(); ++streetNode) {
            int ptNode = this.graphHopper.getGtfsStorage().getStreetToPt().getOrDefault(streetNode, -1);
            if (ptNode == -1) continue;
            for (GraphExplorer.MultiModalEdge multiModalEdge : graphExplorer.ptEdgeStream(ptNode, 0L)) {
                edgeTypes.add(multiModalEdge.getType());
            }
        }
        System.out.println(edgeTypes);
    }
}

