/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.resources;

import com.codahale.metrics.health.HealthCheck;
import com.codahale.metrics.health.HealthCheckRegistry;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Response;
import java.util.SortedMap;

@Path(value="health")
public class HealthCheckResource {
    private HealthCheckRegistry registry;

    @Inject
    public HealthCheckResource(HealthCheckRegistry registry) {
        this.registry = registry;
    }

    @GET
    public Response doGet() {
        SortedMap results = this.registry.runHealthChecks();
        for (HealthCheck.Result result : results.values()) {
            if (result.isHealthy()) continue;
            return Response.status((int)500).entity((Object)"UNHEALTHY").build();
        }
        return Response.ok((Object)"OK").build();
    }
}

