/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.resources;

import com.conveyal.gtfs.GTFSFeed;
import com.conveyal.gtfs.model.Stop;
import com.google.protobuf.ByteString;
import com.graphhopper.GraphHopper;
import com.graphhopper.gtfs.GtfsStorage;
import com.graphhopper.gtfs.PtGraph;
import com.graphhopper.matching.MatchResult;
import com.graphhopper.util.shapes.BBox;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import no.ecc.vectortile.VectorTileEncoder;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.util.AffineTransformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="pt-mvt")
@Singleton
public class PtMVTResource {
    private static final Logger logger = LoggerFactory.getLogger(PtMVTResource.class);
    private static final MediaType PBF = new MediaType("application", "x-protobuf");
    private final GraphHopper graphHopper;
    private final GtfsStorage gtfsStorage;
    private final Map<ByteString, MatchResult> openLRCache = new ConcurrentHashMap<ByteString, MatchResult>();
    private final GeometryFactory geometryFactory = new GeometryFactory();

    @Inject
    public PtMVTResource(GraphHopper graphHopper, GtfsStorage gtfsStorage) throws IOException {
        this.graphHopper = graphHopper;
        this.gtfsStorage = gtfsStorage;
    }

    @GET
    @Path(value="{z}/{x}/{y}.mvt")
    @Produces(value={"application/x-protobuf"})
    public Response doGetXyz(@Context HttpServletRequest httpReq, @Context UriInfo uriInfo, @PathParam(value="z") int zInfo, @PathParam(value="x") int xInfo, @PathParam(value="y") int yInfo, @QueryParam(value="details") List<String> pathDetails) {
        Coordinate nw = this.num2deg(xInfo, yInfo, zInfo);
        Coordinate se = this.num2deg(xInfo + 1, yInfo + 1, zInfo);
        BBox bbox = new BBox(nw.x, se.x, se.y, nw.y);
        if (!bbox.isValid()) {
            throw new IllegalStateException("Invalid bbox " + String.valueOf(bbox));
        }
        VectorTileEncoder vectorTileEncoder = new VectorTileEncoder();
        AffineTransformation affineTransformation = new AffineTransformation();
        affineTransformation.translate(-nw.x, -se.y);
        affineTransformation.scale(256.0 / (se.x - nw.x), -256.0 / (nw.y - se.y));
        affineTransformation.translate(0.0, 256.0);
        this.gtfsStorage.getStopIndex().query(bbox, edgeId -> {
            for (PtGraph.PtEdge ptEdge : this.gtfsStorage.getPtGraph().backEdgesAround(edgeId)) {
                if (ptEdge.getType() != GtfsStorage.EdgeType.EXIT_PT) continue;
                GtfsStorage.PlatformDescriptor fromPlatformDescriptor = ptEdge.getAttrs().platformDescriptor;
                Stop stop = (Stop)((GTFSFeed)this.gtfsStorage.getGtfsFeeds().get((Object)fromPlatformDescriptor.feed_id)).stops.get(fromPlatformDescriptor.stop_id);
                HashMap<String, String> properties = new HashMap<String, String>(2);
                properties.put("feed_id", fromPlatformDescriptor.feed_id);
                properties.put("stop_id", fromPlatformDescriptor.stop_id);
                Point feature = this.geometryFactory.createPoint(new Coordinate(stop.stop_lon, stop.stop_lat));
                feature.setUserData(properties);
                Geometry g = affineTransformation.transform((Geometry)feature);
                vectorTileEncoder.addFeature("stops", properties, g);
            }
        });
        return Response.ok((Object)vectorTileEncoder.encode(), (MediaType)PBF).build();
    }

    Coordinate num2deg(int xInfo, int yInfo, int zoom) {
        double n = Math.pow(2.0, zoom);
        double lonDeg = (double)xInfo / n * 360.0 - 180.0;
        double latRad = Math.atan(Math.sinh(Math.PI * (1.0 - (double)(2 * yInfo) / n)));
        double latDeg = Math.toDegrees(latRad);
        return new Coordinate(lonDeg, latDeg);
    }
}

