/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.CharByteHashMap;
import com.carrotsearch.hppc.HashOrderMixing;

public class CharByteScatterMap
extends CharByteHashMap {
    public CharByteScatterMap() {
        this(4);
    }

    public CharByteScatterMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public CharByteScatterMap(int expectedElements, double loadFactor) {
        super(expectedElements, loadFactor, HashOrderMixing.none());
    }

    @Override
    protected int hashKey(char key) {
        return BitMixer.mixPhi(key);
    }

    public static CharByteScatterMap from(char[] keys2, byte[] values2) {
        if (keys2.length != values2.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        CharByteScatterMap map = new CharByteScatterMap(keys2.length);
        for (int i = 0; i < keys2.length; ++i) {
            map.put(keys2[i], values2[i]);
        }
        return map;
    }
}

