/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.CharFloatHashMap;
import com.carrotsearch.hppc.HashOrderMixing;

public class CharFloatScatterMap
extends CharFloatHashMap {
    public CharFloatScatterMap() {
        this(4);
    }

    public CharFloatScatterMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public CharFloatScatterMap(int expectedElements, double loadFactor) {
        super(expectedElements, loadFactor, HashOrderMixing.none());
    }

    @Override
    protected int hashKey(char key) {
        return BitMixer.mixPhi(key);
    }

    public static CharFloatScatterMap from(char[] keys2, float[] values2) {
        if (keys2.length != values2.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        CharFloatScatterMap map = new CharFloatScatterMap(keys2.length);
        for (int i = 0; i < keys2.length; ++i) {
            map.put(keys2[i], values2[i]);
        }
        return map;
    }
}

