/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.HashOrderMixing;
import com.carrotsearch.hppc.IntIntHashMap;

public class IntIntScatterMap
extends IntIntHashMap {
    public IntIntScatterMap() {
        this(4);
    }

    public IntIntScatterMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public IntIntScatterMap(int expectedElements, double loadFactor) {
        super(expectedElements, loadFactor, HashOrderMixing.none());
    }

    @Override
    protected int hashKey(int key) {
        return BitMixer.mixPhi(key);
    }

    public static IntIntScatterMap from(int[] keys2, int[] values2) {
        if (keys2.length != values2.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        IntIntScatterMap map = new IntIntScatterMap(keys2.length);
        for (int i = 0; i < keys2.length; ++i) {
            map.put(keys2[i], values2[i]);
        }
        return map;
    }
}

