/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.HashOrderMixing;
import com.carrotsearch.hppc.ObjectLongHashMap;

public class ObjectLongScatterMap<KType>
extends ObjectLongHashMap<KType> {
    public ObjectLongScatterMap() {
        this(4);
    }

    public ObjectLongScatterMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public ObjectLongScatterMap(int expectedElements, double loadFactor) {
        super(expectedElements, loadFactor, HashOrderMixing.none());
    }

    @Override
    protected int hashKey(KType key) {
        return BitMixer.mixPhi(key);
    }

    public static <KType> ObjectLongScatterMap<KType> from(KType[] keys2, long[] values2) {
        if (keys2.length != values2.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        ObjectLongScatterMap<KType> map = new ObjectLongScatterMap<KType>(keys2.length);
        for (int i = 0; i < keys2.length; ++i) {
            map.put(keys2[i], values2[i]);
        }
        return map;
    }
}

