/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractByteCollection;
import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.AbstractShortCollection;
import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.BufferAllocationException;
import com.carrotsearch.hppc.ByteCollection;
import com.carrotsearch.hppc.HashContainers;
import com.carrotsearch.hppc.HashOrderMixing;
import com.carrotsearch.hppc.HashOrderMixingStrategy;
import com.carrotsearch.hppc.Preallocable;
import com.carrotsearch.hppc.ShortBufferVisualizer;
import com.carrotsearch.hppc.ShortByteAssociativeContainer;
import com.carrotsearch.hppc.ShortByteMap;
import com.carrotsearch.hppc.ShortContainer;
import com.carrotsearch.hppc.ShortLookupContainer;
import com.carrotsearch.hppc.cursors.ByteCursor;
import com.carrotsearch.hppc.cursors.ShortByteCursor;
import com.carrotsearch.hppc.cursors.ShortCursor;
import com.carrotsearch.hppc.predicates.BytePredicate;
import com.carrotsearch.hppc.predicates.ShortBytePredicate;
import com.carrotsearch.hppc.predicates.ShortPredicate;
import com.carrotsearch.hppc.procedures.ByteProcedure;
import com.carrotsearch.hppc.procedures.ShortByteProcedure;
import com.carrotsearch.hppc.procedures.ShortProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class ShortByteHashMap
implements ShortByteMap,
Preallocable,
Cloneable {
    public short[] keys;
    public byte[] values;
    protected int keyMixer;
    protected int assigned;
    protected int mask;
    protected int resizeAt;
    protected boolean hasEmptyKey;
    protected double loadFactor;
    protected HashOrderMixingStrategy orderMixer;

    public ShortByteHashMap() {
        this(4);
    }

    public ShortByteHashMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public ShortByteHashMap(int expectedElements, double loadFactor) {
        this(expectedElements, loadFactor, HashOrderMixing.defaultStrategy());
    }

    public ShortByteHashMap(int expectedElements, double loadFactor, HashOrderMixingStrategy orderMixer) {
        this.orderMixer = orderMixer;
        this.loadFactor = this.verifyLoadFactor(loadFactor);
        this.ensureCapacity(expectedElements);
    }

    public ShortByteHashMap(ShortByteAssociativeContainer container) {
        this(container.size());
        this.putAll(container);
    }

    @Override
    public byte put(short key, byte value) {
        short existing;
        assert (this.assigned < this.mask + 1);
        int mask = this.mask;
        if (key == 0) {
            this.hasEmptyKey = true;
            byte previousValue = this.values[mask + 1];
            this.values[mask + 1] = value;
            return previousValue;
        }
        short[] keys2 = this.keys;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys2[slot]) != 0) {
            if (existing == key) {
                byte previousValue = this.values[slot];
                this.values[slot] = value;
                return previousValue;
            }
            slot = slot + 1 & mask;
        }
        if (this.assigned == this.resizeAt) {
            this.allocateThenInsertThenRehash(slot, key, value);
        } else {
            keys2[slot] = key;
            this.values[slot] = value;
        }
        ++this.assigned;
        return 0;
    }

    @Override
    public int putAll(ShortByteAssociativeContainer container) {
        int count = this.size();
        for (ShortByteCursor c : container) {
            this.put(c.key, c.value);
        }
        return this.size() - count;
    }

    @Override
    public int putAll(Iterable<? extends ShortByteCursor> iterable) {
        int count = this.size();
        for (ShortByteCursor shortByteCursor : iterable) {
            this.put(shortByteCursor.key, shortByteCursor.value);
        }
        return this.size() - count;
    }

    public boolean putIfAbsent(short key, byte value) {
        int keyIndex = this.indexOf(key);
        if (!this.indexExists(keyIndex)) {
            this.indexInsert(keyIndex, key, value);
            return true;
        }
        return false;
    }

    @Override
    public byte putOrAdd(short key, byte putValue, byte incrementValue) {
        assert (this.assigned < this.mask + 1);
        int keyIndex = this.indexOf(key);
        if (this.indexExists(keyIndex)) {
            putValue = (byte)(this.values[keyIndex] + incrementValue);
            this.indexReplace(keyIndex, putValue);
        } else {
            this.indexInsert(keyIndex, key, putValue);
        }
        return putValue;
    }

    @Override
    public byte addTo(short key, byte incrementValue) {
        return this.putOrAdd(key, incrementValue, incrementValue);
    }

    @Override
    public byte remove(short key) {
        short existing;
        int mask = this.mask;
        if (key == 0) {
            this.hasEmptyKey = false;
            byte previousValue = this.values[mask + 1];
            this.values[mask + 1] = 0;
            return previousValue;
        }
        short[] keys2 = this.keys;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys2[slot]) != 0) {
            if (existing == key) {
                byte previousValue = this.values[slot];
                this.shiftConflictingKeys(slot);
                return previousValue;
            }
            slot = slot + 1 & mask;
        }
        return 0;
    }

    @Override
    public int removeAll(ShortContainer other) {
        int before = this.size();
        if (other.size() >= this.size() && other instanceof ShortLookupContainer) {
            if (this.hasEmptyKey && other.contains((short)0)) {
                this.hasEmptyKey = false;
                this.values[this.mask + 1] = 0;
            }
            short[] keys2 = this.keys;
            int slot = 0;
            int max = this.mask;
            while (slot <= max) {
                short existing = keys2[slot];
                if (existing != 0 && other.contains(existing)) {
                    this.shiftConflictingKeys(slot);
                    continue;
                }
                ++slot;
            }
        } else {
            for (ShortCursor c : other) {
                this.remove(c.value);
            }
        }
        return before - this.size();
    }

    @Override
    public int removeAll(ShortBytePredicate predicate) {
        int before = this.size();
        int mask = this.mask;
        if (this.hasEmptyKey && predicate.apply((short)0, this.values[mask + 1])) {
            this.hasEmptyKey = false;
            this.values[mask + 1] = 0;
        }
        short[] keys2 = this.keys;
        byte[] values2 = this.values;
        int slot = 0;
        while (slot <= mask) {
            short existing = keys2[slot];
            if (existing != 0 && predicate.apply(existing, values2[slot])) {
                this.shiftConflictingKeys(slot);
                continue;
            }
            ++slot;
        }
        return before - this.size();
    }

    @Override
    public int removeAll(ShortPredicate predicate) {
        int before = this.size();
        if (this.hasEmptyKey && predicate.apply((short)0)) {
            this.hasEmptyKey = false;
            this.values[this.mask + 1] = 0;
        }
        short[] keys2 = this.keys;
        int slot = 0;
        int max = this.mask;
        while (slot <= max) {
            short existing = keys2[slot];
            if (existing != 0 && predicate.apply(existing)) {
                this.shiftConflictingKeys(slot);
                continue;
            }
            ++slot;
        }
        return before - this.size();
    }

    @Override
    public byte get(short key) {
        short existing;
        if (key == 0) {
            return this.hasEmptyKey ? this.values[this.mask + 1] : (byte)0;
        }
        short[] keys2 = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys2[slot]) != 0) {
            if (existing == key) {
                return this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return 0;
    }

    @Override
    public byte getOrDefault(short key, byte defaultValue) {
        short existing;
        if (key == 0) {
            return this.hasEmptyKey ? this.values[this.mask + 1] : defaultValue;
        }
        short[] keys2 = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys2[slot]) != 0) {
            if (existing == key) {
                return this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return defaultValue;
    }

    @Override
    public boolean containsKey(short key) {
        short existing;
        if (key == 0) {
            return this.hasEmptyKey;
        }
        short[] keys2 = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys2[slot]) != 0) {
            if (existing == key) {
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    @Override
    public int indexOf(short key) {
        short existing;
        int mask = this.mask;
        if (key == 0) {
            return this.hasEmptyKey ? mask + 1 : ~(mask + 1);
        }
        short[] keys2 = this.keys;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys2[slot]) != 0) {
            if (existing == key) {
                return slot;
            }
            slot = slot + 1 & mask;
        }
        return ~slot;
    }

    @Override
    public boolean indexExists(int index) {
        assert (index < 0 || index >= 0 && index <= this.mask || index == this.mask + 1 && this.hasEmptyKey);
        return index >= 0;
    }

    @Override
    public byte indexGet(int index) {
        assert (index >= 0) : "The index must point at an existing key.";
        assert (index <= this.mask || index == this.mask + 1 && this.hasEmptyKey);
        return this.values[index];
    }

    @Override
    public byte indexReplace(int index, byte newValue) {
        assert (index >= 0) : "The index must point at an existing key.";
        assert (index <= this.mask || index == this.mask + 1 && this.hasEmptyKey);
        byte previousValue = this.values[index];
        this.values[index] = newValue;
        return previousValue;
    }

    @Override
    public void indexInsert(int index, short key, byte value) {
        assert (index < 0) : "The index must not point at an existing key.";
        index ^= 0xFFFFFFFF;
        if (key == 0) {
            assert (index == this.mask + 1);
            this.values[index] = value;
            this.hasEmptyKey = true;
        } else {
            assert (this.keys[index] == 0);
            if (this.assigned == this.resizeAt) {
                this.allocateThenInsertThenRehash(index, key, value);
            } else {
                this.keys[index] = key;
                this.values[index] = value;
            }
            ++this.assigned;
        }
    }

    @Override
    public void clear() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        Arrays.fill(this.keys, (short)0);
    }

    @Override
    public void release() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        this.keys = null;
        this.values = null;
        this.ensureCapacity(4);
    }

    @Override
    public int size() {
        return this.assigned + (this.hasEmptyKey ? 1 : 0);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int hashCode() {
        int h2 = this.hasEmptyKey ? -559038737 : 0;
        for (ShortByteCursor c : this) {
            h2 += BitMixer.mix(c.key) + BitMixer.mix(c.value);
        }
        return h2;
    }

    @Override
    public boolean equals(Object obj) {
        return obj != null && this.getClass() == obj.getClass() && this.equalElements((ShortByteHashMap)this.getClass().cast(obj));
    }

    protected boolean equalElements(ShortByteHashMap other) {
        if (other.size() != this.size()) {
            return false;
        }
        for (ShortByteCursor c : other) {
            short key = c.key;
            if (this.containsKey(key) && this.get(key) == c.value) continue;
            return false;
        }
        return true;
    }

    @Override
    public void ensureCapacity(int expectedElements) {
        if (expectedElements > this.resizeAt || this.keys == null) {
            short[] prevKeys = this.keys;
            byte[] prevValues = this.values;
            this.allocateBuffers(HashContainers.minBufferSize(expectedElements, this.loadFactor));
            if (prevKeys != null && !this.isEmpty()) {
                this.rehash(prevKeys, prevValues);
            }
        }
    }

    @Override
    public Iterator<ShortByteCursor> iterator() {
        return new EntryIterator();
    }

    @Override
    public <T extends ShortByteProcedure> T forEach(T procedure) {
        short[] keys2 = this.keys;
        byte[] values2 = this.values;
        if (this.hasEmptyKey) {
            procedure.apply((short)0, values2[this.mask + 1]);
        }
        int max = this.mask;
        for (int slot = 0; slot <= max; ++slot) {
            if (keys2[slot] == 0) continue;
            procedure.apply(keys2[slot], values2[slot]);
        }
        return procedure;
    }

    @Override
    public <T extends ShortBytePredicate> T forEach(T predicate) {
        short[] keys2 = this.keys;
        byte[] values2 = this.values;
        if (this.hasEmptyKey && !predicate.apply((short)0, values2[this.mask + 1])) {
            return predicate;
        }
        int max = this.mask;
        for (int slot = 0; slot <= max && (keys2[slot] == 0 || predicate.apply(keys2[slot], values2[slot])); ++slot) {
        }
        return predicate;
    }

    @Override
    public KeysContainer keys() {
        return new KeysContainer();
    }

    @Override
    public ByteCollection values() {
        return new ValuesContainer();
    }

    public ShortByteHashMap clone() {
        try {
            ShortByteHashMap cloned = (ShortByteHashMap)super.clone();
            cloned.keys = (short[])this.keys.clone();
            cloned.values = (byte[])this.values.clone();
            cloned.hasEmptyKey = cloned.hasEmptyKey;
            cloned.orderMixer = this.orderMixer.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        boolean first = true;
        for (ShortByteCursor cursor : this) {
            if (!first) {
                buffer.append(", ");
            }
            buffer.append(cursor.key);
            buffer.append("=>");
            buffer.append(cursor.value);
            first = false;
        }
        buffer.append("]");
        return buffer.toString();
    }

    @Override
    public String visualizeKeyDistribution(int characters) {
        return ShortBufferVisualizer.visualizeKeyDistribution(this.keys, this.mask, characters);
    }

    public static ShortByteHashMap from(short[] keys2, byte[] values2) {
        if (keys2.length != values2.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        ShortByteHashMap map = new ShortByteHashMap(keys2.length);
        for (int i = 0; i < keys2.length; ++i) {
            map.put(keys2[i], values2[i]);
        }
        return map;
    }

    protected int hashKey(short key) {
        assert (key != 0);
        return BitMixer.mix(key, this.keyMixer);
    }

    protected double verifyLoadFactor(double loadFactor) {
        HashContainers.checkLoadFactor(loadFactor, 0.01f, 0.99f);
        return loadFactor;
    }

    protected void rehash(short[] fromKeys, byte[] fromValues) {
        assert (fromKeys.length == fromValues.length && HashContainers.checkPowerOfTwo(fromKeys.length - 1));
        short[] keys2 = this.keys;
        byte[] values2 = this.values;
        int mask = this.mask;
        int from = fromKeys.length - 1;
        keys2[keys2.length - 1] = fromKeys[from];
        values2[values2.length - 1] = fromValues[from];
        while (--from >= 0) {
            short existing = fromKeys[from];
            if (existing == 0) continue;
            int slot = this.hashKey(existing) & mask;
            while (keys2[slot] != 0) {
                slot = slot + 1 & mask;
            }
            keys2[slot] = existing;
            values2[slot] = fromValues[from];
        }
    }

    protected void allocateBuffers(int arraySize) {
        assert (Integer.bitCount(arraySize) == 1);
        int newKeyMixer = this.orderMixer.newKeyMixer(arraySize);
        short[] prevKeys = this.keys;
        byte[] prevValues = this.values;
        try {
            int emptyElementSlot = 1;
            this.keys = new short[arraySize + emptyElementSlot];
            this.values = new byte[arraySize + emptyElementSlot];
        }
        catch (OutOfMemoryError e) {
            this.keys = prevKeys;
            this.values = prevValues;
            throw new BufferAllocationException("Not enough memory to allocate buffers for rehashing: %,d -> %,d", (Throwable)e, this.mask + 1, arraySize);
        }
        this.resizeAt = HashContainers.expandAtCount(arraySize, this.loadFactor);
        this.keyMixer = newKeyMixer;
        this.mask = arraySize - 1;
    }

    protected void allocateThenInsertThenRehash(int slot, short pendingKey, byte pendingValue) {
        assert (this.assigned == this.resizeAt && this.keys[slot] == 0 && pendingKey != 0);
        short[] prevKeys = this.keys;
        byte[] prevValues = this.values;
        this.allocateBuffers(HashContainers.nextBufferSize(this.mask + 1, this.size(), this.loadFactor));
        assert (this.keys.length > prevKeys.length);
        prevKeys[slot] = pendingKey;
        prevValues[slot] = pendingValue;
        this.rehash(prevKeys, prevValues);
    }

    protected void shiftConflictingKeys(int gapSlot) {
        int slot;
        short existing;
        short[] keys2 = this.keys;
        byte[] values2 = this.values;
        int mask = this.mask;
        int distance = 0;
        while ((existing = keys2[slot = gapSlot + ++distance & mask]) != 0) {
            int idealSlot = this.hashKey(existing);
            int shift = slot - idealSlot & mask;
            if (shift < distance) continue;
            keys2[gapSlot] = existing;
            values2[gapSlot] = values2[slot];
            gapSlot = slot;
            distance = 0;
        }
        keys2[gapSlot] = 0;
        values2[gapSlot] = 0;
        --this.assigned;
    }

    private final class ValuesIterator
    extends AbstractIterator<ByteCursor> {
        private final ByteCursor cursor;
        private final int max;
        private int slot;

        public ValuesIterator() {
            this.max = ShortByteHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new ByteCursor();
        }

        @Override
        protected ByteCursor fetch() {
            if (this.slot < this.max) {
                ++this.slot;
                while (this.slot < this.max) {
                    if (ShortByteHashMap.this.keys[this.slot] != 0) {
                        this.cursor.index = this.slot;
                        this.cursor.value = ShortByteHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    ++this.slot;
                }
            }
            if (this.slot == this.max && ShortByteHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = ShortByteHashMap.this.values[this.max];
                return this.cursor;
            }
            return (ByteCursor)this.done();
        }
    }

    private final class ValuesContainer
    extends AbstractByteCollection {
        private final ShortByteHashMap owner;

        private ValuesContainer() {
            this.owner = ShortByteHashMap.this;
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public boolean contains(byte value) {
            for (ShortByteCursor c : this.owner) {
                if (c.value != value) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends ByteProcedure> T forEach(T procedure) {
            for (ShortByteCursor c : this.owner) {
                procedure.apply(c.value);
            }
            return procedure;
        }

        @Override
        public <T extends BytePredicate> T forEach(T predicate) {
            for (ShortByteCursor c : this.owner) {
                if (predicate.apply(c.value)) continue;
                break;
            }
            return predicate;
        }

        @Override
        public Iterator<ByteCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public int removeAll(final byte e) {
            return this.owner.removeAll(new ShortBytePredicate(){

                @Override
                public boolean apply(short key, byte value) {
                    return value == e;
                }
            });
        }

        @Override
        public int removeAll(final BytePredicate predicate) {
            return this.owner.removeAll(new ShortBytePredicate(){

                @Override
                public boolean apply(short key, byte value) {
                    return predicate.apply(value);
                }
            });
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public void release() {
            this.owner.release();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<ShortCursor> {
        private final ShortCursor cursor;
        private final int max;
        private int slot;

        public KeysIterator() {
            this.max = ShortByteHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new ShortCursor();
        }

        @Override
        protected ShortCursor fetch() {
            if (this.slot < this.max) {
                ++this.slot;
                while (this.slot < this.max) {
                    short existing = ShortByteHashMap.this.keys[this.slot];
                    if (existing != 0) {
                        this.cursor.index = this.slot;
                        this.cursor.value = existing;
                        return this.cursor;
                    }
                    ++this.slot;
                }
            }
            if (this.slot == this.max && ShortByteHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = 0;
                return this.cursor;
            }
            return (ShortCursor)this.done();
        }
    }

    public final class KeysContainer
    extends AbstractShortCollection
    implements ShortLookupContainer {
        private final ShortByteHashMap owner;

        public KeysContainer() {
            this.owner = ShortByteHashMap.this;
        }

        @Override
        public boolean contains(short e) {
            return this.owner.containsKey(e);
        }

        @Override
        public <T extends ShortProcedure> T forEach(final T procedure) {
            this.owner.forEach(new ShortByteProcedure(){

                @Override
                public void apply(short key, byte value) {
                    procedure.apply(key);
                }
            });
            return procedure;
        }

        @Override
        public <T extends ShortPredicate> T forEach(final T predicate) {
            this.owner.forEach(new ShortBytePredicate(){

                @Override
                public boolean apply(short key, byte value) {
                    return predicate.apply(key);
                }
            });
            return predicate;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<ShortCursor> iterator() {
            return new KeysIterator();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public void release() {
            this.owner.release();
        }

        @Override
        public int removeAll(ShortPredicate predicate) {
            return this.owner.removeAll(predicate);
        }

        @Override
        public int removeAll(short e) {
            boolean hasKey = this.owner.containsKey(e);
            if (hasKey) {
                this.owner.remove(e);
                return 1;
            }
            return 0;
        }
    }

    private final class EntryIterator
    extends AbstractIterator<ShortByteCursor> {
        private final ShortByteCursor cursor;
        private final int max;
        private int slot;

        public EntryIterator() {
            this.max = ShortByteHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new ShortByteCursor();
        }

        @Override
        protected ShortByteCursor fetch() {
            if (this.slot < this.max) {
                ++this.slot;
                while (this.slot < this.max) {
                    short existing = ShortByteHashMap.this.keys[this.slot];
                    if (existing != 0) {
                        this.cursor.index = this.slot;
                        this.cursor.key = existing;
                        this.cursor.value = ShortByteHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    ++this.slot;
                }
            }
            if (this.slot == this.max && ShortByteHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.key = 0;
                this.cursor.value = ShortByteHashMap.this.values[this.max];
                return this.cursor;
            }
            return (ShortByteCursor)this.done();
        }
    }
}

