/*
 * Decompiled with CFR 0.152.
 */
package com.codahale.metrics.httpclient5;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.httpclient5.HttpClientMetricNameStrategies;
import com.codahale.metrics.httpclient5.HttpClientMetricNameStrategy;
import com.codahale.metrics.httpclient5.InstrumentedHttpClientConnectionManager;
import com.codahale.metrics.httpclient5.InstrumentedHttpRequestExecutor;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;

public class InstrumentedHttpClients {
    private InstrumentedHttpClients() {
    }

    public static CloseableHttpClient createDefault(MetricRegistry metricRegistry) {
        return InstrumentedHttpClients.createDefault(metricRegistry, HttpClientMetricNameStrategies.METHOD_ONLY);
    }

    public static CloseableHttpClient createDefault(MetricRegistry metricRegistry, HttpClientMetricNameStrategy metricNameStrategy) {
        return InstrumentedHttpClients.custom(metricRegistry, metricNameStrategy).build();
    }

    public static HttpClientBuilder custom(MetricRegistry metricRegistry) {
        return InstrumentedHttpClients.custom(metricRegistry, HttpClientMetricNameStrategies.METHOD_ONLY);
    }

    public static HttpClientBuilder custom(MetricRegistry metricRegistry, HttpClientMetricNameStrategy metricNameStrategy) {
        return HttpClientBuilder.create().setRequestExecutor(new InstrumentedHttpRequestExecutor(metricRegistry, metricNameStrategy)).setConnectionManager(InstrumentedHttpClientConnectionManager.builder(metricRegistry).build());
    }
}

