/*
 * Decompiled with CFR 0.152.
 */
package com.conveyal.gtfs.error;

import com.conveyal.gtfs.error.GTFSError;
import java.io.Serializable;
import java.util.Locale;

public class RangeError
extends GTFSError
implements Serializable {
    public static final long serialVersionUID = 1L;
    final double min;
    final double max;
    final double actual;

    public RangeError(String file, long line, String field, double min2, double max, double actual) {
        super(file, line, field);
        this.min = min2;
        this.max = max;
        this.actual = actual;
    }

    @Override
    public String getMessage() {
        return String.format(Locale.getDefault(), "Number %s in field %s outside of acceptable range [%s,%s].", this.actual, this.field, this.min, this.max);
    }
}

