/*
 * Decompiled with CFR 0.152.
 */
package com.conveyal.gtfs.model;

import com.conveyal.gtfs.GTFSFeed;
import com.conveyal.gtfs.model.Entity;
import com.conveyal.gtfs.model.Trip;
import java.io.IOException;
import java.util.Locale;
import org.mapdb.Fun;

public class Frequency
extends Entity
implements Comparable<Frequency> {
    private static final long serialVersionUID = -7182161664471704133L;
    public String trip_id;
    public int start_time;
    public int end_time;
    public int headway_secs;
    public int exact_times;

    public String getId() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.trip_id);
        sb.append('_');
        sb.append(Entity.Writer.convertToGtfsTime(this.start_time));
        sb.append("_to_");
        sb.append(Entity.Writer.convertToGtfsTime(this.end_time));
        sb.append("_every_");
        sb.append(String.format(Locale.getDefault(), "%dm%02ds", this.headway_secs / 60, this.headway_secs % 60));
        if (this.exact_times == 1) {
            sb.append("_exact");
        }
        return sb.toString();
    }

    @Override
    public int compareTo(Frequency o) {
        return this.start_time - o.start_time;
    }

    public static class Loader
    extends Entity.Loader<Frequency> {
        public Loader(GTFSFeed feed) {
            super(feed, "frequencies");
        }

        @Override
        protected boolean isRequired() {
            return false;
        }

        @Override
        public void loadOneRow() throws IOException {
            Frequency f = new Frequency();
            Trip trip = this.getRefField("trip_id", true, this.feed.trips);
            f.sourceFileLine = this.row + 1L;
            f.trip_id = trip.trip_id;
            f.start_time = this.getTimeField("start_time", true);
            f.end_time = this.getTimeField("end_time", true);
            f.headway_secs = this.getIntField("headway_secs", true, 1, 86400);
            f.exact_times = this.getIntField("exact_times", false, 0, 1);
            f.feed = this.feed;
            this.feed.frequencies.add(Fun.t2(f.trip_id, f));
        }
    }
}

