/*
 * Decompiled with CFR 0.152.
 */
package com.conveyal.gtfs.model;

import com.conveyal.gtfs.GTFSFeed;
import com.conveyal.gtfs.model.Agency;
import com.conveyal.gtfs.model.Entity;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class Route
extends Entity {
    private static final long serialVersionUID = -819444896818029068L;
    public static final Map<Integer, Integer> EXTENTED_ROUTE_TYPE_MAPPING = new HashMap<Integer, Integer>();
    public String route_id;
    public String agency_id;
    public String route_short_name;
    public String route_long_name;
    public String route_desc;
    public int route_type;
    public URL route_url;
    public String route_color;
    public String route_text_color;
    public URL route_branding_url;
    public String feed_id;

    static {
        EXTENTED_ROUTE_TYPE_MAPPING.put(100, 2);
        EXTENTED_ROUTE_TYPE_MAPPING.put(101, 2);
        EXTENTED_ROUTE_TYPE_MAPPING.put(102, 2);
        EXTENTED_ROUTE_TYPE_MAPPING.put(103, 2);
        EXTENTED_ROUTE_TYPE_MAPPING.put(105, 2);
        EXTENTED_ROUTE_TYPE_MAPPING.put(106, 2);
        EXTENTED_ROUTE_TYPE_MAPPING.put(107, 2);
        EXTENTED_ROUTE_TYPE_MAPPING.put(108, 2);
        EXTENTED_ROUTE_TYPE_MAPPING.put(109, 2);
        EXTENTED_ROUTE_TYPE_MAPPING.put(200, 3);
        EXTENTED_ROUTE_TYPE_MAPPING.put(201, 3);
        EXTENTED_ROUTE_TYPE_MAPPING.put(202, 3);
        EXTENTED_ROUTE_TYPE_MAPPING.put(204, 3);
        EXTENTED_ROUTE_TYPE_MAPPING.put(208, 3);
        EXTENTED_ROUTE_TYPE_MAPPING.put(400, 1);
        EXTENTED_ROUTE_TYPE_MAPPING.put(401, 1);
        EXTENTED_ROUTE_TYPE_MAPPING.put(402, 1);
        EXTENTED_ROUTE_TYPE_MAPPING.put(405, 1);
        EXTENTED_ROUTE_TYPE_MAPPING.put(700, 3);
        EXTENTED_ROUTE_TYPE_MAPPING.put(701, 3);
        EXTENTED_ROUTE_TYPE_MAPPING.put(702, 3);
        EXTENTED_ROUTE_TYPE_MAPPING.put(704, 3);
        EXTENTED_ROUTE_TYPE_MAPPING.put(715, 3);
        EXTENTED_ROUTE_TYPE_MAPPING.put(717, 3);
        EXTENTED_ROUTE_TYPE_MAPPING.put(800, 3);
        EXTENTED_ROUTE_TYPE_MAPPING.put(900, 0);
        EXTENTED_ROUTE_TYPE_MAPPING.put(1000, 4);
        EXTENTED_ROUTE_TYPE_MAPPING.put(1300, 6);
        EXTENTED_ROUTE_TYPE_MAPPING.put(1400, 7);
        EXTENTED_ROUTE_TYPE_MAPPING.put(1501, 3);
        EXTENTED_ROUTE_TYPE_MAPPING.put(1700, 3);
    }

    public static class Loader
    extends Entity.Loader<Route> {
        public Loader(GTFSFeed feed) {
            super(feed, "routes");
        }

        @Override
        protected boolean isRequired() {
            return true;
        }

        @Override
        public void loadOneRow() throws IOException {
            Route r = new Route();
            r.sourceFileLine = this.row + 1L;
            r.route_id = this.getStringField("route_id", true);
            Agency agency = this.getRefField("agency_id", false, this.feed.agency);
            if (agency == null && this.feed.agency.size() == 1) {
                agency = this.feed.agency.values().iterator().next();
            }
            if (agency != null) {
                r.agency_id = agency.agency_id;
            }
            r.route_short_name = this.getStringField("route_short_name", false);
            r.route_long_name = this.getStringField("route_long_name", false);
            r.route_desc = this.getStringField("route_desc", false);
            r.route_type = this.getIntField("route_type", true, 0, 7, 0, EXTENTED_ROUTE_TYPE_MAPPING);
            r.route_url = this.getUrlField("route_url", false);
            r.route_color = this.getStringField("route_color", false);
            r.route_text_color = this.getStringField("route_text_color", false);
            r.route_branding_url = this.getUrlField("route_branding_url", false);
            r.feed = this.feed;
            r.feed_id = this.feed.feedId;
            this.feed.routes.put(r.route_id, r);
        }
    }
}

