/*
 * Decompiled with CFR 0.152.
 */
package com.conveyal.gtfs.model;

import com.conveyal.gtfs.GTFSFeed;
import com.conveyal.gtfs.model.Entity;
import java.io.IOException;
import org.mapdb.Fun;

public class ShapePoint
extends Entity {
    private static final long serialVersionUID = 6751814959971086070L;
    public final String shape_id;
    public final double shape_pt_lat;
    public final double shape_pt_lon;
    public final int shape_pt_sequence;
    public final double shape_dist_traveled;

    public ShapePoint(String shape_id, double shape_pt_lat, double shape_pt_lon, int shape_pt_sequence, double shape_dist_traveled) {
        this.shape_id = shape_id;
        this.shape_pt_lat = shape_pt_lat;
        this.shape_pt_lon = shape_pt_lon;
        this.shape_pt_sequence = shape_pt_sequence;
        this.shape_dist_traveled = shape_dist_traveled;
    }

    public static class Loader
    extends Entity.Loader<ShapePoint> {
        public Loader(GTFSFeed feed) {
            super(feed, "shapes");
        }

        @Override
        protected boolean isRequired() {
            return false;
        }

        @Override
        public void loadOneRow() throws IOException {
            String shape_id = this.getStringField("shape_id", true);
            double shape_pt_lat = this.getDoubleField("shape_pt_lat", true, -90.0, 90.0);
            double shape_pt_lon = this.getDoubleField("shape_pt_lon", true, -180.0, 180.0);
            int shape_pt_sequence = this.getIntField("shape_pt_sequence", true, 0, Integer.MAX_VALUE);
            double shape_dist_traveled = this.getDoubleField("shape_dist_traveled", false, 0.0, Double.MAX_VALUE);
            ShapePoint s2 = new ShapePoint(shape_id, shape_pt_lat, shape_pt_lon, shape_pt_sequence, shape_dist_traveled);
            s2.sourceFileLine = this.row + 1L;
            s2.feed = null;
            this.feed.shape_points.put(new Fun.Tuple2<String, Integer>(s2.shape_id, s2.shape_pt_sequence), s2);
        }
    }
}

