/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.shaded.msv_core.verifier.identity;

import com.ctc.wstx.shaded.msv.relaxng_datatype.Datatype;
import com.ctc.wstx.shaded.msv_core.driver.textui.Debug;
import com.ctc.wstx.shaded.msv_core.grammar.xmlschema.ElementDeclExp;
import com.ctc.wstx.shaded.msv_core.grammar.xmlschema.IdentityConstraint;
import com.ctc.wstx.shaded.msv_core.grammar.xmlschema.KeyRefConstraint;
import com.ctc.wstx.shaded.msv_core.grammar.xmlschema.XMLSchemaGrammar;
import com.ctc.wstx.shaded.msv_core.util.LightStack;
import com.ctc.wstx.shaded.msv_core.util.StartTagInfo;
import com.ctc.wstx.shaded.msv_core.verifier.Acceptor;
import com.ctc.wstx.shaded.msv_core.verifier.ErrorInfo;
import com.ctc.wstx.shaded.msv_core.verifier.ValidityViolation;
import com.ctc.wstx.shaded.msv_core.verifier.Verifier;
import com.ctc.wstx.shaded.msv_core.verifier.identity.KeyValue;
import com.ctc.wstx.shaded.msv_core.verifier.identity.Matcher;
import com.ctc.wstx.shaded.msv_core.verifier.identity.SelectorMatcher;
import com.ctc.wstx.shaded.msv_core.verifier.regexp.xmlschema.XSREDocDecl;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class IDConstraintChecker
extends Verifier {
    protected final XMLSchemaGrammar grammar;
    protected final Vector<Matcher> matchers = new Vector();
    private final Map<SelectorMatcher, Set<Object>> keyValues = new HashMap<SelectorMatcher, Set<Object>>();
    private final Map<SelectorMatcher, SelectorMatcher> referenceScope = new HashMap<SelectorMatcher, SelectorMatcher>();
    private final Map<IdentityConstraint, LightStack> activeScopes = new HashMap<IdentityConstraint, LightStack>();
    public static final String ERR_UNMATCHED_KEY_FIELD = "IdentityConstraint.UnmatchedKeyField";
    public static final String ERR_NOT_UNIQUE = "IdentityConstraint.NotUnique";
    public static final String ERR_NOT_UNIQUE_DIAG = "IdentityConstraint.NotUnique.Diag";
    public static final String ERR_DOUBLE_MATCH = "IdentityConstraint.DoubleMatch";
    public static final String ERR_UNDEFINED_KEY = "IdentityConstraint.UndefinedKey";

    public IDConstraintChecker(XMLSchemaGrammar grammar, ErrorHandler errorHandler) {
        super(new XSREDocDecl(grammar), errorHandler);
        this.grammar = grammar;
    }

    protected void add(Matcher matcher) {
        this.matchers.add(matcher);
    }

    protected void remove(Matcher matcher) {
        this.matchers.remove(matcher);
    }

    protected SelectorMatcher getActiveScope(IdentityConstraint c) {
        LightStack s2 = this.activeScopes.get(c);
        if (s2 == null) {
            return null;
        }
        if (s2.size() == 0) {
            return null;
        }
        return (SelectorMatcher)s2.top();
    }

    protected void pushActiveScope(IdentityConstraint c, SelectorMatcher matcher) {
        LightStack s2 = this.activeScopes.get(c);
        if (s2 == null) {
            s2 = new LightStack();
            this.activeScopes.put(c, s2);
        }
        s2.push(matcher);
    }

    protected void popActiveScope(IdentityConstraint c, SelectorMatcher matcher) {
        LightStack s2 = this.activeScopes.get(c);
        if (s2 == null) {
            throw new Error();
        }
        if (s2.pop() != matcher) {
            throw new Error();
        }
    }

    protected boolean addKeyValue(SelectorMatcher scope, KeyValue value) {
        Set<Object> keys2 = this.keyValues.get(scope);
        if (keys2 == null) {
            keys2 = new HashSet<Object>();
            this.keyValues.put(scope, keys2);
        }
        return keys2.add(value);
    }

    protected KeyValue[] getKeyValues(SelectorMatcher scope) {
        Set<Object> keys2 = this.keyValues.get(scope);
        if (keys2 == null) {
            return new KeyValue[0];
        }
        return keys2.toArray(new KeyValue[keys2.size()]);
    }

    @Override
    public void startDocument() throws SAXException {
        super.startDocument();
        this.keyValues.clear();
    }

    @Override
    public void endDocument() throws SAXException {
        super.endDocument();
        Map.Entry[] scopes = this.keyValues.entrySet().toArray(new Map.Entry[this.keyValues.size()]);
        if (Debug.debug) {
            System.out.println("key/keyref check: there are " + this.keyValues.size() + " scope(s)");
        }
        for (int i = 0; i < scopes.length; ++i) {
            SelectorMatcher key = (SelectorMatcher)scopes[i].getKey();
            Set value = (Set)scopes[i].getValue();
            if (!(key.idConst instanceof KeyRefConstraint)) continue;
            Set<Object> keys2 = this.keyValues.get(this.referenceScope.get(key));
            KeyValue[] keyrefs = value.toArray(new KeyValue[value.size()]);
            for (int j = 0; j < keyrefs.length; ++j) {
                if (keys2 != null && keys2.contains(keyrefs[j])) continue;
                this.reportError(keyrefs[j].locator, null, ERR_UNDEFINED_KEY, new Object[]{key.idConst.namespaceURI, key.idConst.localName});
            }
        }
    }

    @Override
    protected void onNextAcceptorReady(StartTagInfo sti, Acceptor next) throws SAXException {
        int len = this.matchers.size();
        for (int i = 0; i < len; ++i) {
            Matcher m4 = this.matchers.get(i);
            m4.startElement(sti.namespaceURI, sti.localName);
        }
        Object e = next.getOwnerType();
        if (e instanceof ElementDeclExp.XSElementExp) {
            ElementDeclExp.XSElementExp exp = (ElementDeclExp.XSElementExp)e;
            if (exp.identityConstraints != null) {
                int i;
                int m5 = exp.identityConstraints.size();
                for (i = 0; i < m5; ++i) {
                    this.add(new SelectorMatcher(this, (IdentityConstraint)exp.identityConstraints.get(i), sti.namespaceURI, sti.localName));
                }
                for (i = 0; i < m5; ++i) {
                    IdentityConstraint c = (IdentityConstraint)exp.identityConstraints.get(i);
                    if (!(c instanceof KeyRefConstraint)) continue;
                    SelectorMatcher keyScope = this.getActiveScope(((KeyRefConstraint)c).key);
                    if (keyScope == null) {
                        // empty if block
                    }
                    this.referenceScope.put(this.getActiveScope(c), keyScope);
                }
            }
        }
    }

    @Override
    protected Datatype[] feedAttribute(Acceptor child, String uri, String localName, String qName, String value) throws SAXException {
        Datatype[] result = super.feedAttribute(child, uri, localName, qName, value);
        int len = this.matchers.size();
        for (int i = 0; i < len; ++i) {
            Matcher m4 = this.matchers.get(i);
            m4.onAttribute(uri, localName, value, result == null || result.length == 0 ? null : result[0]);
        }
        return result;
    }

    @Override
    public void characters(char[] buf, int start, int len) throws SAXException {
        super.characters(buf, start, len);
        int m4 = this.matchers.size();
        for (int i = 0; i < m4; ++i) {
            this.matchers.get(i).characters(buf, start, len);
        }
    }

    @Override
    public void endElement(String namespaceUri, String localName, String qName) throws SAXException {
        super.endElement(namespaceUri, localName, qName);
        Datatype[] lastType = this.getLastCharacterType();
        Datatype dt = lastType == null || lastType.length == 0 ? null : this.getLastCharacterType()[0];
        int len = this.matchers.size();
        for (int i = len - 1; i >= 0; --i) {
            this.matchers.get(i).endElement(dt);
        }
    }

    protected void reportError(ErrorInfo ei, String propKey, Object[] args2) throws SAXException {
        this.reportError(this.getLocator(), ei, propKey, args2);
    }

    protected void reportError(Locator loc, ErrorInfo ei, String propKey, Object[] args2) throws SAXException {
        this.hadError = true;
        this.errorHandler.error(new ValidityViolation(loc, IDConstraintChecker.localizeMessage(propKey, args2), ei));
    }

    public static String localizeMessage(String propertyName, Object arg) {
        return IDConstraintChecker.localizeMessage(propertyName, new Object[]{arg});
    }

    public static String localizeMessage(String propertyName, Object[] args2) {
        String format = ResourceBundle.getBundle("com.ctc.wstx.shaded.msv_core.verifier.identity.Messages").getString(propertyName);
        return MessageFormat.format(format, args2);
    }
}

