/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.jakarta.rs.xml;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.jakarta.rs.base.ProviderBase;
import com.fasterxml.jackson.jakarta.rs.cfg.Annotations;
import com.fasterxml.jackson.jakarta.rs.xml.PackageVersion;
import com.fasterxml.jackson.jakarta.rs.xml.XMLEndpointConfig;
import com.fasterxml.jackson.jakarta.rs.xml.XMLMapperConfigurator;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.ext.Provider;
import jakarta.ws.rs.ext.Providers;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.lang.annotation.Annotation;

@Provider
@Consumes(value={"*/*"})
@Produces(value={"application/xml", "text/xml", "*/*"})
public class JacksonXMLProvider
extends ProviderBase<JacksonXMLProvider, XmlMapper, XMLEndpointConfig, XMLMapperConfigurator> {
    public static final Annotations[] BASIC_ANNOTATIONS = new Annotations[]{Annotations.JACKSON};
    @Context
    protected Providers _providers;

    public JacksonXMLProvider() {
        this((XmlMapper)null, BASIC_ANNOTATIONS);
    }

    public JacksonXMLProvider(Annotations ... annotationsToUse) {
        this((XmlMapper)null, annotationsToUse);
    }

    public JacksonXMLProvider(XmlMapper mapper) {
        this(mapper, BASIC_ANNOTATIONS);
    }

    public JacksonXMLProvider(XmlMapper mapper, Annotations[] annotationsToUse) {
        super(new XMLMapperConfigurator(mapper, annotationsToUse));
    }

    @Override
    public Version version() {
        return PackageVersion.VERSION;
    }

    @Override
    protected XMLEndpointConfig _configForReading(ObjectReader reader, Annotation[] annotations) {
        return XMLEndpointConfig.forReading(reader, annotations);
    }

    @Override
    protected XMLEndpointConfig _configForWriting(ObjectWriter writer, Annotation[] annotations) {
        return XMLEndpointConfig.forWriting(writer, annotations);
    }

    @Override
    protected boolean hasMatchingMediaType(MediaType mediaType) {
        if (mediaType != null) {
            String subtype = mediaType.getSubtype();
            return "xml".equalsIgnoreCase(subtype) || subtype.endsWith("+xml");
        }
        return true;
    }

    @Override
    public XmlMapper _locateMapperViaProvider(Class<?> type, MediaType mediaType) {
        XmlMapper m4 = ((XMLMapperConfigurator)this._mapperConfig).getConfiguredMapper();
        if (m4 == null && (m4 = this._locateMapperViaProvider(type, mediaType, XmlMapper.class, this._providers)) == null) {
            m4 = ((XMLMapperConfigurator)this._mapperConfig).getDefaultMapper();
        }
        return m4;
    }

    @Override
    protected JsonParser _createParser(ObjectReader reader, InputStream rawStream) throws IOException {
        PushbackInputStream wrappedStream = new PushbackInputStream(rawStream);
        int firstByte = wrappedStream.read();
        if (firstByte == -1) {
            return null;
        }
        wrappedStream.unread(firstByte);
        return reader.getFactory().createParser(wrappedStream);
    }
}

