/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.blackbird.deser;

import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdValueInstantiator;
import java.io.IOException;
import java.util.function.Function;
import java.util.function.Supplier;

class OptimizedValueInstantiator
extends StdValueInstantiator {
    private static final long serialVersionUID = 1L;
    private final Supplier<?> _optimizedDefaultCreator;
    private final Function<Object[], Object> _optimizedArgsCreator;

    protected OptimizedValueInstantiator(StdValueInstantiator original, Supplier<?> defaultCreator, Function<Object[], Object> argsCreator) {
        super(original);
        this._optimizedDefaultCreator = defaultCreator;
        this._optimizedArgsCreator = argsCreator;
    }

    @Override
    public boolean canCreateUsingDefault() {
        return this._optimizedDefaultCreator != null || super.canCreateUsingDefault();
    }

    @Override
    public boolean canCreateFromObjectWith() {
        return this._optimizedArgsCreator != null || super.canCreateFromObjectWith();
    }

    @Override
    public Object createUsingDefault(DeserializationContext ctxt) throws IOException {
        if (this._optimizedDefaultCreator != null) {
            try {
                return this._optimizedDefaultCreator.get();
            }
            catch (Exception e) {
                return ctxt.handleInstantiationProblem(this._valueClass, null, e);
            }
        }
        return super.createUsingDefault(ctxt);
    }

    @Override
    public Object createFromObjectWith(DeserializationContext ctxt, Object[] args2) throws IOException {
        if (this._optimizedArgsCreator != null) {
            try {
                return this._optimizedArgsCreator.apply(args2);
            }
            catch (Exception e) {
                return ctxt.handleInstantiationProblem(this._valueClass, args2, e);
            }
        }
        return super.createFromObjectWith(ctxt, args2);
    }
}

