/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.apache.commons.lang3;

public class StringUtils {
    public static int getLevenshteinDistance(CharSequence s2, CharSequence t2) {
        int i;
        if (s2 == null || t2 == null) {
            throw new IllegalArgumentException("Strings must not be null");
        }
        int n = s2.length();
        int m4 = t2.length();
        if (n == 0) {
            return m4;
        }
        if (m4 == 0) {
            return n;
        }
        if (n > m4) {
            CharSequence tmp = s2;
            s2 = t2;
            t2 = tmp;
            n = m4;
            m4 = t2.length();
        }
        int[] p = new int[n + 1];
        for (i = 0; i <= n; ++i) {
            p[i] = i;
        }
        for (int j = 1; j <= m4; ++j) {
            int upper_left = p[0];
            char t_j = t2.charAt(j - 1);
            p[0] = j;
            for (i = 1; i <= n; ++i) {
                int upper = p[i];
                int cost = s2.charAt(i - 1) == t_j ? 0 : 1;
                p[i] = Math.min(Math.min(p[i - 1] + 1, p[i] + 1), upper_left + cost);
                upper_left = upper;
            }
        }
        return p[n];
    }
}

