/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.config;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.graphhopper.util.CustomModel;
import com.graphhopper.util.Helper;
import com.graphhopper.util.PMap;
import com.graphhopper.util.TurnCostsConfig;
import java.util.Collections;
import java.util.List;

public class Profile {
    private String name;
    private TurnCostsConfig turnCostsConfig;
    private String weighting = "custom";
    private PMap hints = new PMap();

    public static void validateProfileName(String profileName) {
        if (!profileName.matches("^[a-z0-9_\\-]+$")) {
            throw new IllegalArgumentException("Profile names may only contain lower case letters, numbers and underscores, given: " + profileName);
        }
    }

    private Profile() {
    }

    public Profile(String name) {
        this.setName(name);
        this.setCustomModel(new CustomModel());
    }

    public Profile(Profile p) {
        this.setName(p.getName());
        this.setTurnCostsConfig(p.getTurnCostsConfig());
        this.setWeighting(p.getWeighting());
        this.hints = new PMap(p.getHints());
    }

    public String getName() {
        return this.name;
    }

    public Profile setName(String name) {
        Profile.validateProfileName(name);
        this.name = name;
        return this;
    }

    public Profile setTurnCostsConfig(TurnCostsConfig turnCostsConfig) {
        this.turnCostsConfig = turnCostsConfig;
        return this;
    }

    @JsonProperty(value="turn_costs")
    public TurnCostsConfig getTurnCostsConfig() {
        return this.turnCostsConfig;
    }

    public String getWeighting() {
        return this.weighting;
    }

    public Profile setWeighting(String weighting) {
        this.weighting = weighting;
        return this;
    }

    public Profile setCustomModel(CustomModel customModel) {
        if (customModel != null) {
            customModel.internal();
        }
        this.getHints().putObject("custom_model", customModel);
        return this;
    }

    public CustomModel getCustomModel() {
        return this.getHints().getObject("custom_model", null);
    }

    public boolean hasTurnCosts() {
        return this.turnCostsConfig != null;
    }

    @JsonIgnore
    public PMap getHints() {
        return this.hints;
    }

    @JsonAnySetter
    public Profile putHint(String key, Object value) {
        if (key.equals("u_turn_costs")) {
            throw new IllegalArgumentException("u_turn_costs no longer accepted in profile. Use the turn costs configuration instead, see docs/migration/config-migration-08-09.md");
        }
        if (key.equals("vehicle")) {
            throw new IllegalArgumentException("vehicle no longer accepted in profile, see docs/migration/config-migration-08-09.md");
        }
        this.hints.putObject(key, value);
        return this;
    }

    public String toString() {
        return this.createContentString(Collections.emptyList());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Profile profile = (Profile)o;
        return this.name.equals(profile.name);
    }

    private String createContentString(List<String> excludedHints) {
        PMap filteredHints = new PMap(this.hints);
        excludedHints.forEach(filteredHints::remove);
        return "name=" + this.name + "|turn_costs={" + String.valueOf(this.turnCostsConfig) + "}|weighting=" + this.weighting + "|hints=" + String.valueOf(filteredHints);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public int getVersion() {
        return this.getVersion(Collections.emptyList());
    }

    public int getVersion(List<String> excludedHints) {
        return Helper.staticHashCode(this.createContentString(excludedHints));
    }
}

