/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.gtfs;

import com.google.common.collect.Iterators;
import com.google.transit.realtime.GtfsRealtime;
import com.graphhopper.gtfs.GtfsStorage;
import com.graphhopper.gtfs.Label;
import com.graphhopper.gtfs.PtGraph;
import com.graphhopper.gtfs.RealtimeFeed;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.Graph;
import com.graphhopper.util.EdgeExplorer;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.EdgeIteratorState;
import java.time.Instant;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterators;
import java.util.function.Consumer;

public final class GraphExplorer {
    private final EdgeExplorer edgeExplorer;
    private final GtfsStorage gtfsStorage;
    private final RealtimeFeed realtimeFeed;
    private final boolean reverse;
    private final Weighting accessEgressWeighting;
    private final boolean streetOnly;
    private final boolean ptOnly;
    private final double walkSpeedKmH;
    private final boolean ignoreValidities;
    private final int blockedRouteTypes;
    private final PtGraph ptGraph;
    private final Graph graph;

    public GraphExplorer(Graph graph, PtGraph ptGraph, Weighting accessEgressWeighting, GtfsStorage gtfsStorage, RealtimeFeed realtimeFeed, boolean reverse, boolean streetOnly, boolean ptOnly, double walkSpeedKmh, boolean ignoreValidities, int blockedRouteTypes) {
        this.graph = graph;
        this.ptGraph = ptGraph;
        this.accessEgressWeighting = accessEgressWeighting;
        this.ignoreValidities = ignoreValidities;
        this.blockedRouteTypes = blockedRouteTypes;
        this.edgeExplorer = graph.createEdgeExplorer();
        this.gtfsStorage = gtfsStorage;
        this.realtimeFeed = realtimeFeed;
        this.reverse = reverse;
        this.streetOnly = streetOnly;
        this.ptOnly = ptOnly;
        this.walkSpeedKmH = walkSpeedKmh;
    }

    public Iterable<MultiModalEdge> exploreEdgesAround(Label label) {
        return () -> {
            Iterator ptEdges = label.node.ptNode != -1 ? this.ptEdgeStream(label.node.ptNode, label.currentTime).iterator() : Collections.emptyIterator();
            Iterator streetEdges = label.node.streetNode != -1 ? this.streetEdgeStream(label.node.streetNode).iterator() : Collections.emptyIterator();
            return Iterators.concat(ptEdges, streetEdges);
        };
    }

    private Iterable<PtGraph.PtEdge> realtimeEdgesAround(int node) {
        return () -> this.realtimeFeed.getAdditionalEdgesFrom(node).stream().iterator();
    }

    private Iterable<PtGraph.PtEdge> backRealtimeEdgesAround(int node) {
        return () -> this.realtimeFeed.getAdditionalEdgesTo(node).stream().map(e -> new PtGraph.PtEdge(e.getId(), e.getAdjNode(), e.getBaseNode(), e.getAttrs())).iterator();
    }

    public Iterable<MultiModalEdge> ptEdgeStream(final int ptNode, final long currentTime) {
        return () -> Spliterators.iterator(new Spliterators.AbstractSpliterator<MultiModalEdge>(0L, 0){
            final Iterator<PtGraph.PtEdge> edgeIterator;
            {
                super(arg0, arg1);
                this.edgeIterator = GraphExplorer.this.reverse ? Iterators.concat(ptNode < GraphExplorer.this.ptGraph.getNodeCount() ? GraphExplorer.this.ptGraph.backEdgesAround(ptNode).iterator() : Collections.emptyIterator(), GraphExplorer.this.backRealtimeEdgesAround(ptNode).iterator()) : Iterators.concat(ptNode < GraphExplorer.this.ptGraph.getNodeCount() ? GraphExplorer.this.ptGraph.edgesAround(ptNode).iterator() : Collections.emptyIterator(), GraphExplorer.this.realtimeEdgesAround(ptNode).iterator());
            }

            @Override
            public boolean tryAdvance(Consumer<? super MultiModalEdge> action) {
                while (this.edgeIterator.hasNext()) {
                    PtGraph.PtEdge edge = this.edgeIterator.next();
                    GtfsStorage.EdgeType edgeType = edge.getType();
                    if (edgeType == GtfsStorage.EdgeType.ENTER_TIME_EXPANDED_NETWORK) {
                        if (GraphExplorer.this.streetOnly) {
                            return false;
                        }
                        action.accept(new MultiModalEdge(this.findEnterEdge(edge)));
                        return true;
                    }
                    if (GraphExplorer.this.streetOnly && edgeType != (GraphExplorer.this.reverse ? GtfsStorage.EdgeType.EXIT_PT : GtfsStorage.EdgeType.ENTER_PT) || !GraphExplorer.this.ignoreValidities && !GraphExplorer.this.isValidOn(edge, currentTime) || edgeType == GtfsStorage.EdgeType.WAIT_ARRIVAL && !GraphExplorer.this.reverse || edgeType == GtfsStorage.EdgeType.ENTER_PT && GraphExplorer.this.reverse && GraphExplorer.this.ptOnly || edgeType == GtfsStorage.EdgeType.EXIT_PT && !GraphExplorer.this.reverse && GraphExplorer.this.ptOnly || (edgeType == GtfsStorage.EdgeType.ENTER_PT || edgeType == GtfsStorage.EdgeType.EXIT_PT || edgeType == GtfsStorage.EdgeType.TRANSFER) && (GraphExplorer.this.blockedRouteTypes & 1 << edge.getAttrs().route_type) != 0) continue;
                    action.accept(new MultiModalEdge(edge));
                    return true;
                }
                return false;
            }

            private PtGraph.PtEdge findEnterEdge(PtGraph.PtEdge first) {
                long firstTT = GraphExplorer.this.calcTravelTimeMillis(first, currentTime);
                while (this.edgeIterator.hasNext()) {
                    PtGraph.PtEdge result = this.edgeIterator.next();
                    long nextTT = GraphExplorer.this.calcTravelTimeMillis(result, currentTime);
                    if (nextTT >= firstTT) continue;
                    this.edgeIterator.forEachRemaining((? super E ptEdge) -> {});
                    return result;
                }
                return first;
            }
        });
    }

    private Iterable<MultiModalEdge> streetEdgeStream(final int streetNode) {
        return () -> Spliterators.iterator(new Spliterators.AbstractSpliterator<MultiModalEdge>(0L, 0){
            final EdgeIterator e;
            {
                super(arg0, arg1);
                this.e = GraphExplorer.this.edgeExplorer.setBaseNode(streetNode);
            }

            @Override
            public boolean tryAdvance(Consumer<? super MultiModalEdge> action) {
                while (this.e.next()) {
                    long travelTimeOrInfty;
                    if (!Double.isFinite(GraphExplorer.this.accessEgressWeighting.calcEdgeWeight(this.e, GraphExplorer.this.reverse)) || (travelTimeOrInfty = GraphExplorer.this.accessEgressWeighting.calcEdgeMillis(this.e.detach(false), GraphExplorer.this.reverse)) == Long.MAX_VALUE) continue;
                    action.accept(new MultiModalEdge(this.e.getEdge(), this.e.getBaseNode(), this.e.getAdjNode(), (long)((double)travelTimeOrInfty * (5.0 / GraphExplorer.this.walkSpeedKmH)), this.e.getDistance()));
                    return true;
                }
                return false;
            }
        });
    }

    long calcTravelTimeMillis(MultiModalEdge edge, long earliestStartTime) {
        switch (edge.getType()) {
            case ENTER_TIME_EXPANDED_NETWORK: {
                if (this.reverse) {
                    return 0L;
                }
                return this.waitingTime(edge.ptEdge, earliestStartTime);
            }
            case LEAVE_TIME_EXPANDED_NETWORK: {
                if (this.reverse) {
                    return -this.waitingTime(edge.ptEdge, earliestStartTime);
                }
                return 0L;
            }
        }
        return edge.getTime();
    }

    long calcTravelTimeMillis(PtGraph.PtEdge edge, long earliestStartTime) {
        switch (edge.getType()) {
            case ENTER_TIME_EXPANDED_NETWORK: {
                if (this.reverse) {
                    return 0L;
                }
                return this.waitingTime(edge, earliestStartTime);
            }
            case LEAVE_TIME_EXPANDED_NETWORK: {
                if (this.reverse) {
                    return -this.waitingTime(edge, earliestStartTime);
                }
                return 0L;
            }
        }
        return edge.getTime();
    }

    public boolean isBlocked(MultiModalEdge edge) {
        return this.realtimeFeed.isBlocked(edge.getId());
    }

    long getDelayFromBoardEdge(MultiModalEdge edge, long currentTime) {
        return this.realtimeFeed.getDelayForBoardEdge(edge.ptEdge, Instant.ofEpochMilli(currentTime));
    }

    long getDelayFromAlightEdge(MultiModalEdge edge, long currentTime) {
        return this.realtimeFeed.getDelayForAlightEdge(edge.ptEdge, Instant.ofEpochMilli(currentTime));
    }

    private long waitingTime(PtGraph.PtEdge edge, long earliestStartTime) {
        long l = (long)edge.getTime() * 1000L - this.millisOnTravelDay(edge, earliestStartTime);
        if (!this.reverse) {
            if (l < 0L) {
                l += 86400000L;
            }
        } else if (l > 0L) {
            l -= 86400000L;
        }
        return l;
    }

    private long millisOnTravelDay(PtGraph.PtEdge edge, long instant) {
        ZoneId zoneId = edge.getAttrs().feedIdWithTimezone.zoneId;
        return Instant.ofEpochMilli(instant).atZone(zoneId).toLocalTime().toNanoOfDay() / 1000000L;
    }

    private boolean isValidOn(PtGraph.PtEdge edge, long instant) {
        if (edge.getType() == GtfsStorage.EdgeType.BOARD || edge.getType() == GtfsStorage.EdgeType.ALIGHT) {
            GtfsStorage.Validity validity = edge.getAttrs().validity;
            int trafficDay = (int)ChronoUnit.DAYS.between(validity.start, Instant.ofEpochMilli(instant).atZone(validity.zoneId).toLocalDate());
            return trafficDay >= 0 && validity.validity.get(trafficDay);
        }
        return true;
    }

    public List<Label.Transition> walkPath(int[] skippedEdgesForTransfer, long currentTime) {
        EdgeIteratorState firstEdge = this.graph.getEdgeIteratorStateForKey(skippedEdgesForTransfer[0]);
        Label label = new Label(currentTime, null, new Label.NodeId(firstEdge.getBaseNode(), -1), 0, null, 0L, 0L, 0L, false, null);
        for (int i : skippedEdgesForTransfer) {
            EdgeIteratorState e = this.graph.getEdgeIteratorStateForKey(i);
            MultiModalEdge multiModalEdge = new MultiModalEdge(e.getEdge(), e.getBaseNode(), e.getAdjNode(), (long)((double)this.accessEgressWeighting.calcEdgeMillis(e, this.reverse) * (5.0 / this.walkSpeedKmH)), e.getDistance());
            label = new Label(label.currentTime + multiModalEdge.time, multiModalEdge, new Label.NodeId(e.getAdjNode(), -1), 0, null, 0L, 0L, 0L, false, label);
        }
        return Label.getTransitions(label, false);
    }

    public class MultiModalEdge {
        private int baseNode;
        private int adjNode;
        private long time;
        private double distance;
        private int edge;
        private PtGraph.PtEdge ptEdge;

        public MultiModalEdge(PtGraph.PtEdge ptEdge) {
            this.ptEdge = ptEdge;
        }

        public MultiModalEdge(int edge, int baseNode, int adjNode, long time, double distance) {
            this.edge = edge;
            this.baseNode = baseNode;
            this.adjNode = adjNode;
            this.time = time;
            this.distance = distance;
        }

        public GtfsStorage.EdgeType getType() {
            return this.ptEdge != null ? this.ptEdge.getType() : GtfsStorage.EdgeType.HIGHWAY;
        }

        public int getTransfers() {
            return this.ptEdge != null ? this.ptEdge.getAttrs().transfers : 0;
        }

        public int getId() {
            return this.ptEdge != null ? this.ptEdge.getId() : this.edge;
        }

        public Label.NodeId getAdjNode() {
            if (this.ptEdge != null) {
                return new Label.NodeId(GraphExplorer.this.gtfsStorage.getPtToStreet().getOrDefault(this.ptEdge.getAdjNode(), -1), this.ptEdge.getAdjNode());
            }
            return new Label.NodeId(this.adjNode, GraphExplorer.this.gtfsStorage.getStreetToPt().getOrDefault(this.adjNode, -1));
        }

        public long getTime() {
            return this.ptEdge != null ? (long)this.ptEdge.getTime() * 1000L : this.time;
        }

        public String toString() {
            return "MultiModalEdge{" + this.baseNode + "->" + this.adjNode + ", time=" + this.time + ", edge=" + this.edge + ", ptEdge=" + String.valueOf(this.ptEdge) + "}";
        }

        public double getDistance() {
            return this.distance;
        }

        public int getRouteType() {
            return this.ptEdge.getRouteType();
        }

        public int getStopSequence() {
            return this.ptEdge.getAttrs().stop_sequence;
        }

        public GtfsRealtime.TripDescriptor getTripDescriptor() {
            return this.ptEdge.getAttrs().tripDescriptor;
        }

        public GtfsStorage.PlatformDescriptor getPlatformDescriptor() {
            return this.ptEdge.getAttrs().platformDescriptor;
        }
    }
}

