/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.gtfs;

import com.conveyal.gtfs.GTFSFeed;
import com.conveyal.gtfs.model.Stop;
import com.conveyal.gtfs.model.Transfer;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimaps;
import com.graphhopper.GraphHopper;
import com.graphhopper.GraphHopperConfig;
import com.graphhopper.config.Profile;
import com.graphhopper.gtfs.GraphExplorer;
import com.graphhopper.gtfs.GtfsReader;
import com.graphhopper.gtfs.GtfsStorage;
import com.graphhopper.gtfs.Label;
import com.graphhopper.gtfs.MultiCriteriaLabelSetting;
import com.graphhopper.gtfs.PtGraph;
import com.graphhopper.gtfs.RealtimeFeed;
import com.graphhopper.gtfs.Transfers;
import com.graphhopper.gtfs.TripFromLabel;
import com.graphhopper.gtfs.Trips;
import com.graphhopper.routing.ev.Subnetwork;
import com.graphhopper.routing.querygraph.QueryGraph;
import com.graphhopper.routing.util.DefaultSnapFilter;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.index.InMemConstructionIndex;
import com.graphhopper.storage.index.IndexStructureInfo;
import com.graphhopper.storage.index.LineIntIndex;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.PMap;
import com.graphhopper.util.shapes.BBox;
import java.io.File;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphHopperGtfs
extends GraphHopper {
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphHopperGtfs.class);
    private final GraphHopperConfig ghConfig;
    private GtfsStorage gtfsStorage;
    private PtGraph ptGraph;

    public GraphHopperGtfs(GraphHopperConfig ghConfig) {
        this.ghConfig = ghConfig;
    }

    @Override
    protected void importOSM() {
        if (this.ghConfig.has("datareader.file")) {
            super.importOSM();
        } else {
            this.createBaseGraphAndProperties();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void importPublicTransit() {
        this.ptGraph = new PtGraph(this.getBaseGraph().getDirectory(), 100);
        this.gtfsStorage = new GtfsStorage(this.getBaseGraph().getDirectory());
        this.gtfsStorage.setPtGraph(this.ptGraph);
        LineIntIndex stopIndex = new LineIntIndex(new BBox(-180.0, 180.0, -90.0, 90.0), this.getBaseGraph().getDirectory(), "stop_index");
        if (this.getGtfsStorage().loadExisting()) {
            this.ptGraph.loadExisting();
            stopIndex.loadExisting();
            if (this.ghConfig.getBool("gtfs.trip_based", false)) {
                for (String trafficDayString : this.ghConfig.getString("gtfs.schedule_day", null).split(",")) {
                    LocalDate trafficDay = LocalDate.parse(trafficDayString);
                    LOGGER.info("Loading trip-based transfers for pt router. Schedule day: {}", (Object)trafficDay);
                    this.gtfsStorage.tripTransfers.getTripTransfers().put(trafficDay, this.gtfsStorage.deserializeTripTransfersMap("trip_transfers_" + trafficDayString));
                }
                for (Map.Entry entry : this.gtfsStorage.getGtfsFeeds().entrySet()) {
                    for (Stop stop : ((GTFSFeed)entry.getValue()).stops.values()) {
                        this.gtfsStorage.tripTransfers.getPatternBoardings(new GtfsStorage.FeedIdWithStopId((String)entry.getKey(), stop.stop_id));
                    }
                }
            }
        } else {
            this.ensureWriteAccess();
            this.getGtfsStorage().create();
            this.ptGraph.create(100L);
            InMemConstructionIndex indexBuilder = new InMemConstructionIndex(IndexStructureInfo.create(new BBox(-180.0, 180.0, -90.0, 90.0), 300));
            try {
                boolean bl = false;
                List<String> gtfsFiles = this.ghConfig.has("gtfs.file") ? Arrays.asList(this.ghConfig.getString("gtfs.file", "").split(",")) : Collections.emptyList();
                for (String gtfsFile : gtfsFiles) {
                    void var3_7;
                    this.getGtfsStorage().loadGtfsFromZipFileOrDirectory("gtfs_" + (int)(++var3_7), new File(gtfsFile));
                }
                this.getGtfsStorage().postInit();
                HashMap<String, Transfers> allTransfers = new HashMap<String, Transfers>();
                HashMap<String, GtfsReader> allReaders = new HashMap<String, GtfsReader>();
                this.getGtfsStorage().getGtfsFeeds().forEach((id, gtfsFeed) -> {
                    Transfers transfers = new Transfers((GTFSFeed)gtfsFeed);
                    allTransfers.put((String)id, transfers);
                    GtfsReader gtfsReader = new GtfsReader((String)id, this.ptGraph, this.ptGraph, this.getGtfsStorage(), this.getLocationIndex(), transfers, indexBuilder);
                    List snapFilters = this.getProfiles().stream().map(p -> new DefaultSnapFilter(this.createWeighting((Profile)p, new PMap()), this.getEncodingManager().getBooleanEncodedValue(Subnetwork.key(p.getName())))).collect(Collectors.toList());
                    gtfsReader.connectStopsToStreetNetwork(e -> {
                        for (DefaultSnapFilter snapFilter : snapFilters) {
                            if (snapFilter.accept(e)) continue;
                            return false;
                        }
                        return true;
                    });
                    LOGGER.info("Building transit graph for feed {}", (Object)gtfsFeed.feedId);
                    gtfsReader.buildPtNetwork();
                    allReaders.put((String)id, gtfsReader);
                });
                this.interpolateTransfers(allReaders, allTransfers);
                if (this.ghConfig.getBool("gtfs.trip_based", false)) {
                    ArrayListMultimap<Integer, GtfsStorage.FeedIdWithStopId> stopsForStationNode = Multimaps.invertFrom(Multimaps.forMap(this.gtfsStorage.getStationNodes()), ArrayListMultimap.create());
                    for (String trafficDayString : this.ghConfig.getString("gtfs.schedule_day", null).split(",")) {
                        LocalDate trafficDay = LocalDate.parse(trafficDayString);
                        LOGGER.info("Computing trip-based transfers for pt router. Schedule day: {}", (Object)trafficDay);
                        Map<Trips.TripAtStopTime, Collection<Trips.TripAtStopTime>> tripTransfersMap = this.gtfsStorage.tripTransfers.getTripTransfers(trafficDay);
                        this.gtfsStorage.tripTransfers.findAllTripTransfersInto(tripTransfersMap, trafficDay, allTransfers, stopsForStationNode);
                        LOGGER.info("Writing. Schedule day: {}", (Object)trafficDay);
                        this.gtfsStorage.serializeTripTransfersMap("trip_transfers_" + trafficDayString, tripTransfersMap);
                    }
                }
            }
            catch (Exception exception) {
                throw new RuntimeException("Error while constructing transit network. Is your GTFS file valid? Please check log for possible causes.", exception);
            }
            this.ptGraph.flush();
            this.getGtfsStorage().flush();
            stopIndex.store(indexBuilder);
            stopIndex.flush();
        }
        this.gtfsStorage.setStopIndex(stopIndex);
    }

    private void interpolateTransfers(HashMap<String, GtfsReader> readers, Map<String, Transfers> allTransfers) {
        LOGGER.info("Looking for transfers");
        int maxTransferWalkTimeSeconds = this.ghConfig.getInt("gtfs.max_transfer_interpolation_walk_time_seconds", 120);
        QueryGraph queryGraph = QueryGraph.create(this.getBaseGraph(), Collections.emptyList());
        Weighting transferWeighting = this.createWeighting(this.getProfile("foot"), new PMap());
        GraphExplorer graphExplorer = new GraphExplorer(queryGraph, this.ptGraph, transferWeighting, this.getGtfsStorage(), RealtimeFeed.empty(), true, true, false, 5.0, false, 0);
        this.getGtfsStorage().getStationNodes().values().stream().distinct().map(n -> new Label.NodeId(this.gtfsStorage.getPtToStreet().getOrDefault((int)n, -1), (int)n)).forEach(stationNode -> {
            MultiCriteriaLabelSetting router = new MultiCriteriaLabelSetting(graphExplorer, true, false, false, 0L, new ArrayList<Label>());
            router.setLimitStreetTime(Duration.ofSeconds(maxTransferWalkTimeSeconds).toMillis());
            for (Label label : router.calcLabels((Label.NodeId)stationNode, Instant.ofEpochMilli(0L))) {
                if (label.parent == null || label.edge.getType() != GtfsStorage.EdgeType.EXIT_PT) continue;
                GtfsStorage.PlatformDescriptor fromPlatformDescriptor = label.edge.getPlatformDescriptor();
                Transfers transfers = (Transfers)allTransfers.get(fromPlatformDescriptor.feed_id);
                for (PtGraph.PtEdge ptEdge : this.ptGraph.edgesAround(stationNode.ptNode)) {
                    if (ptEdge.getType() != GtfsStorage.EdgeType.ENTER_PT) continue;
                    GtfsStorage.PlatformDescriptor toPlatformDescriptor = ptEdge.getAttrs().platformDescriptor;
                    LOGGER.debug(String.valueOf(fromPlatformDescriptor) + " -> " + String.valueOf(toPlatformDescriptor));
                    if (!toPlatformDescriptor.feed_id.equals(fromPlatformDescriptor.feed_id)) {
                        LOGGER.debug(" Different feed. Inserting transfer with " + (int)(label.streetTime / 1000L) + " s.");
                        this.insertInterpolatedTripTransfer(fromPlatformDescriptor, toPlatformDescriptor, (int)(label.streetTime / 1000L), this.getSkippedEdgesForTransfer(label));
                        this.insertInterpolatedTransfer(label, toPlatformDescriptor, readers, this.getSkippedEdgesForTransfer(label));
                        continue;
                    }
                    List<Transfer> transfersToStop = transfers.getTransfersToStop(toPlatformDescriptor.stop_id, this.routeIdOrNull(toPlatformDescriptor));
                    if (!transfersToStop.stream().noneMatch(t2 -> t2.from_stop_id.equals(fromPlatformDescriptor.stop_id))) continue;
                    LOGGER.debug("  Inserting transfer with " + (int)(label.streetTime / 1000L) + " s.");
                    this.insertInterpolatedTripTransfer(fromPlatformDescriptor, toPlatformDescriptor, (int)(label.streetTime / 1000L), this.getSkippedEdgesForTransfer(label));
                    this.insertInterpolatedTransfer(label, toPlatformDescriptor, readers, this.getSkippedEdgesForTransfer(label));
                }
            }
        });
    }

    private void insertInterpolatedTripTransfer(GtfsStorage.PlatformDescriptor fromPlatformDescriptor, GtfsStorage.PlatformDescriptor toPlatformDescriptor, int streetTime, int[] skippedEdgesForTransfer) {
        if (skippedEdgesForTransfer.length > 0) {
            this.gtfsStorage.interpolatedTransfers.put((Object)new GtfsStorage.FeedIdWithStopId(fromPlatformDescriptor.feed_id, fromPlatformDescriptor.stop_id), (Object)new GtfsStorage.InterpolatedTransfer(new GtfsStorage.FeedIdWithStopId(toPlatformDescriptor.feed_id, toPlatformDescriptor.stop_id), streetTime, skippedEdgesForTransfer));
        }
    }

    private void insertInterpolatedTransfer(Label label, GtfsStorage.PlatformDescriptor toPlatformDescriptor, HashMap<String, GtfsReader> readers, int[] skippedEdgesForTransfer) {
        GtfsReader toFeedReader = readers.get(toPlatformDescriptor.feed_id);
        ArrayList<Integer> transferEdgeIds = toFeedReader.insertTransferEdges(label.node.ptNode, (int)(label.streetTime / 1000L), toPlatformDescriptor);
        if (skippedEdgesForTransfer.length > 0) {
            assert (this.isValidPath(skippedEdgesForTransfer));
            for (Integer transferEdgeId : transferEdgeIds) {
                this.gtfsStorage.getSkippedEdgesForTransfer().put(transferEdgeId, skippedEdgesForTransfer);
            }
        }
    }

    private int[] getSkippedEdgesForTransfer(Label label) {
        List<Label.Transition> transitions = Label.getTransitions(label.parent, true);
        int[] skippedEdgesForTransfer = transitions.stream().filter(t2 -> t2.edge != null).mapToInt(t2 -> {
            Label.NodeId adjNode = t2.label.node;
            EdgeIteratorState edgeIteratorState = this.getBaseGraph().getEdgeIteratorState(t2.edge.getId(), adjNode.streetNode);
            return edgeIteratorState.getEdgeKey();
        }).toArray();
        return skippedEdgesForTransfer;
    }

    private boolean isValidPath(int[] edgeKeys) {
        List edges = Arrays.stream(edgeKeys).mapToObj(i -> this.getBaseGraph().getEdgeIteratorStateForKey(i)).collect(Collectors.toList());
        for (int i2 = 1; i2 < edges.size(); ++i2) {
            if (((EdgeIteratorState)edges.get(i2)).getBaseNode() == ((EdgeIteratorState)edges.get(i2 - 1)).getAdjNode()) continue;
            return false;
        }
        TripFromLabel tripFromLabel = new TripFromLabel(this.getBaseGraph(), this.getEncodingManager(), this.gtfsStorage, RealtimeFeed.empty(), this.getPathDetailsBuilderFactory(), 6.0);
        tripFromLabel.transferPath(edgeKeys, this.createWeighting(this.getProfile("foot"), new PMap()), 0L);
        return true;
    }

    private String routeIdOrNull(GtfsStorage.PlatformDescriptor platformDescriptor) {
        if (platformDescriptor instanceof GtfsStorage.RouteTypePlatform) {
            return null;
        }
        return ((GtfsStorage.RoutePlatform)platformDescriptor).route_id;
    }

    @Override
    public void close() {
        this.getGtfsStorage().close();
        super.close();
    }

    public GtfsStorage getGtfsStorage() {
        return this.gtfsStorage;
    }

    public PtGraph getPtGraph() {
        return this.ptGraph;
    }
}

