/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.gtfs;

import com.conveyal.gtfs.GTFSFeed;
import com.conveyal.gtfs.model.Entity;
import com.conveyal.gtfs.model.Frequency;
import com.conveyal.gtfs.model.Route;
import com.conveyal.gtfs.model.Service;
import com.conveyal.gtfs.model.Stop;
import com.conveyal.gtfs.model.StopTime;
import com.conveyal.gtfs.model.Transfer;
import com.conveyal.gtfs.model.Trip;
import com.google.common.collect.HashMultimap;
import com.google.transit.realtime.GtfsRealtime;
import com.graphhopper.gtfs.GtfsStorage;
import com.graphhopper.gtfs.PtEdgeAttributes;
import com.graphhopper.gtfs.PtGraph;
import com.graphhopper.gtfs.Transfers;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.storage.index.InMemConstructionIndex;
import com.graphhopper.storage.index.LocationIndex;
import com.graphhopper.storage.index.Snap;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.mapdb.Fun;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GtfsReader {
    private final PtGraph ptGraph;
    private final PtGraphOut out;
    private final InMemConstructionIndex indexBuilder;
    private LocalDate startDate;
    private LocalDate endDate;
    private static final Logger LOGGER = LoggerFactory.getLogger(GtfsReader.class);
    private final LocationIndex streetNetworkIndex;
    private final GtfsStorage gtfsStorage;
    private final Transfers transfers;
    private final String id;
    private GTFSFeed feed;
    private final Map<String, Map<GtfsStorage.PlatformDescriptor, NavigableMap<Integer, Integer>>> departureTimelinesByStop = new HashMap<String, Map<GtfsStorage.PlatformDescriptor, NavigableMap<Integer, Integer>>>();
    private final Map<String, Map<GtfsStorage.PlatformDescriptor, NavigableMap<Integer, Integer>>> arrivalTimelinesByStop = new HashMap<String, Map<GtfsStorage.PlatformDescriptor, NavigableMap<Integer, Integer>>>();

    GtfsReader(String id, PtGraph ptGraph, PtGraphOut out, GtfsStorage gtfsStorage, LocationIndex streetNetworkIndex, Transfers transfers, InMemConstructionIndex indexBuilder) {
        this.id = id;
        this.gtfsStorage = gtfsStorage;
        this.streetNetworkIndex = streetNetworkIndex;
        this.feed = this.gtfsStorage.getGtfsFeeds().get(id);
        this.transfers = transfers;
        this.startDate = this.feed.getStartDate();
        this.endDate = this.feed.getEndDate();
        this.ptGraph = ptGraph;
        this.out = out;
        this.indexBuilder = indexBuilder;
    }

    void connectStopsToStreetNetwork(EdgeFilter filter) {
        for (Stop stop : this.feed.stops.values()) {
            int stopNode;
            if (stop.location_type != 0) continue;
            Snap locationSnap = this.streetNetworkIndex.findClosest(stop.stop_lat, stop.stop_lon, filter);
            if (locationSnap.isValid()) {
                stopNode = this.gtfsStorage.getStreetToPt().getOrDefault(locationSnap.getClosestNode(), -1);
                if (stopNode == -1) {
                    stopNode = this.out.createNode();
                    this.indexBuilder.addToAllTilesOnLine(stopNode, stop.stop_lat, stop.stop_lon, stop.stop_lat, stop.stop_lon);
                    this.gtfsStorage.getPtToStreet().put(stopNode, locationSnap.getClosestNode());
                    this.gtfsStorage.getStreetToPt().put(locationSnap.getClosestNode(), stopNode);
                }
            } else {
                stopNode = this.out.createNode();
                this.indexBuilder.addToAllTilesOnLine(stopNode, stop.stop_lat, stop.stop_lon, stop.stop_lat, stop.stop_lon);
            }
            this.gtfsStorage.getStationNodes().put(new GtfsStorage.FeedIdWithStopId(this.id, stop.stop_id), stopNode);
        }
    }

    void buildPtNetwork() {
        this.createTrips();
        this.wireUpStops();
        this.insertGtfsTransfers();
    }

    private void createTrips() {
        HashMultimap blockTrips = HashMultimap.create();
        for (Trip trip : this.feed.trips.values()) {
            if (trip.block_id != null) {
                blockTrips.put(trip.block_id, trip);
                continue;
            }
            blockTrips.put("non-block-trip" + trip.trip_id, trip);
        }
        blockTrips.asMap().values().forEach(unsortedTrips -> {
            List<TripWithStopTimes> trips = unsortedTrips.stream().map(trip -> {
                Service service = this.feed.services.get(trip.service_id);
                BitSet validOnDay = new BitSet((int)ChronoUnit.DAYS.between(this.startDate, this.endDate));
                LocalDate date = this.startDate;
                while (!date.isAfter(this.endDate)) {
                    if (service.activeOn(date)) {
                        validOnDay.set((int)ChronoUnit.DAYS.between(this.startDate, date));
                    }
                    date = date.plusDays(1L);
                }
                ArrayList<StopTime> stopTimes = new ArrayList<StopTime>();
                this.feed.getInterpolatedStopTimesForTrip(trip.trip_id).forEach(stopTimes::add);
                return new TripWithStopTimes((Trip)trip, (List<StopTime>)stopTimes, validOnDay, Collections.emptySet(), Collections.emptySet());
            }).sorted(Comparator.comparingInt(trip -> trip.stopTimes.iterator().next().departure_time)).collect(Collectors.toList());
            if (trips.stream().map(trip -> this.feed.getFrequencies(trip.trip.trip_id)).distinct().count() != 1L) {
                throw new RuntimeException("Found a block with frequency-based trips. Not supported.");
            }
            ZoneId zoneId = ZoneId.of(this.feed.agency.get((Object)this.feed.routes.get((Object)((TripWithStopTimes)trips.iterator().next()).trip.route_id).agency_id).agency_timezone);
            Collection<Frequency> frequencies = this.feed.getFrequencies(((TripWithStopTimes)trips.iterator().next()).trip.trip_id);
            if (frequencies.isEmpty()) {
                this.addTrips(zoneId, trips, 0, false);
            } else {
                for (Frequency frequency : frequencies) {
                    for (int time = frequency.start_time; time < frequency.end_time; time += frequency.headway_secs) {
                        this.addTrips(zoneId, trips, time, true);
                    }
                }
            }
        });
    }

    private void wireUpStops() {
        this.arrivalTimelinesByStop.forEach((stopId, arrivalTimelines) -> {
            Stop stop = this.feed.stops.get(stopId);
            arrivalTimelines.forEach((platformDescriptor, arrivalTimeline) -> this.wireUpArrivalTimeline(stop, (NavigableMap<Integer, Integer>)arrivalTimeline, this.routeType((GtfsStorage.PlatformDescriptor)platformDescriptor), (GtfsStorage.PlatformDescriptor)platformDescriptor));
        });
        this.departureTimelinesByStop.forEach((stopId, departureTimelines) -> {
            Stop stop = this.feed.stops.get(stopId);
            departureTimelines.forEach((platformDescriptor, departureTimeline) -> this.wireUpDepartureTimeline(stop, (NavigableMap<Integer, Integer>)departureTimeline, this.routeType((GtfsStorage.PlatformDescriptor)platformDescriptor), (GtfsStorage.PlatformDescriptor)platformDescriptor));
        });
    }

    private void insertGtfsTransfers() {
        this.departureTimelinesByStop.forEach((toStopId, departureTimelines) -> departureTimelines.forEach(this::insertInboundTransfers));
    }

    private void insertInboundTransfers(GtfsStorage.PlatformDescriptor toPlatformDescriptor, NavigableMap<Integer, Integer> departureTimeline) {
        LOGGER.debug("Creating transfers to stop {}, platform {}", (Object)toPlatformDescriptor.stop_id, (Object)toPlatformDescriptor);
        List<Transfer> transfersToPlatform = this.transfers.getTransfersToStop(toPlatformDescriptor.stop_id, this.routeIdOrNull(toPlatformDescriptor));
        transfersToPlatform.forEach(transfer -> {
            GtfsStorage.FeedIdWithStopId stopId = new GtfsStorage.FeedIdWithStopId(this.id, transfer.from_stop_id);
            Integer stationNode = this.gtfsStorage.getStationNodes().get(stopId);
            if (stationNode != null) {
                for (PtGraph.PtEdge ptEdge : this.ptGraph.backEdgesAround(stationNode)) {
                    if (ptEdge.getType() != GtfsStorage.EdgeType.EXIT_PT) continue;
                    GtfsStorage.PlatformDescriptor fromPlatformDescriptor = ptEdge.getAttrs().platformDescriptor;
                    if (!fromPlatformDescriptor.stop_id.equals(transfer.from_stop_id) || (transfer.from_route_id != null || !(fromPlatformDescriptor instanceof GtfsStorage.RouteTypePlatform)) && (transfer.from_route_id == null || !GtfsStorage.PlatformDescriptor.route(this.id, transfer.from_stop_id, transfer.from_route_id).equals(fromPlatformDescriptor))) continue;
                    LOGGER.debug("  Creating transfers from stop {}, platform {}", (Object)transfer.from_stop_id, (Object)fromPlatformDescriptor);
                    this.insertTransferEdges(ptEdge.getAdjNode(), transfer.min_transfer_time, departureTimeline, toPlatformDescriptor);
                }
            } else {
                Stop stop = this.gtfsStorage.getGtfsFeeds().get((Object)stopId.feedId).stops.get(stopId.stopId);
                LOGGER.warn("Stop {} has no station node", (Object)stopId);
            }
        });
    }

    public ArrayList<Integer> insertTransferEdges(int arrivalPlatformNode, int minTransferTime, GtfsStorage.PlatformDescriptor departurePlatform) {
        return this.insertTransferEdges(arrivalPlatformNode, minTransferTime, this.departureTimelinesByStop.get(departurePlatform.stop_id).get(departurePlatform), departurePlatform);
    }

    private ArrayList<Integer> insertTransferEdges(int arrivalPlatformNode, int minTransferTime, NavigableMap<Integer, Integer> departureTimeline, GtfsStorage.PlatformDescriptor departurePlatform) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (PtGraph.PtEdge e : this.ptGraph.backEdgesAround(arrivalPlatformNode)) {
            int arrivalTime;
            SortedMap<Integer, Integer> tailSet;
            if (e.getType() != GtfsStorage.EdgeType.LEAVE_TIME_EXPANDED_NETWORK || (tailSet = departureTimeline.tailMap((arrivalTime = e.getTime()) + minTransferTime)).isEmpty()) continue;
            int id = this.out.createEdge(e.getAdjNode(), (Integer)tailSet.get(tailSet.firstKey()), new PtEdgeAttributes(GtfsStorage.EdgeType.TRANSFER, tailSet.firstKey() - arrivalTime, null, this.routeType(departurePlatform), null, 0, -1, null, departurePlatform));
            result.add(id);
        }
        return result;
    }

    void wireUpAdditionalDeparturesAndArrivals(ZoneId zoneId) {
        this.departureTimelinesByStop.forEach((stopId, departureTimelines) -> {
            Stop stop = this.feed.stops.get(stopId);
            departureTimelines.forEach((platformDescriptor, timeline) -> this.wireUpOrPatchDepartureTimeline(zoneId, stop, (NavigableMap<Integer, Integer>)timeline, (GtfsStorage.PlatformDescriptor)platformDescriptor));
        });
        this.arrivalTimelinesByStop.forEach((stopId, arrivalTimelines) -> {
            Stop stop = this.feed.stops.get(stopId);
            arrivalTimelines.forEach((platformDescriptor, timeline) -> this.wireUpOrPatchArrivalTimeline(zoneId, stop, this.routeIdOrNull((GtfsStorage.PlatformDescriptor)platformDescriptor), (NavigableMap<Integer, Integer>)timeline, (GtfsStorage.PlatformDescriptor)platformDescriptor));
        });
    }

    private void addTrips(ZoneId zoneId, List<TripWithStopTimes> trips, int time, boolean frequencyBased) {
        ArrayList<TripWithStopTimeAndArrivalNode> arrivalNodes = new ArrayList<TripWithStopTimeAndArrivalNode>();
        for (TripWithStopTimes trip : trips) {
            this.addTrip(zoneId, time, arrivalNodes, trip, GtfsReader.getTripDescriptor(time, frequencyBased, trip));
        }
    }

    private static GtfsRealtime.TripDescriptor getTripDescriptor(int time, boolean frequencyBased, TripWithStopTimes trip) {
        GtfsRealtime.TripDescriptor.Builder tripDescriptor = GtfsRealtime.TripDescriptor.newBuilder().setTripId(trip.trip.trip_id).setRouteId(trip.trip.route_id);
        if (frequencyBased) {
            tripDescriptor = tripDescriptor.setStartTime(Entity.Writer.convertToGtfsTime(time));
        }
        return tripDescriptor.build();
    }

    void addTrip(ZoneId zoneId, int time, List<TripWithStopTimeAndArrivalNode> arrivalNodes, TripWithStopTimes trip, GtfsRealtime.TripDescriptor tripDescriptor) {
        StopTime prev = null;
        int arrivalNode = -1;
        int arrivalTime = -1;
        int departureNode = -1;
        for (StopTime stopTime : trip.stopTimes) {
            arrivalNode = this.out.createNode();
            arrivalTime = stopTime.arrival_time + time;
            if (prev != null) {
                this.out.createEdge(departureNode, arrivalNode, new PtEdgeAttributes(GtfsStorage.EdgeType.HOP, stopTime.arrival_time - prev.departure_time, null, -1, null, 0, stopTime.stop_sequence, null, null));
            }
            Route route = this.feed.routes.get(trip.trip.route_id);
            GtfsStorage.PlatformDescriptor platform = this.transfers.hasNoRouteSpecificDepartureTransferRules(stopTime.stop_id) ? GtfsStorage.PlatformDescriptor.routeType(this.id, stopTime.stop_id, route.route_type) : GtfsStorage.PlatformDescriptor.route(this.id, stopTime.stop_id, route.route_id);
            Map departureTimelines = this.departureTimelinesByStop.computeIfAbsent(stopTime.stop_id, s2 -> new HashMap());
            NavigableMap departureTimeline = departureTimelines.computeIfAbsent(platform, s2 -> new TreeMap());
            int departureTimelineNode = departureTimeline.computeIfAbsent((stopTime.departure_time + time) % 86400, t2 -> this.out.createNode());
            Map arrivalTimelines = this.arrivalTimelinesByStop.computeIfAbsent(stopTime.stop_id, s2 -> new HashMap());
            NavigableMap arrivalTimeline = arrivalTimelines.computeIfAbsent(platform, s2 -> new TreeMap());
            int arrivalTimelineNode = arrivalTimeline.computeIfAbsent((stopTime.arrival_time + time) % 86400, t2 -> this.out.createNode());
            departureNode = this.out.createNode();
            int dayShift = stopTime.departure_time / 86400;
            GtfsStorage.Validity validOn = new GtfsStorage.Validity(this.getValidOn(trip.validOnDay, dayShift), zoneId, this.startDate);
            this.out.createEdge(departureTimelineNode, departureNode, new PtEdgeAttributes(GtfsStorage.EdgeType.BOARD, 0, validOn, -1, null, 1, stopTime.stop_sequence, tripDescriptor, null));
            this.out.createEdge(arrivalNode, arrivalTimelineNode, new PtEdgeAttributes(GtfsStorage.EdgeType.ALIGHT, 0, validOn, -1, null, 0, stopTime.stop_sequence, tripDescriptor, null));
            this.out.createEdge(arrivalNode, departureNode, new PtEdgeAttributes(GtfsStorage.EdgeType.DWELL, stopTime.departure_time - stopTime.arrival_time, null, -1, null, 0, -1, null, null));
            if (prev == null) {
                this.insertInboundBlockTransfers(arrivalNodes, tripDescriptor, departureNode, stopTime.departure_time + time, stopTime, validOn, zoneId, platform);
            }
            prev = stopTime;
        }
        TripWithStopTimeAndArrivalNode tripWithStopTimeAndArrivalNode = new TripWithStopTimeAndArrivalNode();
        tripWithStopTimeAndArrivalNode.tripWithStopTimes = trip;
        tripWithStopTimeAndArrivalNode.arrivalNode = arrivalNode;
        tripWithStopTimeAndArrivalNode.arrivalTime = arrivalTime;
        arrivalNodes.add(tripWithStopTimeAndArrivalNode);
    }

    private void wireUpDepartureTimeline(Stop stop, NavigableMap<Integer, Integer> departureTimeline, int route_type, GtfsStorage.PlatformDescriptor platformDescriptor) {
        LOGGER.debug("Creating timeline at stop {} for departure platform {}", (Object)stop.stop_id, (Object)platformDescriptor);
        int platformEnterNode = this.out.createNode();
        int streetNode = this.gtfsStorage.getStationNodes().get(new GtfsStorage.FeedIdWithStopId(platformDescriptor.feed_id, platformDescriptor.stop_id));
        this.out.createEdge(streetNode, platformEnterNode, new PtEdgeAttributes(GtfsStorage.EdgeType.ENTER_PT, 0, null, route_type, null, 0, -1, null, platformDescriptor));
        this.wireUpAndConnectTimeline(platformEnterNode, departureTimeline, GtfsStorage.EdgeType.ENTER_TIME_EXPANDED_NETWORK, GtfsStorage.EdgeType.WAIT);
    }

    private void wireUpArrivalTimeline(Stop stop, NavigableMap<Integer, Integer> arrivalTimeline, int route_type, GtfsStorage.PlatformDescriptor platformDescriptor) {
        LOGGER.debug("Creating timeline at stop {} for arrival platform {}", (Object)stop.stop_id, (Object)platformDescriptor);
        int platformExitNode = this.out.createNode();
        int streetNode = this.gtfsStorage.getStationNodes().get(new GtfsStorage.FeedIdWithStopId(platformDescriptor.feed_id, platformDescriptor.stop_id));
        this.out.createEdge(platformExitNode, streetNode, new PtEdgeAttributes(GtfsStorage.EdgeType.EXIT_PT, 0, null, route_type, null, 0, -1, null, platformDescriptor));
        this.wireUpAndConnectTimeline(platformExitNode, arrivalTimeline, GtfsStorage.EdgeType.LEAVE_TIME_EXPANDED_NETWORK, GtfsStorage.EdgeType.WAIT_ARRIVAL);
    }

    private void wireUpOrPatchDepartureTimeline(ZoneId zoneId, Stop stop, NavigableMap<Integer, Integer> timeline, GtfsStorage.PlatformDescriptor route) {
        int platformEnterNode = this.findPlatformEnter(route);
        if (platformEnterNode != -1) {
            this.patchDepartureTimeline(zoneId, timeline, platformEnterNode);
        } else {
            this.wireUpDepartureTimeline(stop, timeline, 0, route);
        }
    }

    private void wireUpOrPatchArrivalTimeline(ZoneId zoneId, Stop stop, String routeId, NavigableMap<Integer, Integer> timeline, GtfsStorage.PlatformDescriptor route) {
        int platformExitNode = this.findPlatformExit(route);
        if (platformExitNode != -1) {
            this.patchArrivalTimeline(zoneId, timeline, platformExitNode);
        } else {
            this.wireUpArrivalTimeline(stop, timeline, 0, route);
        }
        Optional<Transfer> withinStationTransfer = this.transfers.getTransfersFromStop(stop.stop_id, routeId).stream().filter(t2 -> t2.from_stop_id.equals(stop.stop_id)).findAny();
        if (!withinStationTransfer.isPresent()) {
            this.insertOutboundTransfers(stop.stop_id, null, 0, timeline);
        }
        this.transfers.getTransfersFromStop(stop.stop_id, routeId).forEach(transfer -> this.insertOutboundTransfers(transfer.from_stop_id, transfer.from_route_id, transfer.min_transfer_time, timeline));
    }

    private void patchDepartureTimeline(ZoneId zoneId, NavigableMap<Integer, Integer> timeline, int platformNode) {
        NavigableMap<Integer, Integer> staticDepartureTimelineForRoute = this.findDepartureTimelineForPlatform(platformNode);
        timeline.forEach((time, node) -> {
            SortedMap tailMap;
            SortedMap headMap = staticDepartureTimelineForRoute.headMap((Integer)time);
            if (!headMap.isEmpty()) {
                this.out.createEdge((Integer)headMap.get(headMap.lastKey()), (int)node, new PtEdgeAttributes(GtfsStorage.EdgeType.WAIT, time - headMap.lastKey(), null, -1, null, 0, -1, null, null));
            }
            if (!(tailMap = staticDepartureTimelineForRoute.tailMap((Integer)time)).isEmpty()) {
                this.out.createEdge((int)node, (Integer)tailMap.get(tailMap.firstKey()), new PtEdgeAttributes(GtfsStorage.EdgeType.WAIT, tailMap.firstKey() - time, null, -1, null, 0, -1, null, null));
            }
            this.out.createEdge(platformNode, (int)node, new PtEdgeAttributes(GtfsStorage.EdgeType.ENTER_TIME_EXPANDED_NETWORK, (int)time, null, -1, new GtfsStorage.FeedIdWithTimezone(this.id, zoneId), 0, -1, null, null));
        });
    }

    private void patchArrivalTimeline(ZoneId zoneId, NavigableMap<Integer, Integer> timeline, int platformExitNode) {
        timeline.forEach((time, node) -> this.out.createEdge((int)node, platformExitNode, new PtEdgeAttributes(GtfsStorage.EdgeType.LEAVE_TIME_EXPANDED_NETWORK, (int)time, null, -1, new GtfsStorage.FeedIdWithTimezone(this.id, zoneId), 0, -1, null, null)));
    }

    private NavigableMap<Integer, Integer> findDepartureTimelineForPlatform(int platformEnterNode) {
        TreeMap<Integer, Integer> result = new TreeMap<Integer, Integer>();
        if (platformEnterNode == -1) {
            return result;
        }
        for (PtGraph.PtEdge edge : this.ptGraph.edgesAround(platformEnterNode)) {
            if (edge.getType() != GtfsStorage.EdgeType.ENTER_TIME_EXPANDED_NETWORK) continue;
            result.put(edge.getTime(), edge.getAdjNode());
        }
        return result;
    }

    private int findPlatformEnter(GtfsStorage.PlatformDescriptor platformDescriptor) {
        Integer stopNode = this.gtfsStorage.getStationNodes().get(new GtfsStorage.FeedIdWithStopId(platformDescriptor.feed_id, platformDescriptor.stop_id));
        if (stopNode == null) {
            return -1;
        }
        for (PtGraph.PtEdge ptEdge : this.ptGraph.edgesAround(stopNode)) {
            if (ptEdge.getType() != GtfsStorage.EdgeType.ENTER_PT || !platformDescriptor.equals(ptEdge.getAttrs().platformDescriptor)) continue;
            return ptEdge.getAdjNode();
        }
        return -1;
    }

    private int findPlatformExit(GtfsStorage.PlatformDescriptor platformDescriptor) {
        Integer stopNode = this.gtfsStorage.getStationNodes().get(new GtfsStorage.FeedIdWithStopId(platformDescriptor.feed_id, platformDescriptor.stop_id));
        if (stopNode == null) {
            return -1;
        }
        for (PtGraph.PtEdge ptEdge : this.ptGraph.backEdgesAround(stopNode)) {
            if (ptEdge.getType() != GtfsStorage.EdgeType.EXIT_PT || !platformDescriptor.equals(ptEdge.getAttrs().platformDescriptor)) continue;
            return ptEdge.getAdjNode();
        }
        return -1;
    }

    int addDelayedBoardEdge(ZoneId zoneId, GtfsRealtime.TripDescriptor tripDescriptor, int stopSequence, int departureTime, int departureNode, BitSet validOnDay) {
        Trip trip = this.feed.trips.get(tripDescriptor.getTripId());
        StopTime stopTime = this.feed.stop_times.get(new Fun.Tuple2<String, Integer>(tripDescriptor.getTripId(), stopSequence));
        Map departureTimelineNodesByRoute = this.departureTimelinesByStop.computeIfAbsent(stopTime.stop_id, s2 -> new HashMap());
        NavigableMap departureTimelineNodes = departureTimelineNodesByRoute.computeIfAbsent(GtfsStorage.PlatformDescriptor.route(this.id, stopTime.stop_id, trip.route_id), s2 -> new TreeMap());
        int departureTimelineNode = departureTimelineNodes.computeIfAbsent(departureTime % 86400, t2 -> this.out.createNode());
        int dayShift = departureTime / 86400;
        GtfsStorage.Validity validOn = new GtfsStorage.Validity(this.getValidOn(validOnDay, dayShift), zoneId, this.startDate);
        return this.out.createEdge(departureTimelineNode, departureNode, new PtEdgeAttributes(GtfsStorage.EdgeType.BOARD, 0, validOn, -1, null, 1, stopSequence, tripDescriptor, null));
    }

    private void wireUpAndConnectTimeline(int platformNode, NavigableMap<Integer, Integer> timeNodes, GtfsStorage.EdgeType timeExpandedNetworkEdgeType, GtfsStorage.EdgeType waitEdgeType) {
        ZoneId zoneId = ZoneId.of(this.feed.agency.values().iterator().next().agency_timezone);
        int time = 0;
        int prev = -1;
        for (Map.Entry e : timeNodes.descendingMap().entrySet()) {
            if (timeExpandedNetworkEdgeType == GtfsStorage.EdgeType.LEAVE_TIME_EXPANDED_NETWORK) {
                this.out.createEdge((Integer)e.getValue(), platformNode, new PtEdgeAttributes(timeExpandedNetworkEdgeType, (Integer)e.getKey(), null, -1, new GtfsStorage.FeedIdWithTimezone(this.id, zoneId), 0, -1, null, null));
            } else if (timeExpandedNetworkEdgeType == GtfsStorage.EdgeType.ENTER_TIME_EXPANDED_NETWORK) {
                this.out.createEdge(platformNode, (Integer)e.getValue(), new PtEdgeAttributes(timeExpandedNetworkEdgeType, (Integer)e.getKey(), null, -1, new GtfsStorage.FeedIdWithTimezone(this.id, zoneId), 0, -1, null, null));
            } else {
                throw new RuntimeException();
            }
            if (prev != -1) {
                this.out.createEdge((Integer)e.getValue(), prev, new PtEdgeAttributes(waitEdgeType, time - (Integer)e.getKey(), null, -1, null, 0, -1, null, null));
            }
            time = (Integer)e.getKey();
            prev = (Integer)e.getValue();
        }
        if (!timeNodes.isEmpty()) {
            int rolloverTime = 86400 - (Integer)timeNodes.lastKey() + (Integer)timeNodes.firstKey();
            this.out.createEdge((Integer)timeNodes.get(timeNodes.lastKey()), (Integer)timeNodes.get(timeNodes.firstKey()), new PtEdgeAttributes(GtfsStorage.EdgeType.OVERNIGHT, rolloverTime, null, -1, null, 0, -1, null, null));
        }
    }

    private void insertInboundBlockTransfers(List<TripWithStopTimeAndArrivalNode> arrivalNodes, GtfsRealtime.TripDescriptor tripDescriptor, int departureNode, int departureTime, StopTime stopTime, GtfsStorage.Validity validOn, ZoneId zoneId, GtfsStorage.PlatformDescriptor platform) {
        BitSet accumulatorValidity = new BitSet(validOn.validity.size());
        accumulatorValidity.or(validOn.validity);
        ListIterator<TripWithStopTimeAndArrivalNode> li = arrivalNodes.listIterator(arrivalNodes.size());
        while (li.hasPrevious() && accumulatorValidity.cardinality() > 0) {
            TripWithStopTimeAndArrivalNode lastTrip = li.previous();
            int dwellTime = departureTime - lastTrip.arrivalTime;
            if (dwellTime < 0 || !accumulatorValidity.intersects(lastTrip.tripWithStopTimes.validOnDay)) continue;
            BitSet blockTransferValidity = new BitSet(validOn.validity.size());
            blockTransferValidity.or(validOn.validity);
            blockTransferValidity.and(accumulatorValidity);
            GtfsStorage.Validity blockTransferValidOn = new GtfsStorage.Validity(blockTransferValidity, zoneId, this.startDate);
            int node = this.out.createNode();
            this.out.createEdge(lastTrip.arrivalNode, node, new PtEdgeAttributes(GtfsStorage.EdgeType.TRANSFER, dwellTime, null, -1, null, 0, -1, null, platform));
            this.out.createEdge(node, departureNode, new PtEdgeAttributes(GtfsStorage.EdgeType.BOARD, 0, blockTransferValidOn, -1, null, 0, stopTime.stop_sequence, tripDescriptor, null));
            accumulatorValidity.andNot(lastTrip.tripWithStopTimes.validOnDay);
        }
    }

    private void insertOutboundTransfers(String toStopId, String toRouteId, int minimumTransferTime, NavigableMap<Integer, Integer> fromStopTimelineNodes) {
        int stationNode = this.gtfsStorage.getStationNodes().get(new GtfsStorage.FeedIdWithStopId(this.id, toStopId));
        for (PtGraph.PtEdge ptEdge : this.ptGraph.edgesAround(stationNode)) {
            GtfsStorage.PlatformDescriptor toPlatform = ptEdge.getAttrs().platformDescriptor;
            if (toRouteId != null && !(toPlatform instanceof GtfsStorage.RouteTypePlatform) && !GtfsStorage.PlatformDescriptor.route(this.id, toStopId, toRouteId).equals(toPlatform)) continue;
            fromStopTimelineNodes.forEach((time, e) -> {
                for (PtGraph.PtEdge j : this.ptGraph.edgesAround(ptEdge.getAdjNode())) {
                    int departureTime;
                    if (j.getType() != GtfsStorage.EdgeType.ENTER_TIME_EXPANDED_NETWORK || (departureTime = j.getTime()) < time + minimumTransferTime) continue;
                    this.out.createEdge((int)e, j.getAdjNode(), new PtEdgeAttributes(GtfsStorage.EdgeType.TRANSFER, departureTime - time, null, -1, null, 0, -1, null, toPlatform));
                    break;
                }
            });
        }
    }

    private BitSet getValidOn(BitSet validOnDay, int dayShift) {
        if (dayShift == 0) {
            return validOnDay;
        }
        BitSet bitSet = new BitSet(validOnDay.length() + 1);
        for (int i = 0; i < validOnDay.length(); ++i) {
            if (!validOnDay.get(i)) continue;
            bitSet.set(i + 1);
        }
        return bitSet;
    }

    private int routeType(GtfsStorage.PlatformDescriptor platformDescriptor) {
        if (platformDescriptor instanceof GtfsStorage.RouteTypePlatform) {
            return ((GtfsStorage.RouteTypePlatform)platformDescriptor).route_type;
        }
        return this.feed.routes.get((Object)((GtfsStorage.RoutePlatform)platformDescriptor).route_id).route_type;
    }

    private String routeIdOrNull(GtfsStorage.PlatformDescriptor platformDescriptor) {
        if (platformDescriptor instanceof GtfsStorage.RouteTypePlatform) {
            return null;
        }
        return ((GtfsStorage.RoutePlatform)platformDescriptor).route_id;
    }

    static interface PtGraphOut {
        public int createEdge(int var1, int var2, PtEdgeAttributes var3);

        public int createNode();
    }

    static class TripWithStopTimes {
        Trip trip;
        List<StopTime> stopTimes;
        BitSet validOnDay;
        Set<Integer> cancelledArrivals;
        Set<Integer> cancelledDeparture;

        TripWithStopTimes(Trip trip, List<StopTime> stopTimes, BitSet validOnDay, Set<Integer> cancelledArrivals, Set<Integer> cancelledDepartures) {
            this.trip = trip;
            this.stopTimes = stopTimes;
            this.validOnDay = validOnDay;
            this.cancelledArrivals = cancelledArrivals;
            this.cancelledDeparture = cancelledDepartures;
        }
    }

    private static class TripWithStopTimeAndArrivalNode {
        TripWithStopTimes tripWithStopTimes;
        int arrivalNode;
        int arrivalTime;

        private TripWithStopTimeAndArrivalNode() {
        }
    }
}

