/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.gtfs;

import com.carrotsearch.hppc.IntIntHashMap;
import com.carrotsearch.hppc.IntObjectHashMap;
import com.carrotsearch.hppc.cursors.IntIntCursor;
import com.carrotsearch.hppc.cursors.IntObjectCursor;
import com.conveyal.gtfs.GTFSFeed;
import com.conveyal.gtfs.model.Fare;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SequenceWriter;
import com.google.common.collect.HashMultimap;
import com.graphhopper.gtfs.PtGraph;
import com.graphhopper.gtfs.Trips;
import com.graphhopper.storage.Directory;
import com.graphhopper.storage.index.LineIntIndex;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import org.mapdb.DB;
import org.mapdb.DBMaker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GtfsStorage {
    private static final Logger LOGGER = LoggerFactory.getLogger(GtfsStorage.class);
    static ObjectMapper ionMapper = new ObjectMapper();
    private LineIntIndex stopIndex;
    private PtGraph ptGraph;
    public Trips tripTransfers;
    private boolean isClosed = false;
    private Directory dir;
    private Set<String> gtfsFeedIds;
    private Map<String, GTFSFeed> gtfsFeeds = new HashMap<String, GTFSFeed>();
    private Map<String, Map<String, Fare>> faresByFeed;
    private Map<FeedIdWithStopId, Integer> stationNodes;
    private IntObjectHashMap<int[]> skippedEdgesForTransfer;
    private IntIntHashMap ptToStreet;
    private IntIntHashMap streetToPt;
    public DB data;
    public HashMultimap<FeedIdWithStopId, InterpolatedTransfer> interpolatedTransfers = HashMultimap.create();

    public void setStopIndex(LineIntIndex stopIndex) {
        this.stopIndex = stopIndex;
    }

    public LineIntIndex getStopIndex() {
        return this.stopIndex;
    }

    public PtGraph getPtGraph() {
        return this.ptGraph;
    }

    public void setPtGraph(PtGraph ptGraph) {
        this.ptGraph = ptGraph;
    }

    public IntObjectHashMap<int[]> getSkippedEdgesForTransfer() {
        return this.skippedEdgesForTransfer;
    }

    public GtfsStorage(Directory dir) {
        this.dir = dir;
    }

    boolean loadExisting() {
        File file = new File(this.dir.getLocation() + "/transit_schedule");
        if (!file.exists()) {
            return false;
        }
        this.data = ((DBMaker)((DBMaker)((DBMaker)DBMaker.newFileDB(file).transactionDisable()).mmapFileEnable()).readOnly()).make();
        this.init();
        for (int i = 0; i < this.gtfsFeedIds.size(); ++i) {
            String gtfsFeedId = "gtfs_" + i;
            File dbFile = new File(this.dir.getLocation() + "/" + gtfsFeedId);
            if (!dbFile.exists()) {
                throw new RuntimeException(String.format("The mapping of the gtfsFeeds in the transit_schedule DB does not reflect the files in %s. dbFile %s is missing.", this.dir.getLocation(), dbFile.getName()));
            }
            GTFSFeed feed = new GTFSFeed(dbFile);
            this.gtfsFeeds.put(gtfsFeedId, feed);
        }
        this.ptToStreet = this.deserializeIntoIntIntHashMap("pt_to_street");
        this.streetToPt = this.deserializeIntoIntIntHashMap("street_to_pt");
        this.skippedEdgesForTransfer = this.deserializeIntoIntObjectHashMap("skipped_edges_for_transfer");
        try (InputStream is = Files.newInputStream(Paths.get(this.dir.getLocation() + "interpolated_transfers", new String[0]), new OpenOption[0]);){
            MappingIterator objectMappingIterator = ionMapper.reader(JsonNode.class).readValues(is);
            objectMappingIterator.forEachRemaining(e -> {
                try {
                    FeedIdWithStopId key = ionMapper.treeToValue((TreeNode)e.get(0), FeedIdWithStopId.class);
                    for (JsonNode jsonNode : e.get(1)) {
                        InterpolatedTransfer interpolatedTransfer = ionMapper.treeToValue((TreeNode)jsonNode, InterpolatedTransfer.class);
                        this.interpolatedTransfers.put((Object)key, (Object)interpolatedTransfer);
                    }
                }
                catch (JsonProcessingException ex) {
                    throw new RuntimeException(ex);
                }
            });
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
        this.postInit();
        return true;
    }

    private IntIntHashMap deserializeIntoIntIntHashMap(String filename) {
        IntIntHashMap intIntHashMap;
        FileInputStream in = new FileInputStream(this.dir.getLocation() + filename);
        try {
            ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(in));
            int size = ois.readInt();
            IntIntHashMap result = new IntIntHashMap();
            for (int i = 0; i < size; ++i) {
                result.put(ois.readInt(), ois.readInt());
            }
            intIntHashMap = result;
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        in.close();
        return intIntHashMap;
    }

    public IntObjectHashMap<int[]> deserializeIntoIntObjectHashMap(String filename) {
        IntObjectHashMap<int[]> intObjectHashMap;
        FileInputStream in = new FileInputStream(this.dir.getLocation() + filename);
        try {
            ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(in));
            int size = ois.readInt();
            IntObjectHashMap<int[]> result = new IntObjectHashMap<int[]>(size);
            for (int i = 0; i < size; ++i) {
                int key = ois.readInt();
                int n = ois.readInt();
                int[] ints = new int[n];
                for (int j = 0; j < n; ++j) {
                    ints[j] = ois.readInt();
                }
                result.put(key, ints);
            }
            intObjectHashMap = result;
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        in.close();
        return intObjectHashMap;
    }

    void create() {
        this.dir.create();
        File file = new File(this.dir.getLocation() + "/transit_schedule");
        try {
            Files.deleteIfExists(file.toPath());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.data = ((DBMaker)((DBMaker)((DBMaker)DBMaker.newFileDB(file).transactionDisable()).mmapFileEnable()).asyncWriteEnable()).make();
        this.init();
    }

    private void init() {
        this.gtfsFeedIds = this.data.getHashSet("gtfsFeeds");
        this.stationNodes = this.data.getHashMap("stationNodes");
        this.ptToStreet = new IntIntHashMap();
        this.streetToPt = new IntIntHashMap();
        this.skippedEdgesForTransfer = new IntObjectHashMap();
    }

    void loadGtfsFromZipFileOrDirectory(String id, File zipFileOrDirectory) {
        File dbFile = new File(this.dir.getLocation() + "/" + id);
        try {
            Files.deleteIfExists(dbFile.toPath());
            GTFSFeed feed = new GTFSFeed(dbFile);
            feed.loadFromFileAndLogErrors(zipFileOrDirectory);
            this.gtfsFeeds.put(id, feed);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.gtfsFeedIds.add(id);
    }

    public void postInit() {
        LocalDate latestStartDate = LocalDate.ofEpochDay(this.gtfsFeeds.values().stream().mapToLong(f -> f.getStartDate().toEpochDay()).max().getAsLong());
        LocalDate earliestEndDate = LocalDate.ofEpochDay(this.gtfsFeeds.values().stream().mapToLong(f -> f.getEndDate().toEpochDay()).min().getAsLong());
        LOGGER.info("Calendar range covered by all feeds: {} till {}", (Object)latestStartDate, (Object)earliestEndDate);
        this.faresByFeed = new HashMap<String, Map<String, Fare>>();
        this.gtfsFeeds.forEach((feed_id, feed) -> this.faresByFeed.put((String)feed_id, feed.fares));
        this.tripTransfers = new Trips(this);
    }

    public void close() {
        if (!this.isClosed) {
            this.isClosed = true;
            this.data.close();
            for (GTFSFeed feed : this.gtfsFeeds.values()) {
                feed.close();
            }
        }
    }

    public Map<String, Map<String, Fare>> getFares() {
        return this.faresByFeed;
    }

    public IntIntHashMap getPtToStreet() {
        return this.ptToStreet;
    }

    public IntIntHashMap getStreetToPt() {
        return this.streetToPt;
    }

    public Map<String, GTFSFeed> getGtfsFeeds() {
        return Collections.unmodifiableMap(this.gtfsFeeds);
    }

    public Map<FeedIdWithStopId, Integer> getStationNodes() {
        return this.stationNodes;
    }

    public void flush() {
        this.serialize("pt_to_street", this.ptToStreet);
        this.serialize("street_to_pt", this.streetToPt);
        this.serialize("skipped_edges_for_transfer", this.skippedEdgesForTransfer);
        try (OutputStream os = Files.newOutputStream(Paths.get(this.dir.getLocation() + "interpolated_transfers", new String[0]), new OpenOption[0]);){
            SequenceWriter sequenceWriter = ionMapper.writer().writeValuesAsArray(os);
            for (Map.Entry e : this.interpolatedTransfers.asMap().entrySet()) {
                sequenceWriter.write(ionMapper.createArrayNode().addPOJO(e.getKey()).addPOJO(e.getValue()));
            }
            sequenceWriter.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void serializeTripTransfersMap(String filename, Map<Trips.TripAtStopTime, Collection<Trips.TripAtStopTime>> data) {
        try (ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(Files.newOutputStream(Paths.get(this.dir.getLocation() + filename, new String[0]), new OpenOption[0])));){
            oos.writeInt(data.size());
            for (Map.Entry<Trips.TripAtStopTime, Collection<Trips.TripAtStopTime>> entry : data.entrySet()) {
                oos.writeInt(entry.getKey().tripIdx);
                oos.writeInt(entry.getKey().stop_sequence);
                oos.writeInt(entry.getValue().size());
                for (Trips.TripAtStopTime tripAtStopTime : entry.getValue()) {
                    oos.writeInt(tripAtStopTime.tripIdx);
                    oos.writeInt(tripAtStopTime.stop_sequence);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Map<Trips.TripAtStopTime, Collection<Trips.TripAtStopTime>> deserializeTripTransfersMap(String filename) {
        TreeMap<Trips.TripAtStopTime, Collection<Trips.TripAtStopTime>> treeMap;
        FileInputStream in = new FileInputStream(this.dir.getLocation() + filename);
        try {
            ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(in));
            int size = ois.readInt();
            TreeMap<Trips.TripAtStopTime, Collection<Trips.TripAtStopTime>> result = new TreeMap<Trips.TripAtStopTime, Collection<Trips.TripAtStopTime>>();
            for (int i = 0; i < size; ++i) {
                Trips.TripAtStopTime origin = new Trips.TripAtStopTime(ois.readInt(), ois.readInt());
                int nDestinations = ois.readInt();
                ArrayList<Trips.TripAtStopTime> destinations = new ArrayList<Trips.TripAtStopTime>(nDestinations);
                for (int j = 0; j < nDestinations; ++j) {
                    int tripIdxTo = ois.readInt();
                    int stop_sequenceTo = ois.readInt();
                    destinations.add(new Trips.TripAtStopTime(tripIdxTo, stop_sequenceTo));
                }
                result.put(origin, destinations);
            }
            treeMap = result;
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        in.close();
        return treeMap;
    }

    public void serialize(String filename, IntObjectHashMap<int[]> data) {
        try (ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(Files.newOutputStream(Paths.get(this.dir.getLocation() + filename, new String[0]), new OpenOption[0])));){
            oos.writeInt(data.size());
            for (IntObjectCursor<int[]> intObjectCursor : data) {
                oos.writeInt(intObjectCursor.key);
                oos.writeInt(((int[])intObjectCursor.value).length);
                for (int v : (int[])intObjectCursor.value) {
                    oos.writeInt(v);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void serialize(String filename, IntIntHashMap data) {
        try (ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(Files.newOutputStream(Paths.get(this.dir.getLocation() + filename, new String[0]), new OpenOption[0])));){
            oos.writeInt(data.size());
            for (IntIntCursor e : data) {
                oos.writeInt(e.key);
                oos.writeInt(e.value);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static class FeedIdWithStopId
    implements Serializable {
        @JsonProperty(value="feed_id")
        public final String feedId;
        @JsonProperty(value="stop_id")
        public final String stopId;

        public FeedIdWithStopId(@JsonProperty(value="feed_id") String feedId, @JsonProperty(value="stop_id") String stopId) {
            this.feedId = feedId;
            this.stopId = stopId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FeedIdWithStopId that = (FeedIdWithStopId)o;
            return this.feedId.equals(that.feedId) && this.stopId.equals(that.stopId);
        }

        public int hashCode() {
            return Objects.hash(this.feedId, this.stopId);
        }

        public String toString() {
            return "FeedIdWithStopId{feedId='" + this.feedId + "', stopId='" + this.stopId + "'}";
        }
    }

    public static class InterpolatedTransfer {
        @JsonProperty(value="to_stop")
        public final FeedIdWithStopId toPlatformDescriptor;
        @JsonProperty(value="street_time")
        public final int streetTime;
        @JsonProperty(value="skipped_edges")
        public final int[] skippedEdgesForTransfer;

        public InterpolatedTransfer(@JsonProperty(value="to_stop") FeedIdWithStopId toPlatformDescriptor, @JsonProperty(value="street_time") int streetTime, @JsonProperty(value="skipped_edges") int[] skippedEdgesForTransfer) {
            this.toPlatformDescriptor = toPlatformDescriptor;
            this.streetTime = streetTime;
            this.skippedEdgesForTransfer = skippedEdgesForTransfer;
        }
    }

    public static class RouteTypePlatform
    extends PlatformDescriptor {
        int route_type;

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            RouteTypePlatform that = (RouteTypePlatform)o;
            return this.route_type == that.route_type;
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.route_type);
        }

        public String toString() {
            return "RouteTypePlatform{feed_id='" + this.feed_id + "', stop_id='" + this.stop_id + "', route_type=" + this.route_type + "}";
        }
    }

    public static class RoutePlatform
    extends PlatformDescriptor {
        String route_id;

        public String toString() {
            return "RoutePlatform{feed_id='" + this.feed_id + "', stop_id='" + this.stop_id + "', route_id='" + this.route_id + "'}";
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            RoutePlatform that = (RoutePlatform)o;
            return this.route_id.equals(that.route_id);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.route_id);
        }
    }

    public static abstract class PlatformDescriptor
    implements Serializable {
        public String feed_id;
        public String stop_id;

        public static PlatformDescriptor route(String feed_id, String stop_id, String route_id) {
            RoutePlatform routePlatform = new RoutePlatform();
            routePlatform.feed_id = feed_id;
            routePlatform.stop_id = stop_id;
            routePlatform.route_id = route_id;
            return routePlatform;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PlatformDescriptor that = (PlatformDescriptor)o;
            return Objects.equals(this.feed_id, that.feed_id) && Objects.equals(this.stop_id, that.stop_id);
        }

        public int hashCode() {
            return Objects.hash(this.feed_id, this.stop_id);
        }

        public static RouteTypePlatform routeType(String feed_id, String stop_id, int route_type) {
            RouteTypePlatform routeTypePlatform = new RouteTypePlatform();
            routeTypePlatform.feed_id = feed_id;
            routeTypePlatform.stop_id = stop_id;
            routeTypePlatform.route_type = route_type;
            return routeTypePlatform;
        }
    }

    public static enum EdgeType {
        HIGHWAY,
        ENTER_TIME_EXPANDED_NETWORK,
        LEAVE_TIME_EXPANDED_NETWORK,
        ENTER_PT,
        EXIT_PT,
        HOP,
        DWELL,
        BOARD,
        ALIGHT,
        OVERNIGHT,
        TRANSFER,
        WAIT,
        WAIT_ARRIVAL;

    }

    public static class FeedIdWithTimezone
    implements Serializable {
        public final String feedId;
        final ZoneId zoneId;

        FeedIdWithTimezone(String feedId, ZoneId zoneId) {
            this.feedId = feedId;
            this.zoneId = zoneId;
        }

        public boolean equals(Object other) {
            if (!(other instanceof FeedIdWithTimezone)) {
                return false;
            }
            FeedIdWithTimezone v = (FeedIdWithTimezone)other;
            return this.feedId.equals(v.feedId) && this.zoneId.equals(v.zoneId);
        }

        public int hashCode() {
            return Objects.hash(this.feedId, this.zoneId);
        }
    }

    public static class Validity
    implements Serializable {
        final BitSet validity;
        final ZoneId zoneId;
        final LocalDate start;

        public Validity(BitSet validity, ZoneId zoneId, LocalDate start) {
            this.validity = validity;
            this.zoneId = zoneId;
            this.start = start;
        }

        public boolean equals(Object other) {
            if (!(other instanceof Validity)) {
                return false;
            }
            Validity v = (Validity)other;
            return this.validity.equals(v.validity) && this.zoneId.equals(v.zoneId) && this.start.equals(v.start);
        }

        public int hashCode() {
            return Objects.hash(this.validity, this.zoneId, this.start);
        }
    }
}

