/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.gtfs;

import com.conveyal.gtfs.GTFSFeed;
import com.google.transit.realtime.GtfsRealtime;
import com.graphhopper.GHResponse;
import com.graphhopper.GraphHopperConfig;
import com.graphhopper.ResponsePath;
import com.graphhopper.config.Profile;
import com.graphhopper.gtfs.GHLocation;
import com.graphhopper.gtfs.GraphExplorer;
import com.graphhopper.gtfs.GtfsStorage;
import com.graphhopper.gtfs.Label;
import com.graphhopper.gtfs.MultiCriteriaLabelSetting;
import com.graphhopper.gtfs.PtGraph;
import com.graphhopper.gtfs.PtLocationSnapper;
import com.graphhopper.gtfs.PtRouter;
import com.graphhopper.gtfs.RealtimeFeed;
import com.graphhopper.gtfs.Request;
import com.graphhopper.gtfs.Transfers;
import com.graphhopper.gtfs.TripFromLabel;
import com.graphhopper.routing.DefaultWeightingFactory;
import com.graphhopper.routing.WeightingFactory;
import com.graphhopper.routing.ev.Subnetwork;
import com.graphhopper.routing.querygraph.QueryGraph;
import com.graphhopper.routing.util.DefaultSnapFilter;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.storage.index.LocationIndex;
import com.graphhopper.util.PMap;
import com.graphhopper.util.PointList;
import com.graphhopper.util.StopWatch;
import com.graphhopper.util.Translation;
import com.graphhopper.util.TranslationMap;
import com.graphhopper.util.details.PathDetailsBuilderFactory;
import com.graphhopper.util.exceptions.ConnectionNotFoundException;
import com.graphhopper.util.exceptions.MaximumNodesExceededException;
import jakarta.inject.Inject;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public final class PtRouterFreeWalkImpl
implements PtRouter {
    private final GraphHopperConfig config;
    private final TranslationMap translationMap;
    private final Weighting accessEgressWeighting;
    private final BaseGraph baseGraph;
    private final EncodingManager encodingManager;
    private final LocationIndex locationIndex;
    private final GtfsStorage gtfsStorage;
    private final RealtimeFeed realtimeFeed;
    private final PathDetailsBuilderFactory pathDetailsBuilderFactory;
    private final WeightingFactory weightingFactory;
    private final PtGraph ptGraph;

    @Inject
    public PtRouterFreeWalkImpl(GraphHopperConfig config, TranslationMap translationMap, BaseGraph baseGraph, EncodingManager encodingManager, LocationIndex locationIndex, GtfsStorage gtfsStorage, RealtimeFeed realtimeFeed, PathDetailsBuilderFactory pathDetailsBuilderFactory) {
        this.config = config;
        this.weightingFactory = new DefaultWeightingFactory(baseGraph.getBaseGraph(), encodingManager);
        Profile accessEgressProfile = config.getProfiles().stream().filter(p -> p.getName().equals("foot")).findFirst().get();
        this.accessEgressWeighting = this.weightingFactory.createWeighting(accessEgressProfile, new PMap(), false);
        this.translationMap = translationMap;
        this.baseGraph = baseGraph;
        this.encodingManager = encodingManager;
        this.locationIndex = locationIndex;
        this.gtfsStorage = gtfsStorage;
        this.realtimeFeed = realtimeFeed;
        this.pathDetailsBuilderFactory = pathDetailsBuilderFactory;
        this.ptGraph = gtfsStorage.getPtGraph();
    }

    @Override
    public GHResponse route(Request request) {
        return new RequestHandler(request).route();
    }

    private class RequestHandler {
        private final int maxVisitedNodesForRequest;
        private final int limitSolutions;
        private final long maxProfileDuration;
        private final Instant initialTime;
        private final boolean profileQuery;
        private final boolean arriveBy;
        private final boolean ignoreTransfers;
        private final double betaTransfers;
        private final double betaStreetTime;
        private final double walkSpeedKmH;
        private final int blockedRouteTypes;
        private final Map<Integer, Long> boardingPenaltiesByRouteType;
        private final GHLocation enter;
        private final GHLocation exit;
        private final Translation translation;
        private final List<String> requestedPathDetails;
        private final GHResponse response = new GHResponse();
        private final long limitTripTime;
        private final long limitStreetTime;
        private QueryGraph queryGraph;
        private int visitedNodes;
        private MultiCriteriaLabelSetting router;
        private final Profile accessProfile;
        private final EdgeFilter accessSnapFilter;
        private final Weighting accessWeighting;
        private final Profile transferProfile;
        private final Weighting transferWeighting;
        private final Profile egressProfile;
        private final EdgeFilter egressSnapFilter;
        private final Weighting egressWeighting;

        RequestHandler(Request request) {
            this.maxVisitedNodesForRequest = request.getMaxVisitedNodes();
            this.profileQuery = request.isProfileQuery();
            this.ignoreTransfers = Optional.ofNullable(request.getIgnoreTransfers()).orElse(request.isProfileQuery());
            this.betaTransfers = request.getBetaTransfers();
            this.betaStreetTime = request.getBetaStreetTime();
            this.limitSolutions = Optional.ofNullable(request.getLimitSolutions()).orElse(this.profileQuery ? 50 : (this.ignoreTransfers ? 1 : Integer.MAX_VALUE));
            this.initialTime = request.getEarliestDepartureTime();
            this.maxProfileDuration = request.getMaxProfileDuration().toMillis();
            this.arriveBy = request.isArriveBy();
            this.walkSpeedKmH = request.getWalkSpeedKmH();
            this.blockedRouteTypes = request.getBlockedRouteTypes();
            this.boardingPenaltiesByRouteType = request.getBoardingPenaltiesByRouteType();
            this.translation = PtRouterFreeWalkImpl.this.translationMap.getWithFallBack(request.getLocale());
            this.enter = request.getPoints().get(0);
            this.exit = request.getPoints().get(1);
            this.limitTripTime = request.getLimitTripTime() != null ? request.getLimitTripTime().toMillis() : Long.MAX_VALUE;
            this.limitStreetTime = request.getLimitStreetTime() != null ? request.getLimitStreetTime().toMillis() : Long.MAX_VALUE;
            this.requestedPathDetails = request.getPathDetails();
            this.accessProfile = PtRouterFreeWalkImpl.this.config.getProfiles().stream().filter(p -> p.getName().equals(request.getAccessProfile())).findFirst().get();
            this.accessWeighting = PtRouterFreeWalkImpl.this.weightingFactory.createWeighting(this.accessProfile, new PMap(), false);
            this.accessSnapFilter = new DefaultSnapFilter(this.accessWeighting, PtRouterFreeWalkImpl.this.encodingManager.getBooleanEncodedValue(Subnetwork.key(this.accessProfile.getName())));
            this.transferProfile = PtRouterFreeWalkImpl.this.config.getProfiles().stream().filter(p -> p.getName().equals("foot")).findFirst().get();
            this.transferWeighting = PtRouterFreeWalkImpl.this.weightingFactory.createWeighting(this.transferProfile, new PMap(), false);
            this.egressProfile = PtRouterFreeWalkImpl.this.config.getProfiles().stream().filter(p -> p.getName().equals(request.getEgressProfile())).findFirst().get();
            this.egressWeighting = PtRouterFreeWalkImpl.this.weightingFactory.createWeighting(this.egressProfile, new PMap(), false);
            this.egressSnapFilter = new DefaultSnapFilter(this.egressWeighting, PtRouterFreeWalkImpl.this.encodingManager.getBooleanEncodedValue(Subnetwork.key(this.egressProfile.getName())));
        }

        GHResponse route() {
            Label.NodeId destNode;
            Label.NodeId startNode;
            StopWatch stopWatch = new StopWatch().start();
            PtLocationSnapper.Result result = new PtLocationSnapper(PtRouterFreeWalkImpl.this.baseGraph, PtRouterFreeWalkImpl.this.locationIndex, PtRouterFreeWalkImpl.this.gtfsStorage).snapAll(Arrays.asList(this.enter, this.exit), Arrays.asList(this.accessSnapFilter, this.egressSnapFilter));
            this.queryGraph = result.queryGraph;
            this.response.addDebugInfo("idLookup:" + stopWatch.stop().getSeconds() + "s");
            if (this.arriveBy) {
                startNode = result.nodes.get(1);
                destNode = result.nodes.get(0);
            } else {
                startNode = result.nodes.get(0);
                destNode = result.nodes.get(1);
            }
            List<List<Label.Transition>> solutions = this.findPaths(startNode, destNode);
            this.parseSolutionsAndAddToResponse(solutions, result.points);
            return this.response;
        }

        private void parseSolutionsAndAddToResponse(List<List<Label.Transition>> solutions, PointList waypoints) {
            TripFromLabel tripFromLabel = new TripFromLabel(this.queryGraph, PtRouterFreeWalkImpl.this.encodingManager, PtRouterFreeWalkImpl.this.gtfsStorage, PtRouterFreeWalkImpl.this.realtimeFeed, PtRouterFreeWalkImpl.this.pathDetailsBuilderFactory, this.walkSpeedKmH);
            for (List<Label.Transition> solution : solutions) {
                ResponsePath responsePath = tripFromLabel.createResponsePath(this.translation, waypoints, this.queryGraph, this.accessWeighting, this.egressWeighting, this.transferWeighting, solution, this.requestedPathDetails);
                responsePath.setImpossible(solution.stream().anyMatch(t2 -> t2.label.impossible));
                responsePath.setTime(solution.get((int)(solution.size() - 1)).label.currentTime - solution.get((int)0).label.currentTime);
                responsePath.setRouteWeight(this.router.weight(solution.get((int)(solution.size() - 1)).label));
                this.response.add(responsePath);
            }
            Comparator<ResponsePath> c = Comparator.comparingInt(p -> p.isImpossible() ? 1 : 0);
            Comparator<ResponsePath> d = Comparator.comparingDouble(ResponsePath::getTime);
            this.response.getAll().sort(c.thenComparing(d));
        }

        private List<List<Label.Transition>> findPaths(Label.NodeId startNode, Label.NodeId destNode) {
            StopWatch stopWatch = new StopWatch().start();
            GraphExplorer graphExplorer = new GraphExplorer(this.queryGraph, PtRouterFreeWalkImpl.this.ptGraph, PtRouterFreeWalkImpl.this.accessEgressWeighting, PtRouterFreeWalkImpl.this.gtfsStorage, PtRouterFreeWalkImpl.this.realtimeFeed, this.arriveBy, false, false, this.walkSpeedKmH, false, this.blockedRouteTypes);
            ArrayList<Label> discoveredSolutions = new ArrayList<Label>();
            this.router = new MultiCriteriaLabelSetting(graphExplorer, this.arriveBy, !this.ignoreTransfers, this.profileQuery, this.maxProfileDuration, discoveredSolutions);
            this.router.setBetaTransfers(this.betaTransfers);
            this.router.setBetaStreetTime(this.betaStreetTime);
            this.router.setLimitStreetTime(this.limitStreetTime);
            this.router.setBoardingPenaltyByRouteType(routeType -> this.boardingPenaltiesByRouteType.getOrDefault(routeType, 0L));
            for (Label label : this.router.calcLabels(startNode, this.initialTime)) {
                ++this.visitedNodes;
                if (this.visitedNodes >= this.maxVisitedNodesForRequest) break;
                if (!label.node.equals(destNode)) continue;
                discoveredSolutions.add(label);
                if (discoveredSolutions.size() < this.limitSolutions) continue;
                break;
            }
            discoveredSolutions.sort(Comparator.comparingLong(s2 -> Optional.ofNullable(s2.departureTime).orElse(0L)));
            ArrayList<List<Label.Transition>> paths = new ArrayList<List<Label.Transition>>();
            for (Label discoveredSolution : discoveredSolutions) {
                List<Label.Transition> path = Label.getTransitions(discoveredSolution, this.arriveBy);
                paths.add(path);
            }
            this.response.addDebugInfo("routing:" + stopWatch.stop().getSeconds() + "s");
            if (discoveredSolutions.isEmpty() && this.visitedNodes >= this.maxVisitedNodesForRequest) {
                this.response.addError(new MaximumNodesExceededException("No path found - maximum number of nodes exceeded: " + this.maxVisitedNodesForRequest, this.maxVisitedNodesForRequest));
            }
            this.response.getHints().putObject("visited_nodes.sum", this.visitedNodes);
            this.response.getHints().putObject("visited_nodes.average", this.visitedNodes);
            if (discoveredSolutions.isEmpty()) {
                this.response.addError(new ConnectionNotFoundException("No route found", Collections.emptyMap()));
            }
            return paths;
        }
    }

    public static class Factory {
        private final GraphHopperConfig config;
        private final TranslationMap translationMap;
        private final BaseGraph baseGraph;
        private final EncodingManager encodingManager;
        private final LocationIndex locationIndex;
        private final GtfsStorage gtfsStorage;
        private final Map<String, Transfers> transfers;

        public Factory(GraphHopperConfig config, TranslationMap translationMap, BaseGraph baseGraph, EncodingManager encodingManager, LocationIndex locationIndex, GtfsStorage gtfsStorage) {
            this.config = config;
            this.translationMap = translationMap;
            this.baseGraph = baseGraph;
            this.encodingManager = encodingManager;
            this.locationIndex = locationIndex;
            this.gtfsStorage = gtfsStorage;
            this.transfers = new HashMap<String, Transfers>();
            for (Map.Entry<String, GTFSFeed> entry : this.gtfsStorage.getGtfsFeeds().entrySet()) {
                this.transfers.put(entry.getKey(), new Transfers(entry.getValue()));
            }
        }

        public PtRouter createWith(GtfsRealtime.FeedMessage realtimeFeed) {
            HashMap<String, GtfsRealtime.FeedMessage> realtimeFeeds = new HashMap<String, GtfsRealtime.FeedMessage>();
            realtimeFeeds.put("gtfs_0", realtimeFeed);
            return new PtRouterFreeWalkImpl(this.config, this.translationMap, this.baseGraph, this.encodingManager, this.locationIndex, this.gtfsStorage, RealtimeFeed.fromProtobuf(this.gtfsStorage, this.transfers, realtimeFeeds), new PathDetailsBuilderFactory());
        }

        public PtRouter createWithoutRealtimeFeed() {
            return new PtRouterFreeWalkImpl(this.config, this.translationMap, this.baseGraph, this.encodingManager, this.locationIndex, this.gtfsStorage, RealtimeFeed.empty(), new PathDetailsBuilderFactory());
        }
    }
}

