/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.gtfs;

import com.conveyal.gtfs.GTFSFeed;
import com.google.transit.realtime.GtfsRealtime;
import com.graphhopper.GHResponse;
import com.graphhopper.GraphHopperConfig;
import com.graphhopper.ResponsePath;
import com.graphhopper.config.Profile;
import com.graphhopper.gtfs.GHLocation;
import com.graphhopper.gtfs.GraphExplorer;
import com.graphhopper.gtfs.GtfsStorage;
import com.graphhopper.gtfs.Label;
import com.graphhopper.gtfs.MultiCriteriaLabelSetting;
import com.graphhopper.gtfs.PtGraph;
import com.graphhopper.gtfs.PtLocationSnapper;
import com.graphhopper.gtfs.PtRouter;
import com.graphhopper.gtfs.RealtimeFeed;
import com.graphhopper.gtfs.Request;
import com.graphhopper.gtfs.Transfers;
import com.graphhopper.gtfs.TripFromLabel;
import com.graphhopper.routing.DefaultWeightingFactory;
import com.graphhopper.routing.WeightingFactory;
import com.graphhopper.routing.ev.Subnetwork;
import com.graphhopper.routing.querygraph.QueryGraph;
import com.graphhopper.routing.util.DefaultSnapFilter;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.storage.index.LocationIndex;
import com.graphhopper.util.PMap;
import com.graphhopper.util.PointList;
import com.graphhopper.util.StopWatch;
import com.graphhopper.util.Translation;
import com.graphhopper.util.TranslationMap;
import com.graphhopper.util.details.PathDetailsBuilderFactory;
import com.graphhopper.util.exceptions.ConnectionNotFoundException;
import com.graphhopper.util.exceptions.MaximumNodesExceededException;
import jakarta.inject.Inject;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public final class PtRouterImpl
implements PtRouter {
    private final GraphHopperConfig config;
    private final TranslationMap translationMap;
    private final BaseGraph baseGraph;
    private final EncodingManager encodingManager;
    private final LocationIndex locationIndex;
    private final GtfsStorage gtfsStorage;
    private final PtGraph ptGraph;
    private final RealtimeFeed realtimeFeed;
    private final PathDetailsBuilderFactory pathDetailsBuilderFactory;
    private final WeightingFactory weightingFactory;

    @Inject
    public PtRouterImpl(GraphHopperConfig config, TranslationMap translationMap, BaseGraph baseGraph, EncodingManager encodingManager, LocationIndex locationIndex, GtfsStorage gtfsStorage, RealtimeFeed realtimeFeed, PathDetailsBuilderFactory pathDetailsBuilderFactory) {
        this.config = config;
        this.weightingFactory = new DefaultWeightingFactory(baseGraph, encodingManager);
        this.translationMap = translationMap;
        this.baseGraph = baseGraph;
        this.encodingManager = encodingManager;
        this.locationIndex = locationIndex;
        this.gtfsStorage = gtfsStorage;
        this.ptGraph = gtfsStorage.getPtGraph();
        this.realtimeFeed = realtimeFeed;
        this.pathDetailsBuilderFactory = pathDetailsBuilderFactory;
    }

    @Override
    public GHResponse route(Request request) {
        return new RequestHandler(request).route();
    }

    private class RequestHandler {
        private final int maxVisitedNodesForRequest;
        private final int limitSolutions;
        private final long maxProfileDuration;
        private final Instant initialTime;
        private final boolean profileQuery;
        private final boolean arriveBy;
        private final boolean ignoreTransfers;
        private final double betaTransfers;
        private final double betaAccessTime;
        private final double betaEgressTime;
        private final double walkSpeedKmH;
        private final int blockedRouteTypes;
        private final Map<Integer, Long> transferPenaltiesByRouteType;
        private final GHLocation enter;
        private final GHLocation exit;
        private final Translation translation;
        private final List<String> requestedPathDetails;
        private final GHResponse response = new GHResponse();
        private final long limitTripTime;
        private final long limitStreetTime;
        private QueryGraph queryGraph;
        private int visitedNodes;
        private MultiCriteriaLabelSetting router;
        private final Profile accessProfile;
        private final EdgeFilter accessSnapFilter;
        private final Weighting accessWeighting;
        private final Profile transferProfile;
        private final Weighting transferWeighting;
        private final Profile egressProfile;
        private final EdgeFilter egressSnapFilter;
        private final Weighting egressWeighting;

        RequestHandler(Request request) {
            this.maxVisitedNodesForRequest = request.getMaxVisitedNodes();
            this.profileQuery = request.isProfileQuery();
            this.ignoreTransfers = Optional.ofNullable(request.getIgnoreTransfers()).orElse(request.isProfileQuery());
            this.betaTransfers = request.getBetaTransfers();
            this.betaAccessTime = request.getBetaAccessTime();
            this.betaEgressTime = request.getBetaEgressTime();
            this.limitSolutions = Optional.ofNullable(request.getLimitSolutions()).orElse(this.profileQuery ? 50 : (this.ignoreTransfers ? 1 : Integer.MAX_VALUE));
            this.initialTime = request.getEarliestDepartureTime();
            this.maxProfileDuration = request.getMaxProfileDuration().toMillis();
            this.arriveBy = request.isArriveBy();
            this.walkSpeedKmH = request.getWalkSpeedKmH();
            this.blockedRouteTypes = request.getBlockedRouteTypes();
            this.transferPenaltiesByRouteType = request.getBoardingPenaltiesByRouteType();
            this.translation = PtRouterImpl.this.translationMap.getWithFallBack(request.getLocale());
            this.enter = request.getPoints().get(0);
            this.exit = request.getPoints().get(1);
            this.limitTripTime = request.getLimitTripTime() != null ? request.getLimitTripTime().toMillis() : Long.MAX_VALUE;
            this.limitStreetTime = request.getLimitStreetTime() != null ? request.getLimitStreetTime().toMillis() : Long.MAX_VALUE;
            this.requestedPathDetails = request.getPathDetails();
            this.accessProfile = PtRouterImpl.this.config.getProfiles().stream().filter(p -> p.getName().equals(request.getAccessProfile())).findFirst().get();
            this.accessWeighting = PtRouterImpl.this.weightingFactory.createWeighting(this.accessProfile, new PMap(), false);
            this.accessSnapFilter = new DefaultSnapFilter(this.accessWeighting, PtRouterImpl.this.encodingManager.getBooleanEncodedValue(Subnetwork.key(this.accessProfile.getName())));
            this.transferProfile = PtRouterImpl.this.config.getProfiles().stream().filter(p -> p.getName().equals("foot")).findFirst().get();
            this.transferWeighting = PtRouterImpl.this.weightingFactory.createWeighting(this.transferProfile, new PMap(), false);
            this.egressProfile = PtRouterImpl.this.config.getProfiles().stream().filter(p -> p.getName().equals(request.getEgressProfile())).findFirst().get();
            this.egressWeighting = PtRouterImpl.this.weightingFactory.createWeighting(this.egressProfile, new PMap(), false);
            this.egressSnapFilter = new DefaultSnapFilter(this.egressWeighting, PtRouterImpl.this.encodingManager.getBooleanEncodedValue(Subnetwork.key(this.egressProfile.getName())));
        }

        GHResponse route() {
            Label.NodeId destNode;
            Label.NodeId startNode;
            StopWatch stopWatch = new StopWatch().start();
            PtLocationSnapper.Result result = new PtLocationSnapper(PtRouterImpl.this.baseGraph, PtRouterImpl.this.locationIndex, PtRouterImpl.this.gtfsStorage).snapAll(Arrays.asList(this.enter, this.exit), Arrays.asList(this.accessSnapFilter, this.egressSnapFilter));
            this.queryGraph = result.queryGraph;
            this.response.addDebugInfo("idLookup:" + stopWatch.stop().getSeconds() + "s");
            if (this.arriveBy) {
                startNode = result.nodes.get(1);
                destNode = result.nodes.get(0);
            } else {
                startNode = result.nodes.get(0);
                destNode = result.nodes.get(1);
            }
            List<List<Label.Transition>> solutions = this.findPaths(startNode, destNode);
            this.parseSolutionsAndAddToResponse(solutions, result.points);
            return this.response;
        }

        private void parseSolutionsAndAddToResponse(List<List<Label.Transition>> solutions, PointList waypoints) {
            TripFromLabel tripFromLabel = new TripFromLabel(this.queryGraph, PtRouterImpl.this.encodingManager, PtRouterImpl.this.gtfsStorage, PtRouterImpl.this.realtimeFeed, PtRouterImpl.this.pathDetailsBuilderFactory, this.walkSpeedKmH);
            for (List<Label.Transition> solution : solutions) {
                ResponsePath responsePath = tripFromLabel.createResponsePath(this.translation, waypoints, this.queryGraph, this.accessWeighting, this.egressWeighting, this.transferWeighting, solution, this.requestedPathDetails);
                responsePath.setImpossible(solution.stream().anyMatch(t2 -> t2.label.impossible));
                responsePath.setTime(solution.get((int)(solution.size() - 1)).label.currentTime - solution.get((int)0).label.currentTime);
                responsePath.setRouteWeight(this.router.weight(solution.get((int)(solution.size() - 1)).label));
                this.response.add(responsePath);
            }
            Comparator<ResponsePath> c = Comparator.comparingInt(p -> p.isImpossible() ? 1 : 0);
            Comparator<ResponsePath> d = Comparator.comparingDouble(ResponsePath::getTime);
            this.response.getAll().sort(c.thenComparing(d));
        }

        private List<List<Label.Transition>> findPaths(Label.NodeId startNode, Label.NodeId destNode) {
            StopWatch stopWatch = new StopWatch().start();
            boolean isEgress = !this.arriveBy;
            GraphExplorer accessEgressGraphExplorer = new GraphExplorer(this.queryGraph, PtRouterImpl.this.ptGraph, isEgress ? this.egressWeighting : this.accessWeighting, PtRouterImpl.this.gtfsStorage, PtRouterImpl.this.realtimeFeed, isEgress, true, false, this.walkSpeedKmH, false, this.blockedRouteTypes);
            GtfsStorage.EdgeType edgeType = isEgress ? GtfsStorage.EdgeType.EXIT_PT : GtfsStorage.EdgeType.ENTER_PT;
            MultiCriteriaLabelSetting stationRouter = new MultiCriteriaLabelSetting(accessEgressGraphExplorer, isEgress, false, false, this.maxProfileDuration, new ArrayList<Label>());
            stationRouter.setBetaStreetTime(isEgress ? this.betaEgressTime : this.betaAccessTime);
            stationRouter.setLimitStreetTime(this.limitStreetTime);
            ArrayList<Label> stationLabels = new ArrayList<Label>();
            for (Label label : stationRouter.calcLabels(destNode, this.initialTime)) {
                ++this.visitedNodes;
                if (label.node.equals(startNode)) {
                    stationLabels.add(label);
                    break;
                }
                if (label.edge == null || label.edge.getType() != edgeType) continue;
                stationLabels.add(label);
            }
            HashMap<Label.NodeId, Label> reverseSettledSet = new HashMap<Label.NodeId, Label>();
            for (Label label : stationLabels) {
                reverseSettledSet.put(label.node, label);
            }
            GraphExplorer graphExplorer = new GraphExplorer(this.queryGraph, PtRouterImpl.this.ptGraph, this.arriveBy ? this.egressWeighting : this.accessWeighting, PtRouterImpl.this.gtfsStorage, PtRouterImpl.this.realtimeFeed, this.arriveBy, false, true, this.walkSpeedKmH, false, this.blockedRouteTypes);
            ArrayList<Label> arrayList = new ArrayList<Label>();
            this.router = new MultiCriteriaLabelSetting(graphExplorer, this.arriveBy, !this.ignoreTransfers, this.profileQuery, this.maxProfileDuration, arrayList);
            this.router.setBetaTransfers(this.betaTransfers);
            this.router.setBetaStreetTime(this.arriveBy ? this.betaEgressTime : this.betaAccessTime);
            this.router.setBoardingPenaltyByRouteType(routeType -> this.transferPenaltiesByRouteType.getOrDefault(routeType, 0L));
            long smallestStationLabelWalkTime = stationLabels.stream().mapToLong(l -> l.streetTime).min().orElse(Long.MAX_VALUE);
            this.router.setLimitTripTime(Math.max(0L, this.limitTripTime - smallestStationLabelWalkTime));
            this.router.setLimitStreetTime(Math.max(0L, this.limitStreetTime - smallestStationLabelWalkTime));
            long smallestStationLabelWeight = !stationLabels.isEmpty() ? stationRouter.weight((Label)stationLabels.get(0)) : Long.MAX_VALUE;
            HashMap<Label, Label> originalSolutions = new HashMap<Label, Label>();
            Label accessEgressModeOnlySolution = null;
            long highestWeightForDominationTest = Long.MAX_VALUE;
            for (Label label : this.router.calcLabels(startNode, this.initialTime)) {
                Predicate<Label> filter;
                ++this.visitedNodes;
                if (this.visitedNodes >= this.maxVisitedNodesForRequest || (!this.profileQuery || this.profileFinished(this.router, arrayList, accessEgressModeOnlySolution)) && this.router.weight(label) + smallestStationLabelWeight > highestWeightForDominationTest) break;
                Label reverseLabel = (Label)reverseSettledSet.get(label.node);
                if (reverseLabel == null) continue;
                long accessTime = label.streetTime;
                long egressTime = reverseLabel.streetTime;
                long disutilityOfAccessTime = (long)((double)accessTime * (this.betaAccessTime - 1.0));
                long disutilityOfEgressTime = (long)((double)egressTime * (this.betaEgressTime - 1.0));
                long disutilityOfStreetTime = disutilityOfAccessTime + disutilityOfEgressTime;
                Label combinedSolution = new Label(label.currentTime - reverseLabel.currentTime + this.initialTime.toEpochMilli(), null, label.node, label.nTransfers + reverseLabel.nTransfers, label.departureTime, 0L, label.extraWeight + reverseLabel.extraWeight + disutilityOfStreetTime, 0L, label.impossible, null);
                if (!this.router.isNotDominatedByAnyOf(combinedSolution, arrayList, filter = this.profileQuery && combinedSolution.departureTime != null ? targetLabel -> !this.arriveBy ? this.router.prc(combinedSolution, (Label)targetLabel) : this.router.rprc(combinedSolution, (Label)targetLabel) : tagetLabel -> true)) continue;
                this.router.removeDominated(combinedSolution, arrayList, filter);
                List closedSolutions = arrayList.stream().filter(s2 -> this.router.weight((Label)s2) < this.router.weight(label) + smallestStationLabelWeight).collect(Collectors.toList());
                if (closedSolutions.size() >= this.limitSolutions || this.profileQuery && combinedSolution.departureTime != null && (combinedSolution.departureTime - this.initialTime.toEpochMilli()) * (this.arriveBy ? -1L : 1L) > this.maxProfileDuration && closedSolutions.size() > 0 && ((Label)closedSolutions.get((int)(closedSolutions.size() - 1))).departureTime != null && (((Label)closedSolutions.get((int)(closedSolutions.size() - 1))).departureTime - this.initialTime.toEpochMilli()) * (this.arriveBy ? -1L : 1L) > this.maxProfileDuration) continue;
                arrayList.add(combinedSolution);
                arrayList.sort(Comparator.comparingLong(s2 -> Optional.ofNullable(s2.departureTime).orElse(0L)));
                originalSolutions.put(combinedSolution, label);
                if (label.nTransfers == 0 && reverseLabel.nTransfers == 0) {
                    accessEgressModeOnlySolution = combinedSolution;
                }
                if (this.profileQuery) {
                    highestWeightForDominationTest = arrayList.stream().mapToLong(this.router::weight).max().orElse(Long.MAX_VALUE);
                    if (accessEgressModeOnlySolution == null || arrayList.size() >= this.limitSolutions) continue;
                    highestWeightForDominationTest = Math.max(highestWeightForDominationTest, this.router.weight(accessEgressModeOnlySolution) + this.maxProfileDuration);
                    continue;
                }
                highestWeightForDominationTest = arrayList.stream().filter(s2 -> !s2.impossible && (this.ignoreTransfers || s2.nTransfers <= 1)).mapToLong(this.router::weight).min().orElse(Long.MAX_VALUE);
            }
            ArrayList<List<Label.Transition>> paths = new ArrayList<List<Label.Transition>>();
            for (Label discoveredSolution : arrayList) {
                Label originalSolution = (Label)originalSolutions.get(discoveredSolution);
                List<Label.Transition> pathToDestinationStop = Label.getTransitions(originalSolution, this.arriveBy);
                if (this.arriveBy) {
                    List<Label.Transition> pathFromStation = Label.getTransitions((Label)reverseSettledSet.get(pathToDestinationStop.get((int)0).label.node), false);
                    long diff = pathToDestinationStop.get((int)0).label.currentTime - pathFromStation.get((int)(pathFromStation.size() - 1)).label.currentTime;
                    List patchedPathFromStation = pathFromStation.stream().map(t2 -> new Label.Transition(new Label(t2.label.currentTime + diff, t2.label.edge, t2.label.node, t2.label.nTransfers, t2.label.departureTime, t2.label.streetTime, t2.label.extraWeight, t2.label.residualDelay, t2.label.impossible, null), t2.edge)).collect(Collectors.toList());
                    ArrayList<Label.Transition> pp = new ArrayList<Label.Transition>(pathToDestinationStop.subList(1, pathToDestinationStop.size()));
                    pp.addAll(0, patchedPathFromStation);
                    paths.add(pp);
                    continue;
                }
                Label destinationStopLabel = pathToDestinationStop.get((int)(pathToDestinationStop.size() - 1)).label;
                List<Label.Transition> pathFromStation = Label.getTransitions((Label)reverseSettledSet.get(destinationStopLabel.node), true);
                long diff = destinationStopLabel.currentTime - pathFromStation.get((int)0).label.currentTime;
                List patchedPathFromStation = pathFromStation.stream().map(t2 -> new Label.Transition(new Label(t2.label.currentTime + diff, t2.label.edge, t2.label.node, destinationStopLabel.nTransfers + t2.label.nTransfers, t2.label.departureTime, destinationStopLabel.streetTime + ((Label.Transition)pathFromStation.get((int)0)).label.streetTime, destinationStopLabel.extraWeight + t2.label.extraWeight, t2.label.residualDelay, t2.label.impossible, null), t2.edge)).collect(Collectors.toList());
                ArrayList<Label.Transition> pp = new ArrayList<Label.Transition>(pathToDestinationStop);
                pp.addAll(patchedPathFromStation.subList(1, pathFromStation.size()));
                paths.add(pp);
            }
            this.response.addDebugInfo("routing:" + stopWatch.stop().getSeconds() + "s");
            if (arrayList.isEmpty() && this.visitedNodes >= this.maxVisitedNodesForRequest) {
                this.response.addError(new MaximumNodesExceededException("No path found - maximum number of nodes exceeded: " + this.maxVisitedNodesForRequest, this.maxVisitedNodesForRequest));
            }
            this.response.getHints().putObject("visited_nodes.sum", this.visitedNodes);
            this.response.getHints().putObject("visited_nodes.average", this.visitedNodes);
            if (arrayList.isEmpty()) {
                this.response.addError(new ConnectionNotFoundException("No route found", Collections.emptyMap()));
            }
            return paths;
        }

        private boolean profileFinished(MultiCriteriaLabelSetting router, List<Label> discoveredSolutions, Label walkSolution) {
            return discoveredSolutions.size() >= this.limitSolutions || !discoveredSolutions.isEmpty() && router.departureTimeSinceStartTime(discoveredSolutions.get(discoveredSolutions.size() - 1)) != null && router.departureTimeSinceStartTime(discoveredSolutions.get(discoveredSolutions.size() - 1)) > this.maxProfileDuration || walkSolution != null;
        }
    }

    public static class Factory {
        private final GraphHopperConfig config;
        private final TranslationMap translationMap;
        private final BaseGraph baseGraph;
        private final EncodingManager encodingManager;
        private final LocationIndex locationIndex;
        private final GtfsStorage gtfsStorage;
        private final Map<String, Transfers> transfers;

        public Factory(GraphHopperConfig config, TranslationMap translationMap, BaseGraph baseGraph, EncodingManager encodingManager, LocationIndex locationIndex, GtfsStorage gtfsStorage) {
            this.config = config;
            this.translationMap = translationMap;
            this.baseGraph = baseGraph;
            this.encodingManager = encodingManager;
            this.locationIndex = locationIndex;
            this.gtfsStorage = gtfsStorage;
            this.transfers = new HashMap<String, Transfers>();
            for (Map.Entry<String, GTFSFeed> entry : this.gtfsStorage.getGtfsFeeds().entrySet()) {
                this.transfers.put(entry.getKey(), new Transfers(entry.getValue()));
            }
        }

        public PtRouter createWith(GtfsRealtime.FeedMessage realtimeFeed) {
            HashMap<String, GtfsRealtime.FeedMessage> realtimeFeeds = new HashMap<String, GtfsRealtime.FeedMessage>();
            realtimeFeeds.put("gtfs_0", realtimeFeed);
            return new PtRouterImpl(this.config, this.translationMap, this.baseGraph, this.encodingManager, this.locationIndex, this.gtfsStorage, RealtimeFeed.fromProtobuf(this.gtfsStorage, this.transfers, realtimeFeeds), new PathDetailsBuilderFactory());
        }

        public PtRouter createWithoutRealtimeFeed() {
            return new PtRouterImpl(this.config, this.translationMap, this.baseGraph, this.encodingManager, this.locationIndex, this.gtfsStorage, RealtimeFeed.empty(), new PathDetailsBuilderFactory());
        }
    }
}

