/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.gtfs;

import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.IntHashSet;
import com.carrotsearch.hppc.IntLongHashMap;
import com.conveyal.gtfs.GTFSFeed;
import com.conveyal.gtfs.model.Frequency;
import com.conveyal.gtfs.model.StopTime;
import com.conveyal.gtfs.model.Trip;
import com.google.transit.realtime.GtfsRealtime;
import com.graphhopper.gtfs.GtfsReader;
import com.graphhopper.gtfs.GtfsStorage;
import com.graphhopper.gtfs.PtEdgeAttributes;
import com.graphhopper.gtfs.PtGraph;
import com.graphhopper.gtfs.Transfers;
import java.io.FileOutputStream;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.mapdb.Fun;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RealtimeFeed {
    private static final Logger logger = LoggerFactory.getLogger(RealtimeFeed.class);
    private final IntHashSet blockedEdges;
    private final IntLongHashMap delaysForBoardEdges;
    private final IntLongHashMap delaysForAlightEdges;
    private final TreeSet<PtGraph.PtEdge> additionalEdgesByBaseNode;
    private final TreeSet<PtGraph.PtEdge> additionalEdgesByAdjNode;
    public final Map<String, GtfsRealtime.FeedMessage> feedMessages;

    private RealtimeFeed(Map<String, GtfsRealtime.FeedMessage> feedMessages, IntHashSet blockedEdges, IntLongHashMap delaysForBoardEdges, IntLongHashMap delaysForAlightEdges, List<PtGraph.PtEdge> additionalEdges) {
        this.feedMessages = feedMessages;
        this.blockedEdges = blockedEdges;
        this.delaysForBoardEdges = delaysForBoardEdges;
        this.delaysForAlightEdges = delaysForAlightEdges;
        this.additionalEdgesByBaseNode = new TreeSet<PtGraph.PtEdge>(Comparator.comparingInt(PtGraph.PtEdge::getBaseNode).thenComparingInt(PtGraph.PtEdge::getId));
        this.additionalEdgesByBaseNode.addAll(additionalEdges);
        this.additionalEdgesByAdjNode = new TreeSet<PtGraph.PtEdge>(Comparator.comparingInt(PtGraph.PtEdge::getAdjNode).thenComparingInt(PtGraph.PtEdge::getId));
        this.additionalEdgesByAdjNode.addAll(additionalEdges);
    }

    public static RealtimeFeed empty() {
        return new RealtimeFeed(Collections.emptyMap(), new IntHashSet(), new IntLongHashMap(), new IntLongHashMap(), Collections.emptyList());
    }

    public static RealtimeFeed fromProtobuf(final GtfsStorage staticGtfs, Map<String, Transfers> transfers, Map<String, GtfsRealtime.FeedMessage> feedMessages) {
        IntHashSet blockedEdges = new IntHashSet();
        IntLongHashMap delaysForBoardEdges = new IntLongHashMap();
        IntLongHashMap delaysForAlightEdges = new IntLongHashMap();
        final LinkedList<PtGraph.PtEdge> additionalEdges = new LinkedList<PtGraph.PtEdge>();
        GtfsReader.PtGraphOut overlayGraph = new GtfsReader.PtGraphOut(){
            int nextEdge;
            int nextNode;
            {
                this.nextEdge = staticGtfs.getPtGraph().getEdgeCount();
                this.nextNode = staticGtfs.getPtGraph().getNodeCount();
            }

            @Override
            public int createEdge(int src, int dest, PtEdgeAttributes attrs) {
                int edgeId = this.nextEdge++;
                PtGraph.PtEdge e = new PtGraph.PtEdge(edgeId, src, dest, attrs);
                assert (this.canBeAdded(e));
                additionalEdges.add(e);
                return edgeId;
            }

            private boolean canBeAdded(PtGraph.PtEdge e) {
                return e.getType() == GtfsStorage.EdgeType.ENTER_PT || !staticGtfs.getPtToStreet().containsKey(e.getBaseNode());
            }

            @Override
            public int createNode() {
                return this.nextNode++;
            }
        };
        feedMessages.forEach((feedKey, feedMessage) -> {
            GTFSFeed feed = staticGtfs.getGtfsFeeds().get(feedKey);
            ZoneId timezone = ZoneId.of(feed.agency.values().stream().findFirst().get().agency_timezone);
            PtGraph ptGraphNodesAndEdges = staticGtfs.getPtGraph();
            GtfsReader gtfsReader = new GtfsReader((String)feedKey, ptGraphNodesAndEdges, overlayGraph, staticGtfs, null, (Transfers)transfers.get(feedKey), null);
            Instant timestamp = Instant.ofEpochSecond(feedMessage.getHeader().getTimestamp());
            LocalDate dateToChange = timestamp.atZone(timezone).toLocalDate();
            BitSet validOnDay = new BitSet();
            LocalDate startDate = feed.getStartDate();
            validOnDay.set((int)ChronoUnit.DAYS.between(startDate, dateToChange));
            feedMessage.getEntityList().stream().filter(GtfsRealtime.FeedEntity::hasTripUpdate).map(GtfsRealtime.FeedEntity::getTripUpdate).filter(tripUpdate -> tripUpdate.getTrip().getScheduleRelationship() == GtfsRealtime.TripDescriptor.ScheduleRelationship.SCHEDULED).forEach(tripUpdate -> RealtimeFeed.maybeUpdateScheduledTrip(staticGtfs, feedKey, tripUpdate, feed, blockedEdges, delaysForAlightEdges, ptGraphNodesAndEdges, gtfsReader, timezone, validOnDay, delaysForBoardEdges));
            feedMessage.getEntityList().stream().filter(GtfsRealtime.FeedEntity::hasTripUpdate).map(GtfsRealtime.FeedEntity::getTripUpdate).filter(tripUpdate -> tripUpdate.getTrip().getScheduleRelationship() == GtfsRealtime.TripDescriptor.ScheduleRelationship.ADDED).forEach(tripUpdate -> RealtimeFeed.maybeAddExtraTrip(staticGtfs, feedKey, tripUpdate, timezone, validOnDay, gtfsReader));
            gtfsReader.wireUpAdditionalDeparturesAndArrivals(timezone);
        });
        return new RealtimeFeed(feedMessages, blockedEdges, delaysForBoardEdges, delaysForAlightEdges, additionalEdges);
    }

    private static void maybeUpdateScheduledTrip(GtfsStorage staticGtfs, String feedKey, GtfsRealtime.TripUpdate tripUpdate, GTFSFeed feed, IntHashSet blockedEdges, IntLongHashMap delaysForAlightEdges, PtGraph ptGraphNodesAndEdges, GtfsReader gtfsReader, ZoneId timezone, BitSet validOnDay, IntLongHashMap delaysForBoardEdges) {
        Collection<Frequency> frequencies = feed.getFrequencies(tripUpdate.getTrip().getTripId());
        int timeOffset = tripUpdate.getTrip().hasStartTime() && !frequencies.isEmpty() ? LocalTime.parse(tripUpdate.getTrip().getStartTime()).toSecondOfDay() : 0;
        int[] boardEdges = RealtimeFeed.findBoardEdgesForTrip(staticGtfs, feedKey, feed, tripUpdate.getTrip());
        int[] leaveEdges = RealtimeFeed.findAlightEdgesForTrip(staticGtfs, feedKey, feed, tripUpdate.getTrip());
        if (boardEdges == null || leaveEdges == null) {
            logger.warn("Trip not found: {}", (Object)tripUpdate.getTrip());
            return;
        }
        tripUpdate.getStopTimeUpdateList().stream().filter(stopTimeUpdate -> stopTimeUpdate.getScheduleRelationship() == GtfsRealtime.TripUpdate.StopTimeUpdate.ScheduleRelationship.SKIPPED).mapToInt(GtfsRealtime.TripUpdate.StopTimeUpdate::getStopSequence).forEach(skippedStopSequenceNumber -> {
            blockedEdges.add(boardEdges[skippedStopSequenceNumber]);
            blockedEdges.add(leaveEdges[skippedStopSequenceNumber]);
        });
        GtfsReader.TripWithStopTimes tripWithStopTimes = RealtimeFeed.toTripWithStopTimes(feed, tripUpdate);
        tripWithStopTimes.stopTimes.forEach(stopTime -> {
            if (stopTime.stop_sequence > leaveEdges.length - 1) {
                logger.warn("Stop sequence number too high {} vs {}", (Object)stopTime.stop_sequence, (Object)leaveEdges.length);
                return;
            }
            StopTime originalStopTime = feed.stop_times.get(new Fun.Tuple2<String, Integer>(tripUpdate.getTrip().getTripId(), stopTime.stop_sequence));
            int arrivalDelay = stopTime.arrival_time - originalStopTime.arrival_time;
            delaysForAlightEdges.put(leaveEdges[stopTime.stop_sequence], arrivalDelay * 1000);
            int departureDelay = stopTime.departure_time - originalStopTime.departure_time;
            if (departureDelay > 0) {
                int boardEdge = boardEdges[stopTime.stop_sequence];
                int departureNode = ptGraphNodesAndEdges.edge(boardEdge).getAdjNode();
                int delayedBoardEdge = gtfsReader.addDelayedBoardEdge(timezone, tripUpdate.getTrip(), stopTime.stop_sequence, stopTime.departure_time + timeOffset, departureNode, validOnDay);
                delaysForBoardEdges.put(delayedBoardEdge, departureDelay * 1000);
            }
        });
    }

    private static void maybeAddExtraTrip(GtfsStorage staticGtfs, String feedKey, GtfsRealtime.TripUpdate tripUpdate, ZoneId timezone, BitSet validOnDay, GtfsReader gtfsReader) {
        GTFSFeed feed = staticGtfs.getGtfsFeeds().get(feedKey);
        Trip trip = new Trip();
        trip.trip_id = tripUpdate.getTrip().getTripId();
        Trip existingTrip = feed.trips.get(trip.trip_id);
        if (existingTrip != null) {
            trip.route_id = existingTrip.route_id;
        } else if (tripUpdate.getTrip().hasRouteId() && feed.routes.containsKey(tripUpdate.getTrip().getRouteId())) {
            trip.route_id = tripUpdate.getTrip().getRouteId();
        } else {
            logger.error("We need to know at least a valid route id for ADDED trip {}", (Object)trip.trip_id);
            return;
        }
        List<StopTime> stopTimes = tripUpdate.getStopTimeUpdateList().stream().map(stopTimeUpdate -> {
            StopTime stopTime = new StopTime();
            stopTime.stop_sequence = stopTimeUpdate.getStopSequence();
            stopTime.stop_id = stopTimeUpdate.getStopId();
            stopTime.trip_id = trip.trip_id;
            ZonedDateTime arrival_time = Instant.ofEpochSecond(stopTimeUpdate.getArrival().getTime()).atZone(timezone);
            stopTime.arrival_time = (int)Duration.between(arrival_time.truncatedTo(ChronoUnit.DAYS), arrival_time).getSeconds();
            ZonedDateTime departure_time = Instant.ofEpochSecond(stopTimeUpdate.getArrival().getTime()).atZone(timezone);
            stopTime.departure_time = (int)Duration.between(departure_time.truncatedTo(ChronoUnit.DAYS), departure_time).getSeconds();
            return stopTime;
        }).collect(Collectors.toList());
        if (stopTimes.stream().anyMatch(stopTime -> !feed.stops.containsKey(stopTime.stop_id))) {
            logger.error("ADDED trip {} contains unknown stop id", (Object)trip.trip_id);
            return;
        }
        GtfsReader.TripWithStopTimes tripWithStopTimes = new GtfsReader.TripWithStopTimes(trip, stopTimes, validOnDay, Collections.emptySet(), Collections.emptySet());
        gtfsReader.addTrip(timezone, 0, new ArrayList<GtfsReader.TripWithStopTimeAndArrivalNode>(), tripWithStopTimes, tripUpdate.getTrip());
    }

    public static int[] findAlightEdgesForTrip(GtfsStorage staticGtfs, String feedKey, GTFSFeed feed, GtfsRealtime.TripDescriptor tripDescriptor) {
        Trip trip = feed.trips.get(tripDescriptor.getTripId());
        StopTime next = feed.getOrderedStopTimesForTrip(trip.trip_id).iterator().next();
        int station = staticGtfs.getStationNodes().get(new GtfsStorage.FeedIdWithStopId(feedKey, next.stop_id));
        Optional<PtGraph.PtEdge> firstAlighting = StreamSupport.stream(staticGtfs.getPtGraph().backEdgesAround(station).spliterator(), false).flatMap(e -> StreamSupport.stream(staticGtfs.getPtGraph().backEdgesAround(e.getAdjNode()).spliterator(), false)).flatMap(e -> StreamSupport.stream(staticGtfs.getPtGraph().backEdgesAround(e.getAdjNode()).spliterator(), false)).filter(e -> e.getType() == GtfsStorage.EdgeType.ALIGHT).filter(e -> RealtimeFeed.isDescribedBy(e.getAttrs().tripDescriptor, tripDescriptor)).min(Comparator.comparingInt(e -> e.getAttrs().stop_sequence));
        if (firstAlighting.isEmpty()) {
            return null;
        }
        int n = firstAlighting.get().getAdjNode();
        Stream<PtGraph.PtEdge> leaveEdges = RealtimeFeed.evenIndexed(RealtimeFeed.nodes(RealtimeFeed.hopDwellChain(staticGtfs, n))).mapToObj(e -> RealtimeFeed.alightForBaseNode(staticGtfs, e));
        return RealtimeFeed.collectWithPadding(leaveEdges);
    }

    public static int[] findBoardEdgesForTrip(GtfsStorage staticGtfs, String feedKey, GTFSFeed feed, GtfsRealtime.TripDescriptor tripDescriptor) {
        Trip trip = feed.trips.get(tripDescriptor.getTripId());
        StopTime next = feed.getOrderedStopTimesForTrip(trip.trip_id).iterator().next();
        int station = staticGtfs.getStationNodes().get(new GtfsStorage.FeedIdWithStopId(feedKey, next.stop_id));
        Optional<PtGraph.PtEdge> firstBoarding = StreamSupport.stream(staticGtfs.getPtGraph().edgesAround(station).spliterator(), false).flatMap(e -> StreamSupport.stream(staticGtfs.getPtGraph().edgesAround(e.getAdjNode()).spliterator(), false)).flatMap(e -> StreamSupport.stream(staticGtfs.getPtGraph().edgesAround(e.getAdjNode()).spliterator(), false)).filter(e -> e.getType() == GtfsStorage.EdgeType.BOARD).filter(e -> RealtimeFeed.isDescribedBy(e.getAttrs().tripDescriptor, tripDescriptor)).min(Comparator.comparingInt(e -> e.getAttrs().stop_sequence));
        if (firstBoarding.isEmpty()) {
            return null;
        }
        int n = firstBoarding.get().getAdjNode();
        Stream<PtGraph.PtEdge> boardEdges = RealtimeFeed.evenIndexed(RealtimeFeed.nodes(RealtimeFeed.hopDwellChain(staticGtfs, n))).mapToObj(e -> RealtimeFeed.boardForAdjNode(staticGtfs, e));
        return RealtimeFeed.collectWithPadding(boardEdges);
    }

    private static boolean isDescribedBy(GtfsRealtime.TripDescriptor a, GtfsRealtime.TripDescriptor b) {
        if (a.hasTripId() && !a.getTripId().equals(b.getTripId())) {
            return false;
        }
        return !a.hasStartTime() || a.getStartTime().equals(b.getStartTime());
    }

    public static Stream<PtGraph.PtEdge> findAllBoardings(GtfsStorage staticGtfs, GtfsStorage.FeedIdWithStopId feedIdWithStopId) {
        Integer station = staticGtfs.getStationNodes().get(feedIdWithStopId);
        if (station == null) {
            return Stream.empty();
        }
        return StreamSupport.stream(staticGtfs.getPtGraph().edgesAround(station).spliterator(), false).flatMap(e -> StreamSupport.stream(staticGtfs.getPtGraph().edgesAround(e.getAdjNode()).spliterator(), false)).filter(e -> e.getAttrs().feedIdWithTimezone.feedId.equals(feedIdWithStopId.feedId)).flatMap(e -> StreamSupport.stream(staticGtfs.getPtGraph().edgesAround(e.getAdjNode()).spliterator(), false)).filter(e -> e.getType() == GtfsStorage.EdgeType.BOARD);
    }

    private static int[] collectWithPadding(Stream<PtGraph.PtEdge> boardEdges) {
        IntArrayList result = new IntArrayList();
        boardEdges.forEach(boardEdge -> {
            while (result.size() < boardEdge.getAttrs().stop_sequence) {
                result.add(-1);
            }
            result.add(boardEdge.getId());
        });
        return result.toArray();
    }

    private static PtGraph.PtEdge alightForBaseNode(GtfsStorage staticGtfs, int n) {
        return StreamSupport.stream(staticGtfs.getPtGraph().edgesAround(n).spliterator(), false).filter(e -> e.getType() == GtfsStorage.EdgeType.ALIGHT).findAny().get();
    }

    private static PtGraph.PtEdge boardForAdjNode(GtfsStorage staticGtfs, int n) {
        return StreamSupport.stream(staticGtfs.getPtGraph().backEdgesAround(n).spliterator(), false).filter(e -> e.getType() == GtfsStorage.EdgeType.BOARD).findAny().get();
    }

    private static IntStream evenIndexed(IntStream nodes) {
        int[] ints = nodes.toArray();
        IntStream.Builder builder = IntStream.builder();
        for (int i = 0; i < ints.length; ++i) {
            if (i % 2 != 0) continue;
            builder.add(ints[i]);
        }
        return builder.build();
    }

    private static IntStream nodes(Stream<PtGraph.PtEdge> path) {
        List edges = path.collect(Collectors.toList());
        IntStream.Builder builder = IntStream.builder();
        builder.accept(((PtGraph.PtEdge)edges.get(0)).getBaseNode());
        for (PtGraph.PtEdge edge : edges) {
            builder.accept(edge.getAdjNode());
        }
        return builder.build();
    }

    private static Stream<PtGraph.PtEdge> hopDwellChain(GtfsStorage staticGtfs, int n) {
        Stream.Builder<PtGraph.PtEdge> builder = Stream.builder();
        Optional<PtGraph.PtEdge> any = StreamSupport.stream(staticGtfs.getPtGraph().edgesAround(n).spliterator(), false).filter(e -> e.getType() == GtfsStorage.EdgeType.HOP || e.getType() == GtfsStorage.EdgeType.DWELL).findAny();
        while (any.isPresent()) {
            builder.accept(any.get());
            any = StreamSupport.stream(staticGtfs.getPtGraph().edgesAround(any.get().getAdjNode()).spliterator(), false).filter(e -> e.getType() == GtfsStorage.EdgeType.HOP || e.getType() == GtfsStorage.EdgeType.DWELL).findAny();
        }
        return builder.build();
    }

    boolean isBlocked(int edgeId) {
        return this.blockedEdges.contains(edgeId);
    }

    SortedSet<PtGraph.PtEdge> getAdditionalEdgesFrom(int node) {
        return this.additionalEdgesByBaseNode.subSet(new PtGraph.PtEdge(0, node, 0, null), new PtGraph.PtEdge(0, node + 1, 0, null));
    }

    SortedSet<PtGraph.PtEdge> getAdditionalEdgesTo(int node) {
        return this.additionalEdgesByAdjNode.subSet(new PtGraph.PtEdge(0, 0, node, null), new PtGraph.PtEdge(0, 0, node + 1, null));
    }

    public Optional<GtfsReader.TripWithStopTimes> getTripUpdate(GTFSFeed staticFeed, GtfsRealtime.TripDescriptor trip, Instant boardTime) {
        try {
            logger.trace("getTripUpdate {}", (Object)trip);
            if (!this.isThisRealtimeUpdateAboutThisLineRun(boardTime)) {
                return Optional.empty();
            }
            return this.feedMessages.values().stream().flatMap(feedMessage -> feedMessage.getEntityList().stream().filter(e -> e.hasTripUpdate()).map(e -> e.getTripUpdate()).filter(tu -> RealtimeFeed.isDescribedBy(trip, tu.getTrip())).map(tu -> RealtimeFeed.toTripWithStopTimes(staticFeed, tu))).findFirst();
        }
        catch (RuntimeException e) {
            this.feedMessages.forEach((name, feed) -> {
                try (FileOutputStream s2 = new FileOutputStream(name + ".gtfsdump");){
                    feed.writeTo(s2);
                }
                catch (IOException e1) {
                    throw new RuntimeException();
                }
            });
            return Optional.empty();
        }
    }

    public static GtfsReader.TripWithStopTimes toTripWithStopTimes(GTFSFeed feed, GtfsRealtime.TripUpdate tripUpdate) {
        List<StopTime> interpolatedStopTimesForTrip;
        ZoneId timezone = ZoneId.of(feed.agency.values().stream().findFirst().get().agency_timezone);
        logger.trace("{}", (Object)tripUpdate.getTrip());
        ArrayList<StopTime> stopTimes = new ArrayList<StopTime>();
        HashSet<Integer> cancelledArrivals = new HashSet<Integer>();
        HashSet<Integer> cancelledDepartures = new HashSet<Integer>();
        Trip originalTrip = feed.trips.get(tripUpdate.getTrip().getTripId());
        Trip trip = new Trip();
        if (originalTrip != null) {
            trip.trip_id = originalTrip.trip_id;
            trip.route_id = originalTrip.route_id;
        } else {
            trip.trip_id = tripUpdate.getTrip().getTripId();
            trip.route_id = tripUpdate.getTrip().getRouteId();
        }
        int delay = 0;
        int time = -1;
        ArrayList<GtfsRealtime.TripUpdate.StopTimeUpdate> stopTimeUpdateListWithSentinel = new ArrayList<GtfsRealtime.TripUpdate.StopTimeUpdate>(tripUpdate.getStopTimeUpdateList());
        try {
            interpolatedStopTimesForTrip = feed.getInterpolatedStopTimesForTrip(tripUpdate.getTrip().getTripId());
        }
        catch (GTFSFeed.FirstAndLastStopsDoNotHaveTimes firstAndLastStopsDoNotHaveTimes) {
            throw new RuntimeException(firstAndLastStopsDoNotHaveTimes);
        }
        int stopSequenceCeiling = Math.max(stopTimeUpdateListWithSentinel.isEmpty() ? 0 : ((GtfsRealtime.TripUpdate.StopTimeUpdate)stopTimeUpdateListWithSentinel.get(stopTimeUpdateListWithSentinel.size() - 1)).getStopSequence(), StreamSupport.stream(interpolatedStopTimesForTrip.spliterator(), false).mapToInt(stopTime -> stopTime.stop_sequence).max().orElse(0)) + 1;
        stopTimeUpdateListWithSentinel.add(GtfsRealtime.TripUpdate.StopTimeUpdate.newBuilder().setStopSequence(stopSequenceCeiling).setScheduleRelationship(GtfsRealtime.TripUpdate.StopTimeUpdate.ScheduleRelationship.NO_DATA).build());
        for (GtfsRealtime.TripUpdate.StopTimeUpdate stopTimeUpdate : stopTimeUpdateListWithSentinel) {
            int nextStopSequence;
            for (int i = nextStopSequence = stopTimes.isEmpty() ? 1 : ((StopTime)stopTimes.get((int)(stopTimes.size() - 1))).stop_sequence + 1; i < stopTimeUpdate.getStopSequence(); ++i) {
                StopTime previousOriginalStopTime = feed.stop_times.get(new Fun.Tuple2<String, Integer>(tripUpdate.getTrip().getTripId(), i));
                if (previousOriginalStopTime == null) continue;
                StopTime updatedPreviousStopTime = previousOriginalStopTime.clone();
                updatedPreviousStopTime.arrival_time = Math.max(previousOriginalStopTime.arrival_time + delay, time);
                logger.trace("stop_sequence {} scheduled arrival {} updated arrival {}", i, previousOriginalStopTime.arrival_time, updatedPreviousStopTime.arrival_time);
                time = updatedPreviousStopTime.arrival_time;
                updatedPreviousStopTime.departure_time = Math.max(previousOriginalStopTime.departure_time + delay, time);
                logger.trace("stop_sequence {} scheduled departure {} updated departure {}", i, previousOriginalStopTime.departure_time, updatedPreviousStopTime.departure_time);
                time = updatedPreviousStopTime.departure_time;
                stopTimes.add(updatedPreviousStopTime);
                logger.trace("Number of stop times: {}", (Object)stopTimes.size());
            }
            StopTime originalStopTime = feed.stop_times.get(new Fun.Tuple2<String, Integer>(tripUpdate.getTrip().getTripId(), stopTimeUpdate.getStopSequence()));
            if (originalStopTime != null) {
                StopTime updatedStopTime = originalStopTime.clone();
                if (stopTimeUpdate.getScheduleRelationship() == GtfsRealtime.TripUpdate.StopTimeUpdate.ScheduleRelationship.NO_DATA) {
                    delay = 0;
                }
                if (stopTimeUpdate.hasArrival()) {
                    delay = stopTimeUpdate.getArrival().getDelay();
                }
                updatedStopTime.arrival_time = Math.max(originalStopTime.arrival_time + delay, time);
                logger.trace("stop_sequence {} scheduled arrival {} updated arrival {}", stopTimeUpdate.getStopSequence(), originalStopTime.arrival_time, updatedStopTime.arrival_time);
                time = updatedStopTime.arrival_time;
                if (stopTimeUpdate.hasDeparture()) {
                    delay = stopTimeUpdate.getDeparture().getDelay();
                }
                updatedStopTime.departure_time = Math.max(originalStopTime.departure_time + delay, time);
                logger.trace("stop_sequence {} scheduled departure {} updated departure {}", stopTimeUpdate.getStopSequence(), originalStopTime.departure_time, updatedStopTime.departure_time);
                time = updatedStopTime.departure_time;
                stopTimes.add(updatedStopTime);
                logger.trace("Number of stop times: {}", (Object)stopTimes.size());
                if (stopTimeUpdate.getScheduleRelationship() != GtfsRealtime.TripUpdate.StopTimeUpdate.ScheduleRelationship.SKIPPED) continue;
                cancelledArrivals.add(stopTimeUpdate.getStopSequence());
                cancelledDepartures.add(stopTimeUpdate.getStopSequence());
                continue;
            }
            if (stopTimeUpdate.getScheduleRelationship() == GtfsRealtime.TripUpdate.StopTimeUpdate.ScheduleRelationship.NO_DATA) continue;
            if (tripUpdate.getTrip().getScheduleRelationship() == GtfsRealtime.TripDescriptor.ScheduleRelationship.ADDED) {
                StopTime stopTime2 = new StopTime();
                stopTime2.stop_sequence = stopTimeUpdate.getStopSequence();
                stopTime2.stop_id = stopTimeUpdate.getStopId();
                stopTime2.trip_id = trip.trip_id;
                ZonedDateTime arrival_time = Instant.ofEpochSecond(stopTimeUpdate.getArrival().getTime()).atZone(timezone);
                stopTime2.arrival_time = (int)Duration.between(arrival_time.truncatedTo(ChronoUnit.DAYS), arrival_time).getSeconds();
                ZonedDateTime departure_time = Instant.ofEpochSecond(stopTimeUpdate.getArrival().getTime()).atZone(timezone);
                stopTime2.departure_time = (int)Duration.between(departure_time.truncatedTo(ChronoUnit.DAYS), departure_time).getSeconds();
                stopTimes.add(stopTime2);
                logger.trace("Number of stop times: {}", (Object)stopTimes.size());
                continue;
            }
            throw new RuntimeException();
        }
        logger.trace("Number of stop times: {}", (Object)stopTimes.size());
        BitSet validOnDay = new BitSet();
        return new GtfsReader.TripWithStopTimes(trip, stopTimes, validOnDay, cancelledArrivals, cancelledDepartures);
    }

    public long getDelayForBoardEdge(PtGraph.PtEdge edge, Instant now) {
        if (this.isThisRealtimeUpdateAboutThisLineRun(now)) {
            return this.delaysForBoardEdges.getOrDefault(edge.getId(), 0L);
        }
        return 0L;
    }

    public long getDelayForAlightEdge(PtGraph.PtEdge edge, Instant now) {
        if (this.isThisRealtimeUpdateAboutThisLineRun(now)) {
            return this.delaysForAlightEdges.getOrDefault(edge.getId(), 0L);
        }
        return 0L;
    }

    boolean isThisRealtimeUpdateAboutThisLineRun(Instant now) {
        return Duration.between(this.feedTimestampOrNow(), now).toHours() <= 24L;
    }

    private Instant feedTimestampOrNow() {
        return this.feedMessages.values().stream().map(feedMessage -> {
            if (feedMessage.getHeader().hasTimestamp()) {
                return Instant.ofEpochSecond(feedMessage.getHeader().getTimestamp());
            }
            return Instant.now();
        }).findFirst().orElse(Instant.now());
    }

    public StopTime getStopTime(GTFSFeed staticFeed, GtfsRealtime.TripDescriptor tripDescriptor, Instant boardTime, int stopSequence) {
        StopTime stopTime = staticFeed.stop_times.get(new Fun.Tuple2<String, Integer>(tripDescriptor.getTripId(), stopSequence));
        if (stopTime == null) {
            return this.getTripUpdate((GTFSFeed)staticFeed, (GtfsRealtime.TripDescriptor)tripDescriptor, (Instant)boardTime).get().stopTimes.get(stopSequence - 1);
        }
        return stopTime;
    }
}

