/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.gtfs;

import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.ObjectIntHashMap;
import com.conveyal.gtfs.GTFSFeed;
import com.conveyal.gtfs.model.Entity;
import com.conveyal.gtfs.model.Frequency;
import com.conveyal.gtfs.model.Route;
import com.conveyal.gtfs.model.Service;
import com.conveyal.gtfs.model.StopTime;
import com.conveyal.gtfs.model.Transfer;
import com.conveyal.gtfs.model.Trip;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.graphhopper.gtfs.GtfsStorage;
import com.graphhopper.gtfs.Transfers;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;

public class Trips {
    public final List<GTFSFeed.StopTimesForTripWithTripPatternKey> trips;
    private Map<GtfsStorage.FeedIdWithStopId, Map<String, List<TripAtStopTime>>> boardingsForStopByPattern = new ConcurrentHashMap<GtfsStorage.FeedIdWithStopId, Map<String, List<TripAtStopTime>>>();
    private Map<LocalDate, Map<TripAtStopTime, Collection<TripAtStopTime>>> tripTransfersPerDay = new ConcurrentHashMap<LocalDate, Map<TripAtStopTime, Collection<TripAtStopTime>>>();
    public int idx;
    GtfsStorage gtfsStorage;

    public Trips(GtfsStorage gtfsStorage) {
        this.gtfsStorage = gtfsStorage;
        this.trips = new ArrayList<GTFSFeed.StopTimesForTripWithTripPatternKey>();
        this.idx = 0;
        for (Map.Entry<String, GTFSFeed> entry : this.gtfsStorage.getGtfsFeeds().entrySet()) {
            GTFSFeed feed = entry.getValue();
            LinkedHashMap<TripPatternKey, Pattern> patterns = new LinkedHashMap<TripPatternKey, Pattern>();
            int nextPatternId = 1;
            for (Trip trip : feed.trips.values()) {
                Collection<Frequency> frequencies;
                TripPatternKey key = new TripPatternKey();
                Route route = feed.routes.get(trip.route_id);
                Service service = feed.services.get(trip.service_id);
                ArrayList<StopTime> orderedStopTimesForTripWithPadding = new ArrayList<StopTime>();
                List<StopTime> interpolatedStopTimesForTrip = feed.getInterpolatedStopTimesForTrip(trip.trip_id);
                if (interpolatedStopTimesForTrip.isEmpty()) {
                    System.out.println("empty trip: " + trip.trip_id);
                    continue;
                }
                interpolatedStopTimesForTrip.forEach(stopTime -> {
                    while (orderedStopTimesForTripWithPadding.size() < stopTime.stop_sequence) {
                        orderedStopTimesForTripWithPadding.add(null);
                    }
                    key.addStopTime((StopTime)stopTime);
                    orderedStopTimesForTripWithPadding.add((StopTime)stopTime);
                });
                Pattern pattern = (Pattern)patterns.get(key);
                if (pattern == null) {
                    pattern = new Pattern(key.stops, new ArrayList<GTFSFeed.StopTimesForTripWithTripPatternKey>());
                    pattern.pattern_id = feed.feedId + " " + nextPatternId++;
                    patterns.put(key, pattern);
                }
                if ((frequencies = feed.getFrequencies(trip.trip_id)).isEmpty()) {
                    GTFSFeed.StopTimesForTripWithTripPatternKey tripPointer = new GTFSFeed.StopTimesForTripWithTripPatternKey(entry.getKey(), trip, service, route.route_type, orderedStopTimesForTripWithPadding, pattern);
                    pattern.trips.add(tripPointer);
                    continue;
                }
                for (Frequency frequency : frequencies) {
                    for (int time = frequency.start_time; time < frequency.end_time; time += frequency.headway_secs) {
                        ArrayList<StopTime> orderedStopTimesForUnrolledTripWithPadding = new ArrayList<StopTime>();
                        for (StopTime stopTime2 : orderedStopTimesForTripWithPadding) {
                            if (stopTime2 != null) {
                                StopTime stopTimeForUnrolledTrip = stopTime2.clone();
                                stopTimeForUnrolledTrip.arrival_time += time;
                                stopTimeForUnrolledTrip.departure_time += time;
                                orderedStopTimesForUnrolledTripWithPadding.add(stopTimeForUnrolledTrip);
                                continue;
                            }
                            orderedStopTimesForUnrolledTripWithPadding.add(null);
                        }
                        GTFSFeed.StopTimesForTripWithTripPatternKey tripPointer = new GTFSFeed.StopTimesForTripWithTripPatternKey(entry.getKey(), trip, service, route.route_type, orderedStopTimesForUnrolledTripWithPadding, pattern);
                        pattern.trips.add(tripPointer);
                    }
                }
            }
            for (Pattern pattern : patterns.values()) {
                pattern.trips.sort(Comparator.comparingInt(GTFSFeed.StopTimesForTripWithTripPatternKey::getDepartureTime));
                int endIdxOfPattern = this.idx + pattern.trips.size();
                for (GTFSFeed.StopTimesForTripWithTripPatternKey tripPointer : pattern.trips) {
                    ++this.idx;
                    tripPointer.idx = tripPointer.idx;
                    tripPointer.endIdxOfPattern = endIdxOfPattern;
                    if (tripPointer.idx == Integer.MAX_VALUE) {
                        throw new RuntimeException();
                    }
                    this.trips.add(tripPointer);
                }
            }
        }
        for (GTFSFeed.StopTimesForTripWithTripPatternKey tripPointer : this.trips) {
            for (int i = 0; i < tripPointer.stopTimes.size() - 1; ++i) {
                StopTime stopTime3 = tripPointer.stopTimes.get(i);
                if (stopTime3 == null) continue;
                Map patternBoardings = this.boardingsForStopByPattern.computeIfAbsent(new GtfsStorage.FeedIdWithStopId(tripPointer.feedId, stopTime3.stop_id), k -> new HashMap());
                List boardings = patternBoardings.computeIfAbsent(tripPointer.pattern.pattern_id, k -> new ArrayList());
                boardings.add(new TripAtStopTime(tripPointer.idx, i));
            }
        }
    }

    public Map<String, List<TripAtStopTime>> getPatternBoardings(GtfsStorage.FeedIdWithStopId stopId) {
        return this.boardingsForStopByPattern.computeIfAbsent(stopId, k -> new HashMap());
    }

    private Map<TripAtStopTime, Collection<TripAtStopTime>> findTripTransfers(GTFSFeed.StopTimesForTripWithTripPatternKey tripPointer, String feedKey, LocalDate trafficDay, Map<String, Transfers> transfers, ArrayListMultimap<Integer, GtfsStorage.FeedIdWithStopId> stopsForStationNode) {
        Transfers transfersForFeed = transfers.get(feedKey);
        HashMap<TripAtStopTime, Collection<TripAtStopTime>> result = new HashMap<TripAtStopTime, Collection<TripAtStopTime>>();
        List<StopTime> stopTimesExceptFirst = tripPointer.stopTimes.subList(1, tripPointer.stopTimes.size());
        ObjectIntHashMap<GtfsStorage.FeedIdWithStopId> arrivalTimes = new ObjectIntHashMap<GtfsStorage.FeedIdWithStopId>();
        for (StopTime stopTime : Lists.reverse(stopTimesExceptFirst)) {
            if (stopTime == null) continue;
            GtfsStorage.FeedIdWithStopId stopId = new GtfsStorage.FeedIdWithStopId(feedKey, stopTime.stop_id);
            arrivalTimes.put(stopId, Math.min(stopTime.arrival_time, arrivalTimes.getOrDefault(stopId, Integer.MAX_VALUE)));
            for (GtfsStorage.InterpolatedTransfer it : this.gtfsStorage.interpolatedTransfers.get((Object)stopId)) {
                GtfsStorage.FeedIdWithStopId boardingStop = it.toPlatformDescriptor;
                int arrivalTimePlusTransferTime = stopTime.arrival_time + it.streetTime;
                arrivalTimes.put(boardingStop, Math.min(arrivalTimePlusTransferTime, arrivalTimes.getOrDefault(boardingStop, Integer.MAX_VALUE)));
            }
        }
        for (StopTime stopTime : Lists.reverse(stopTimesExceptFirst)) {
            if (stopTime == null) continue;
            TripAtStopTime origin = new TripAtStopTime(tripPointer.idx, stopTime.stop_sequence);
            ArrayList<TripAtStopTime> destinations = new ArrayList<TripAtStopTime>();
            GtfsStorage.FeedIdWithStopId stopId = new GtfsStorage.FeedIdWithStopId(feedKey, stopTime.stop_id);
            List<Transfer> transfersFromStop = transfersForFeed.getTransfersFromStop(stopId.stopId, tripPointer.trip.route_id);
            ArrayListMultimap<String, Transfer> multimap = ArrayListMultimap.create();
            for (Transfer transfer : transfersFromStop) {
                multimap.put(transfer.to_stop_id, transfer);
            }
            if (!multimap.containsKey(stopTime.stop_id)) {
                this.insertTripTransfers(trafficDay, arrivalTimes, feedKey, stopTime, destinations, new GtfsStorage.FeedIdWithStopId(feedKey, stopTime.stop_id), 0, (List<Transfer>)multimap.get((Object)stopTime.stop_id));
            }
            for (String toStopId : multimap.keySet()) {
                this.insertTripTransfers(trafficDay, arrivalTimes, feedKey, stopTime, destinations, new GtfsStorage.FeedIdWithStopId(feedKey, toStopId), 0, (List<Transfer>)multimap.get((Object)toStopId));
            }
            for (GtfsStorage.FeedIdWithStopId otherStop : stopsForStationNode.get((Object)this.gtfsStorage.getStationNodes().get(stopId))) {
                if (stopId.equals(otherStop)) continue;
                this.insertTripTransfers(trafficDay, arrivalTimes, feedKey, stopTime, destinations, otherStop, 0, Collections.emptyList());
            }
            for (GtfsStorage.InterpolatedTransfer it : this.gtfsStorage.interpolatedTransfers.get((Object)stopId)) {
                this.insertTripTransfers(trafficDay, arrivalTimes, feedKey, stopTime, destinations, it.toPlatformDescriptor, it.streetTime, Collections.emptyList());
            }
            result.put(origin, destinations);
        }
        return result;
    }

    private void insertTripTransfers(LocalDate trafficDay, ObjectIntHashMap<GtfsStorage.FeedIdWithStopId> arrivalTimes, String feedKey, StopTime arrivalStopTime, List<TripAtStopTime> destinations, GtfsStorage.FeedIdWithStopId boardingStop, int streetTime, List<Transfer> transfers) {
        GTFSFeed sourceFeed = this.gtfsStorage.getGtfsFeeds().get(feedKey);
        GTFSFeed destinationFeed = this.gtfsStorage.getGtfsFeeds().get(boardingStop.feedId);
        ZoneId sourceZoneId = ZoneId.of(sourceFeed.agency.values().stream().findFirst().get().agency_timezone);
        ZoneId destinationZoneId = ZoneId.of(destinationFeed.agency.values().stream().findFirst().get().agency_timezone);
        LocalDateTime scheduleArrivalTime = trafficDay.atStartOfDay().plusSeconds(arrivalStopTime.arrival_time);
        int timeZoneOffset = (int)(scheduleArrivalTime.atZone(sourceZoneId).toEpochSecond() - scheduleArrivalTime.atZone(destinationZoneId).toEpochSecond());
        int earliestDepartureTime = arrivalStopTime.arrival_time + streetTime;
        Collection<List<TripAtStopTime>> boardingsForPattern = this.getPatternBoardings(boardingStop).values();
        block0: for (List<TripAtStopTime> boardings : boardingsForPattern) {
            for (TripAtStopTime candidate : boardings) {
                GTFSFeed.StopTimesForTripWithTripPatternKey trip = this.getTrip(candidate.tripIdx);
                int earliestDepatureTimeForThisDestination = earliestDepartureTime;
                for (Transfer transfer : transfers) {
                    if (!trip.trip.route_id.equals(transfer.to_route_id)) continue;
                    earliestDepatureTimeForThisDestination += transfer.min_transfer_time;
                }
                StopTime departureStopTime = trip.stopTimes.get(candidate.stop_sequence);
                if (!trip.service.activeOn(trafficDay) || departureStopTime.departure_time - timeZoneOffset < earliestDepatureTimeForThisDestination) continue;
                boolean keep = false;
                boolean overnight = false;
                for (int i = candidate.stop_sequence; i < trip.stopTimes.size(); ++i) {
                    StopTime destinationStopTime = trip.stopTimes.get(i);
                    if (destinationStopTime == null) continue;
                    int destinationArrivalTime = destinationStopTime.arrival_time - timeZoneOffset;
                    if (i == candidate.stop_sequence) {
                        if (destinationArrivalTime >= earliestDepartureTime) continue;
                        overnight = true;
                        continue;
                    }
                    if (overnight) {
                        destinationArrivalTime += 86400;
                    }
                    GtfsStorage.FeedIdWithStopId destinationStopId = new GtfsStorage.FeedIdWithStopId(trip.trip.feed_id, destinationStopTime.stop_id);
                    int oldArrivalTime = arrivalTimes.getOrDefault(destinationStopId, Integer.MAX_VALUE);
                    keep = keep || destinationArrivalTime < oldArrivalTime;
                    arrivalTimes.put(destinationStopId, Math.min(oldArrivalTime, destinationArrivalTime));
                }
                if (!keep) continue block0;
                destinations.add(candidate);
                continue block0;
            }
        }
    }

    public void findAllTripTransfersInto(Map<TripAtStopTime, Collection<TripAtStopTime>> result, LocalDate trafficDay, Map<String, Transfers> transfers, ArrayListMultimap<Integer, GtfsStorage.FeedIdWithStopId> stopsForStationNode) {
        Map<TripAtStopTime, Collection<TripAtStopTime>> r = Collections.synchronizedMap(result);
        ((Stream)this.trips.stream().filter(trip -> trip.service.activeOn(trafficDay)).parallel()).forEach(tripPointer -> {
            Map<TripAtStopTime, Collection<TripAtStopTime>> reducedTripTransfers = this.findTripTransfers((GTFSFeed.StopTimesForTripWithTripPatternKey)tripPointer, tripPointer.feedId, trafficDay, transfers, stopsForStationNode);
            r.putAll(reducedTripTransfers);
        });
    }

    public Map<LocalDate, Map<TripAtStopTime, Collection<TripAtStopTime>>> getTripTransfers() {
        return this.tripTransfersPerDay;
    }

    public Map<TripAtStopTime, Collection<TripAtStopTime>> getTripTransfers(LocalDate trafficDay) {
        return this.tripTransfersPerDay.computeIfAbsent(trafficDay, k -> new TreeMap());
    }

    public GTFSFeed.StopTimesForTripWithTripPatternKey getTrip(int tripIdx) {
        return this.trips.get(tripIdx);
    }

    public static class TripPatternKey {
        public List<String> stops = new ArrayList<String>();
        public IntArrayList pickupTypes = new IntArrayList();
        public IntArrayList dropoffTypes = new IntArrayList();

        public void addStopTime(StopTime st) {
            this.stops.add(st.stop_id);
            this.pickupTypes.add(st.pickup_type);
            this.dropoffTypes.add(st.drop_off_type);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TripPatternKey that = (TripPatternKey)o;
            if (!Objects.equals(this.dropoffTypes, that.dropoffTypes)) {
                return false;
            }
            if (!Objects.equals(this.pickupTypes, that.pickupTypes)) {
                return false;
            }
            return Objects.equals(this.stops, that.stops);
        }

        public int hashCode() {
            int result = this.stops != null ? this.stops.hashCode() : 0;
            result = 31 * result + (this.pickupTypes != null ? this.pickupTypes.hashCode() : 0);
            result = 31 * result + (this.dropoffTypes != null ? this.dropoffTypes.hashCode() : 0);
            return result;
        }
    }

    public static class Pattern
    extends Entity {
        public static final long serialVersionUID = 1L;
        public String pattern_id;
        public List<String> orderedStops;
        public List<GTFSFeed.StopTimesForTripWithTripPatternKey> trips;
        public String name;
        public String feed_id;

        public String getId() {
            return this.pattern_id;
        }

        public Pattern(List<String> orderedStops, List<GTFSFeed.StopTimesForTripWithTripPatternKey> trips) {
            this.orderedStops = orderedStops;
            this.trips = trips;
        }
    }

    public static class TripAtStopTime
    implements Serializable,
    Comparable<TripAtStopTime> {
        public static final Comparator<TripAtStopTime> TRIP_AT_STOP_TIME_COMPARATOR = Comparator.comparingInt(tst1 -> tst1.tripIdx).thenComparingInt(tst -> tst.stop_sequence);
        public int tripIdx;
        public int stop_sequence;

        public TripAtStopTime(int tripIdx, int stop_sequence) {
            this.tripIdx = tripIdx;
            this.stop_sequence = stop_sequence;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TripAtStopTime that = (TripAtStopTime)o;
            return this.tripIdx == that.tripIdx && this.stop_sequence == that.stop_sequence;
        }

        public String toString() {
            return "TripAtStopTime{tripIdx=" + this.tripIdx + ", stop_sequence=" + this.stop_sequence + "}";
        }

        @Override
        public int compareTo(TripAtStopTime o) {
            return TRIP_AT_STOP_TIME_COMPARATOR.compare(this, o);
        }

        public static String print(TripAtStopTime transferDestination, Trips tripTransfers, ArrivalDeparture arrivalDeparture) {
            GTFSFeed.StopTimesForTripWithTripPatternKey tripPointer = tripTransfers.trips.get(transferDestination.tripIdx);
            StopTime stopTime = tripPointer.stopTimes.get(transferDestination.stop_sequence);
            return tripPointer.idx + " " + tripPointer.trip.trip_id + " @ " + stopTime.stop_sequence + " " + stopTime.stop_id + " " + (arrivalDeparture == ArrivalDeparture.ARRIVAL ? stopTime.arrival_time : stopTime.departure_time);
        }

        public static enum ArrivalDeparture {
            ARRIVAL,
            DEPARTURE;

        }
    }
}

