/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.http;

import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.util.StdDateFormat;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.graphhopper.GraphHopper;
import com.graphhopper.GraphHopperConfig;
import com.graphhopper.gtfs.GraphHopperGtfs;
import com.graphhopper.gtfs.GtfsStorage;
import com.graphhopper.gtfs.PtRouter;
import com.graphhopper.gtfs.PtRouterFreeWalkImpl;
import com.graphhopper.gtfs.PtRouterImpl;
import com.graphhopper.gtfs.PtRouterTripBasedImpl;
import com.graphhopper.gtfs.RealtimeFeed;
import com.graphhopper.http.GHJerseyViolationExceptionMapper;
import com.graphhopper.http.GHRequestTransformer;
import com.graphhopper.http.GraphHopperBundleConfiguration;
import com.graphhopper.http.GraphHopperManaged;
import com.graphhopper.http.IllegalArgumentExceptionMapper;
import com.graphhopper.http.MultiExceptionGPXMessageBodyWriter;
import com.graphhopper.http.MultiExceptionMapper;
import com.graphhopper.http.ProfileResolver;
import com.graphhopper.http.PtRedirectFilter;
import com.graphhopper.http.RealtimeFeedLoadingCache;
import com.graphhopper.http.TypeGPXFilter;
import com.graphhopper.http.health.GraphHopperHealthCheck;
import com.graphhopper.isochrone.algorithm.JTSTriangulator;
import com.graphhopper.isochrone.algorithm.Triangulator;
import com.graphhopper.jackson.Jackson;
import com.graphhopper.matching.MapMatching;
import com.graphhopper.resources.HealthCheckResource;
import com.graphhopper.resources.I18NResource;
import com.graphhopper.resources.InfoResource;
import com.graphhopper.resources.IsochroneResource;
import com.graphhopper.resources.MVTResource;
import com.graphhopper.resources.MapMatchingResource;
import com.graphhopper.resources.NearestResource;
import com.graphhopper.resources.PtIsochroneResource;
import com.graphhopper.resources.PtMVTResource;
import com.graphhopper.resources.PtRouteResource;
import com.graphhopper.resources.RouteResource;
import com.graphhopper.resources.SPTResource;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.storage.index.LocationIndex;
import com.graphhopper.util.TranslationMap;
import com.graphhopper.util.details.PathDetailsBuilderFactory;
import io.dropwizard.client.HttpClientBuilder;
import io.dropwizard.core.ConfiguredBundle;
import io.dropwizard.core.setup.Bootstrap;
import io.dropwizard.core.setup.Environment;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.utilities.binding.AbstractBinder;

public class GraphHopperBundle
implements ConfiguredBundle<GraphHopperBundleConfiguration> {
    @Override
    public void initialize(Bootstrap<?> bootstrap) {
        bootstrap.setObjectMapper(io.dropwizard.jackson.Jackson.newMinimalObjectMapper());
        bootstrap.getObjectMapper().registerModule(new Jdk8Module());
        Jackson.initObjectMapper(bootstrap.getObjectMapper());
        bootstrap.getObjectMapper().setDateFormat(new StdDateFormat());
        bootstrap.getObjectMapper().setConfig((DeserializationConfig)bootstrap.getObjectMapper().getDeserializationConfig().with(new MapperFeature[]{MapperFeature.ALLOW_EXPLICIT_PROPERTY_RENAMING}));
    }

    @Override
    public void run(final GraphHopperBundleConfiguration configuration, Environment environment) {
        for (Object k : System.getProperties().keySet()) {
            if (!(k instanceof String) || !((String)k).startsWith("graphhopper.")) continue;
            throw new IllegalArgumentException("You need to prefix system parameters with '-Ddw.graphhopper.' instead of '-Dgraphhopper.' see #1879 and #1897");
        }
        environment.jersey().register(new GHJerseyViolationExceptionMapper());
        environment.jersey().register(new TypeGPXFilter());
        environment.jersey().register(new MultiExceptionMapper());
        environment.jersey().register(new MultiExceptionGPXMessageBodyWriter());
        environment.jersey().register(new IllegalArgumentExceptionMapper());
        GraphHopperManaged graphHopperManaged = new GraphHopperManaged(configuration.getGraphHopperConfiguration());
        environment.lifecycle().manage(graphHopperManaged);
        final GraphHopper graphHopper = graphHopperManaged.getGraphHopper();
        environment.jersey().register(new AbstractBinder(){

            @Override
            protected void configure() {
                this.bind(configuration.getGraphHopperConfiguration()).to(GraphHopperConfig.class);
                this.bind(graphHopper).to(GraphHopper.class);
                this.bind(new JTSTriangulator(graphHopper.getRouterConfig())).to(Triangulator.class);
                this.bindFactory(MapMatchingRouterFactoryFactory.class).to(MapMatchingResource.MapMatchingRouterFactory.class);
                this.bindFactory(PathDetailsBuilderFactoryFactory.class).to(PathDetailsBuilderFactory.class);
                this.bindFactory(ProfileResolverFactory.class).to(ProfileResolver.class);
                this.bindFactory(GHRequestTransformerFactory.class).to(GHRequestTransformer.class);
                this.bindFactory(HasElevation.class).to(Boolean.class).named("hasElevation");
                this.bindFactory(LocationIndexFactory.class).to(LocationIndex.class);
                this.bindFactory(TranslationMapFactory.class).to(TranslationMap.class);
                this.bindFactory(EncodingManagerFactory.class).to(EncodingManager.class);
                this.bindFactory(BaseGraphFactory.class).to(BaseGraph.class);
                this.bindFactory(GtfsStorageFactory.class).to(GtfsStorage.class);
            }
        });
        environment.jersey().register(MVTResource.class);
        environment.jersey().register(NearestResource.class);
        environment.jersey().register(RouteResource.class);
        environment.jersey().register(IsochroneResource.class);
        environment.jersey().register(MapMatchingResource.class);
        if (configuration.getGraphHopperConfiguration().has("gtfs.file")) {
            environment.jersey().register(new AbstractBinder(){

                @Override
                protected void configure() {
                    if (configuration.getGraphHopperConfiguration().getBool("gtfs.free_walk", false)) {
                        this.bind(PtRouterFreeWalkImpl.class).to(PtRouter.class);
                    } else if (configuration.getGraphHopperConfiguration().getBool("gtfs.trip_based", false)) {
                        this.bind(PtRouterTripBasedImpl.class).to(PtRouter.class);
                    } else {
                        this.bind(PtRouterImpl.class).to(PtRouter.class);
                    }
                    this.bind(PtRouterImpl.class).to(PtRouter.class).named("classic");
                    this.bind(PtRouterFreeWalkImpl.class).to(PtRouter.class).named("free_walk");
                    this.bind(PtRouterTripBasedImpl.class).to(PtRouter.class).named("trip_based");
                }
            });
            environment.jersey().register(PtRouteResource.class);
            environment.jersey().register(PtIsochroneResource.class);
            environment.jersey().register(PtMVTResource.class);
            environment.jersey().register(PtRedirectFilter.class);
        }
        environment.jersey().register(SPTResource.class);
        environment.jersey().register(I18NResource.class);
        environment.jersey().register(InfoResource.class);
        environment.healthChecks().register("graphhopper", new GraphHopperHealthCheck(graphHopper));
        environment.jersey().register(environment.healthChecks());
        environment.jersey().register(HealthCheckResource.class);
        if (configuration.gtfsrealtime().getFeeds().isEmpty()) {
            environment.jersey().register(new AbstractBinder(){

                @Override
                protected void configure() {
                    this.bindFactory(EmptyRealtimeFeedFactory.class).to(RealtimeFeed.class).in(Singleton.class);
                }
            });
        } else {
            final CloseableHttpClient httpClient = new HttpClientBuilder(environment).using(configuration.gtfsrealtime().getHttpClientConfiguration()).build("gtfs-realtime-feed-loader");
            final RealtimeFeedLoadingCache realtimeFeedLoadingCache = new RealtimeFeedLoadingCache((GraphHopperGtfs)graphHopper, httpClient, configuration);
            environment.lifecycle().manage(realtimeFeedLoadingCache);
            environment.jersey().register(new AbstractBinder(){

                @Override
                protected void configure() {
                    this.bind(httpClient).to(HttpClient.class);
                    this.bindFactory(realtimeFeedLoadingCache).to(RealtimeFeed.class);
                }
            });
        }
    }

    private static class EmptyRealtimeFeedFactory
    implements Factory<RealtimeFeed> {
        private final GtfsStorage staticGtfs;

        @Inject
        EmptyRealtimeFeedFactory(GtfsStorage staticGtfs) {
            this.staticGtfs = staticGtfs;
        }

        @Override
        public RealtimeFeed provide() {
            return RealtimeFeed.empty();
        }

        @Override
        public void dispose(RealtimeFeed realtimeFeed) {
        }
    }

    static class HasElevation
    implements Factory<Boolean> {
        @Inject
        GraphHopper graphHopper;

        HasElevation() {
        }

        @Override
        public Boolean provide() {
            return this.graphHopper.hasElevation();
        }

        @Override
        public void dispose(Boolean instance) {
        }
    }

    static class MapMatchingRouterFactoryFactory
    implements Factory<MapMatchingResource.MapMatchingRouterFactory> {
        @Inject
        GraphHopper graphHopper;

        MapMatchingRouterFactoryFactory() {
        }

        @Override
        public MapMatchingResource.MapMatchingRouterFactory provide() {
            return hints -> MapMatching.routerFromGraphHopper(this.graphHopper, hints);
        }

        @Override
        public void dispose(MapMatchingResource.MapMatchingRouterFactory mapMatchingRouterFactory) {
        }
    }

    static class PathDetailsBuilderFactoryFactory
    implements Factory<PathDetailsBuilderFactory> {
        @Inject
        GraphHopper graphHopper;

        PathDetailsBuilderFactoryFactory() {
        }

        @Override
        public PathDetailsBuilderFactory provide() {
            return this.graphHopper.getPathDetailsBuilderFactory();
        }

        @Override
        public void dispose(PathDetailsBuilderFactory profileResolver) {
        }
    }

    static class GHRequestTransformerFactory
    implements Factory<GHRequestTransformer> {
        GHRequestTransformerFactory() {
        }

        @Override
        public GHRequestTransformer provide() {
            return req -> req;
        }

        @Override
        public void dispose(GHRequestTransformer instance) {
        }
    }

    static class ProfileResolverFactory
    implements Factory<ProfileResolver> {
        @Inject
        GraphHopper graphHopper;

        ProfileResolverFactory() {
        }

        @Override
        public ProfileResolver provide() {
            return new ProfileResolver(this.graphHopper.getProfiles());
        }

        @Override
        public void dispose(ProfileResolver instance) {
        }
    }

    static class LocationIndexFactory
    implements Factory<LocationIndex> {
        @Inject
        GraphHopper graphHopper;

        LocationIndexFactory() {
        }

        @Override
        public LocationIndex provide() {
            return this.graphHopper.getLocationIndex();
        }

        @Override
        public void dispose(LocationIndex instance) {
        }
    }

    static class EncodingManagerFactory
    implements Factory<EncodingManager> {
        @Inject
        GraphHopper graphHopper;

        EncodingManagerFactory() {
        }

        @Override
        public EncodingManager provide() {
            return this.graphHopper.getEncodingManager();
        }

        @Override
        public void dispose(EncodingManager instance) {
        }
    }

    static class GtfsStorageFactory
    implements Factory<GtfsStorage> {
        @Inject
        GraphHopperGtfs graphHopper;

        GtfsStorageFactory() {
        }

        @Override
        public GtfsStorage provide() {
            return this.graphHopper.getGtfsStorage();
        }

        @Override
        public void dispose(GtfsStorage instance) {
        }
    }

    static class BaseGraphFactory
    implements Factory<BaseGraph> {
        @Inject
        GraphHopper graphHopper;

        BaseGraphFactory() {
        }

        @Override
        public BaseGraph provide() {
            return this.graphHopper.getBaseGraph();
        }

        @Override
        public void dispose(BaseGraph instance) {
        }
    }

    static class TranslationMapFactory
    implements Factory<TranslationMap> {
        @Inject
        GraphHopper graphHopper;

        TranslationMapFactory() {
        }

        @Override
        public TranslationMap provide() {
            return this.graphHopper.getTranslationMap();
        }

        @Override
        public void dispose(TranslationMap instance) {
        }
    }
}

