/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.http;

import com.graphhopper.config.Profile;
import com.graphhopper.util.PMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ProfileResolver {
    protected final Map<String, Profile> profilesByName;

    public ProfileResolver(List<Profile> profiles) {
        this.profilesByName = new LinkedHashMap<String, Profile>(profiles.size());
        profiles.forEach(p -> {
            if (this.profilesByName.put(p.getName(), (Profile)p) != null) {
                throw new IllegalArgumentException("Profiles must have distinct names");
            }
        });
    }

    public String resolveProfile(PMap hints) {
        String profileName = hints.getString("profile", "");
        if (profileName.isEmpty()) {
            throw new IllegalArgumentException("profile parameter required");
        }
        ProfileResolver.errorIfLegacyParameters(hints);
        String profile = this.doResolveProfile(profileName, hints);
        if (profile == null) {
            throw new IllegalArgumentException("The requested profile '" + profileName + "' does not exist.\nAvailable profiles: " + String.valueOf(this.profilesByName.keySet()));
        }
        return profile;
    }

    protected String doResolveProfile(String profileName, PMap hints) {
        Profile profile = this.profilesByName.get(profileName);
        return profile == null ? null : profile.getName();
    }

    public static void errorIfLegacyParameters(PMap hints) {
        if (hints.has("weighting")) {
            throw new IllegalArgumentException("The 'weighting' parameter is no longer supported. You used 'weighting=" + hints.getString("weighting", "") + "'");
        }
        if (hints.has("vehicle")) {
            throw new IllegalArgumentException("The 'vehicle' parameter is no longer supported. You used 'vehicle=" + hints.getString("vehicle", "") + "'");
        }
        if (hints.has("edge_based")) {
            throw new IllegalArgumentException("The 'edge_based' parameter is no longer supported. You used 'edge_based=" + hints.getBool("edge_based", false) + "'");
        }
        if (hints.has("turn_costs")) {
            throw new IllegalArgumentException("The 'turn_costs' parameter is no longer supported. You used 'turn_costs=" + hints.getBool("turn_costs", false) + "'");
        }
    }
}

