/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.graphhopper.jackson.MultiException;
import com.graphhopper.util.exceptions.GHException;
import java.io.IOException;
import java.util.List;

public class MultiExceptionSerializer
extends JsonSerializer<MultiException> {
    @Override
    public void serialize(MultiException e, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        List<Throwable> errors = e.getErrors();
        ObjectNode json = JsonNodeFactory.instance.objectNode();
        json.put("message", MultiExceptionSerializer.getMessage(errors.get(0)));
        ArrayNode errorHintList = json.putArray("hints");
        for (Throwable t2 : errors) {
            ObjectNode error = errorHintList.addObject();
            error.put("message", MultiExceptionSerializer.getMessage(t2));
            error.put("details", t2.getClass().getName());
            if (!(t2 instanceof GHException)) continue;
            ((GHException)((Object)t2)).getDetails().forEach(error::putPOJO);
        }
        jsonGenerator.writeObject(json);
    }

    private static String getMessage(Throwable t2) {
        if (t2.getMessage() == null) {
            return t2.getClass().getSimpleName();
        }
        return t2.getMessage();
    }
}

