/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.graphhopper.json.Statement;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;

class StatementDeserializer
extends JsonDeserializer<Statement> {
    StatementDeserializer() {
    }

    @Override
    public Statement deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        return StatementDeserializer.deserializeStatement((JsonNode)p.readValueAsTree());
    }

    static Statement deserializeStatement(JsonNode treeNode) {
        if (treeNode.has(Statement.Op.DO.getName())) {
            if (treeNode.size() != 2) {
                throw new IllegalArgumentException("This block statement expects two entries but was " + treeNode.size() + " for " + String.valueOf(treeNode));
            }
            JsonNode doNode = treeNode.get(Statement.Op.DO.getName());
            if (!doNode.isArray()) {
                throw new IllegalArgumentException("'do' block must be an array");
            }
            ArrayList<Statement> list = new ArrayList<Statement>();
            for (JsonNode thenSt : doNode) {
                list.add(StatementDeserializer.deserializeStatement(thenSt));
            }
            if (treeNode.has(Statement.Keyword.IF.getName())) {
                return Statement.If(treeNode.get(Statement.Keyword.IF.getName()).asText(), list);
            }
            if (treeNode.has(Statement.Keyword.ELSEIF.getName())) {
                return Statement.ElseIf(treeNode.get(Statement.Keyword.ELSEIF.getName()).asText(), list);
            }
            if (treeNode.has(Statement.Keyword.ELSE.getName())) {
                JsonNode elseNode = treeNode.get(Statement.Keyword.ELSE.getName());
                if (elseNode.isNull() || elseNode.isValueNode() && elseNode.asText().isEmpty()) {
                    return Statement.Else(list);
                }
                throw new IllegalArgumentException("else cannot have expression but was " + String.valueOf(treeNode.get(Statement.Keyword.ELSE.getName())));
            }
            throw new IllegalArgumentException("invalid then block: " + treeNode.toPrettyString());
        }
        if (treeNode.size() != 2) {
            throw new IllegalArgumentException("This statement expects two entries but was " + treeNode.size() + " for " + String.valueOf(treeNode));
        }
        Statement.Op jsonOp = null;
        String value = null;
        for (Statement.Op op : Statement.Op.values()) {
            if (!treeNode.has(op.getName())) continue;
            if (jsonOp != null) {
                throw new IllegalArgumentException("Multiple operations are not allowed. Statement: " + String.valueOf(treeNode));
            }
            jsonOp = op;
            value = treeNode.get(op.getName()).asText();
        }
        if (jsonOp == null) {
            throw new IllegalArgumentException("Cannot find an operation in " + String.valueOf(treeNode) + ". Must be one of: " + Arrays.stream(Statement.Op.values()).map(Statement.Op::getName).collect(Collectors.joining(",")));
        }
        if (value == null) {
            throw new IllegalArgumentException("Cannot find a value in " + String.valueOf(treeNode));
        }
        if (treeNode.has(Statement.Keyword.IF.getName())) {
            return Statement.If(treeNode.get(Statement.Keyword.IF.getName()).asText(), jsonOp, value);
        }
        if (treeNode.has(Statement.Keyword.ELSEIF.getName())) {
            return Statement.ElseIf(treeNode.get(Statement.Keyword.ELSEIF.getName()).asText(), jsonOp, value);
        }
        if (treeNode.has(Statement.Keyword.ELSE.getName())) {
            JsonNode elseNode = treeNode.get(Statement.Keyword.ELSE.getName());
            if (elseNode.isNull() || elseNode.isValueNode() && elseNode.asText().isEmpty()) {
                return Statement.Else(jsonOp, value);
            }
            throw new IllegalArgumentException("else cannot have expression but was " + String.valueOf(treeNode.get(Statement.Keyword.ELSE.getName())));
        }
        throw new IllegalArgumentException("Cannot find if, else_if or else for " + String.valueOf(treeNode));
    }
}

