/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.graphhopper.json.Statement;
import java.io.IOException;

class StatementSerializer
extends JsonSerializer<Statement> {
    StatementSerializer() {
    }

    @Override
    public void serialize(Statement statement, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeStartObject();
        jsonGenerator.writeStringField(statement.keyword().getName(), statement.condition());
        if (statement.isBlock()) {
            jsonGenerator.writeArrayFieldStart("do");
            for (Statement s2 : statement.doBlock()) {
                this.serialize(s2, jsonGenerator, serializerProvider);
            }
            jsonGenerator.writeEndArray();
        } else {
            jsonGenerator.writeStringField(statement.operation().getName(), statement.value());
        }
        jsonGenerator.writeEndObject();
    }
}

