/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.json;

import com.graphhopper.json.MinMax;
import com.graphhopper.util.Helper;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public record Statement(Keyword keyword, String condition, Op operation, String value, List<Statement> doBlock) {
    private final String value;
    private final List<Statement> doBlock;

    public Statement {
        if (condition == null) {
            throw new IllegalArgumentException("'condition' cannot be null");
        }
        if (doBlock != null && operation != Op.DO) {
            throw new IllegalArgumentException("For 'doBlock' you have to use Op.DO");
        }
        if (doBlock != null && value != null) {
            throw new IllegalArgumentException("'doBlock' or 'value' cannot be both non-null");
        }
        if (doBlock == null && Helper.isEmpty(value)) {
            throw new IllegalArgumentException("a leaf statement must have a non-empty 'value'");
        }
        if (condition.isEmpty() && keyword != Keyword.ELSE) {
            throw new IllegalArgumentException("All statements (except 'else') have to use a non-empty 'condition'");
        }
        if (!condition.isEmpty() && keyword == Keyword.ELSE) {
            throw new IllegalArgumentException("For the 'else' statement you have to use an empty 'condition'");
        }
    }

    public boolean isBlock() {
        return this.doBlock != null;
    }

    public String value() {
        if (this.isBlock()) {
            throw new UnsupportedOperationException("'value' is not supported for block statement.");
        }
        return this.value;
    }

    public List<Statement> doBlock() {
        if (!this.isBlock()) {
            throw new UnsupportedOperationException("'doBlock' is not supported for leaf statement.");
        }
        return this.doBlock;
    }

    public String toPrettyString() {
        if (this.isBlock()) {
            return "{\"" + this.keyword.getName() + "\": \"" + this.condition + "\",\n  \"do\": [\n" + this.doBlock.stream().map(Objects::toString).collect(Collectors.joining(",\n  ")) + "  ]\n}";
        }
        return this.toString();
    }

    @Override
    public String toString() {
        if (this.isBlock()) {
            return "{\"" + this.keyword.getName() + "\": \"" + this.condition + "\", \"do\": " + String.valueOf(this.doBlock) + " }";
        }
        return "{\"" + this.keyword.getName() + "\": \"" + this.condition + "\", \"" + this.operation.getName() + "\": \"" + this.value + "\"}";
    }

    public static Statement If(String expression, List<Statement> doBlock) {
        return new Statement(Keyword.IF, expression, Op.DO, null, doBlock);
    }

    public static Statement If(String expression, Op op, String value) {
        return new Statement(Keyword.IF, expression, op, value, null);
    }

    public static Statement ElseIf(String expression, List<Statement> doBlock) {
        return new Statement(Keyword.ELSEIF, expression, Op.DO, null, doBlock);
    }

    public static Statement ElseIf(String expression, Op op, String value) {
        return new Statement(Keyword.ELSEIF, expression, op, value, null);
    }

    public static Statement Else(List<Statement> doBlock) {
        return new Statement(Keyword.ELSE, "", Op.DO, null, doBlock);
    }

    public static Statement Else(Op op, String value) {
        return new Statement(Keyword.ELSE, "", op, value, null);
    }

    public static enum Op {
        MULTIPLY("multiply_by"),
        LIMIT("limit_to"),
        DO("do"),
        ADD("add");

        private final String name;

        private Op(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String build(String value) {
            switch (this.ordinal()) {
                case 0: {
                    return "value *= " + value;
                }
                case 1: {
                    return "value = Math.min(value," + value + ")";
                }
                case 3: {
                    return "value += " + (value.equals("Infinity") ? "Double.POSITIVE_INFINITY" : value);
                }
            }
            throw new IllegalArgumentException();
        }

        public MinMax apply(MinMax minMax1, MinMax minMax2) {
            switch (this.ordinal()) {
                case 0: {
                    return new MinMax(minMax1.min * minMax2.min, minMax1.max * minMax2.max);
                }
                case 1: {
                    return new MinMax(Math.min(minMax1.min, minMax2.min), Math.min(minMax1.max, minMax2.max));
                }
                case 3: {
                    return new MinMax(minMax1.min + minMax2.min, minMax1.max + minMax2.max);
                }
            }
            throw new IllegalArgumentException();
        }
    }

    public static enum Keyword {
        IF("if"),
        ELSEIF("else_if"),
        ELSE("else");

        private final String name;

        private Keyword(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

