/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.matching;

import com.carrotsearch.hppc.IntHashSet;
import com.graphhopper.GraphHopper;
import com.graphhopper.config.Profile;
import com.graphhopper.matching.EdgeMatch;
import com.graphhopper.matching.HmmProbabilities;
import com.graphhopper.matching.MatchResult;
import com.graphhopper.matching.Observation;
import com.graphhopper.matching.ObservationWithCandidateStates;
import com.graphhopper.matching.SequenceState;
import com.graphhopper.matching.State;
import com.graphhopper.matching.Transition;
import com.graphhopper.routing.AStarBidirection;
import com.graphhopper.routing.DijkstraBidirectionRef;
import com.graphhopper.routing.Path;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.Subnetwork;
import com.graphhopper.routing.lm.LMApproximator;
import com.graphhopper.routing.lm.LandmarkStorage;
import com.graphhopper.routing.querygraph.QueryGraph;
import com.graphhopper.routing.querygraph.VirtualEdgeIteratorState;
import com.graphhopper.routing.util.DefaultSnapFilter;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.routing.util.TraversalMode;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.index.LocationIndexTree;
import com.graphhopper.storage.index.Snap;
import com.graphhopper.util.DistanceCalc;
import com.graphhopper.util.DistanceCalcEarth;
import com.graphhopper.util.DistancePlaneProjection;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.GHUtility;
import com.graphhopper.util.PMap;
import com.graphhopper.util.shapes.BBox;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.locationtech.jts.geom.Envelope;

public class MapMatching {
    private final BaseGraph graph;
    private final Router router;
    private final LocationIndexTree locationIndex;
    private double measurementErrorSigma = 10.0;
    private double transitionProbabilityBeta = 2.0;
    private final DistanceCalc distanceCalc = new DistancePlaneProjection();
    private QueryGraph queryGraph;
    private int processedUpTo = 0;
    private int offset = 0;
    private List<Integer> filteredIndexMapping = new ArrayList<Integer>();
    private int pointCount = -1;
    private Map<String, Object> statistics = new HashMap<String, Object>();

    public static MapMatching fromGraphHopper(GraphHopper graphHopper, PMap hints) {
        Router router = MapMatching.routerFromGraphHopper(graphHopper, hints);
        return new MapMatching(graphHopper.getBaseGraph(), (LocationIndexTree)graphHopper.getLocationIndex(), router);
    }

    public static Router routerFromGraphHopper(GraphHopper graphHopper, PMap hints) {
        if (hints.has("vehicle")) {
            throw new IllegalArgumentException("MapMatching hints may no longer contain a vehicle, use the profile parameter instead, see core/#1958");
        }
        if (hints.has("weighting")) {
            throw new IllegalArgumentException("MapMatching hints may no longer contain a weighting, use the profile parameter instead, see core/#1958");
        }
        if (graphHopper.getProfiles().isEmpty()) {
            throw new IllegalArgumentException("No profiles found, you need to configure at least one profile to use map matching");
        }
        if (!hints.has("profile")) {
            throw new IllegalArgumentException("You need to specify a profile to perform map matching");
        }
        String profileStr = hints.getString("profile", "");
        Profile profile = graphHopper.getProfile(profileStr);
        if (profile == null) {
            List<Profile> profiles = graphHopper.getProfiles();
            ArrayList<String> profileNames = new ArrayList<String>(profiles.size());
            for (Profile p : profiles) {
                profileNames.add(p.getName());
            }
            throw new IllegalArgumentException("Could not find profile '" + profileStr + "', choose one of: " + String.valueOf(profileNames));
        }
        boolean disableLM = hints.getBool("lm.disable", false);
        boolean disableCH = hints.getBool("ch.disable", false);
        boolean useDijkstra = disableLM || disableCH;
        final LandmarkStorage landmarks = !useDijkstra && graphHopper.getLandmarks().get(profile.getName()) != null ? graphHopper.getLandmarks().get(profile.getName()) : null;
        final Weighting weighting = graphHopper.createWeighting(profile, hints);
        BooleanEncodedValue inSubnetworkEnc = graphHopper.getEncodingManager().getBooleanEncodedValue(Subnetwork.key(profileStr));
        final DefaultSnapFilter snapFilter = new DefaultSnapFilter(weighting, inSubnetworkEnc);
        final int maxVisitedNodes = hints.getInt("max_visited_nodes", Integer.MAX_VALUE);
        Router router = new Router(){

            @Override
            public EdgeFilter getSnapFilter() {
                return snapFilter;
            }

            @Override
            public List<Path> calcPaths(QueryGraph queryGraph, int fromNode, int fromOutEdge, int[] toNodes, int[] toInEdges) {
                assert (toNodes.length == toInEdges.length);
                ArrayList<Path> result = new ArrayList<Path>();
                for (int i = 0; i < toNodes.length; ++i) {
                    result.add(this.calcOnePath(queryGraph, fromNode, toNodes[i], fromOutEdge, toInEdges[i]));
                }
                return result;
            }

            private Path calcOnePath(QueryGraph queryGraph, int fromNode, int toNode, int fromOutEdge, int toInEdge) {
                Weighting queryGraphWeighting = queryGraph.wrapWeighting(weighting);
                if (landmarks != null) {
                    AStarBidirection aStarBidirection = new AStarBidirection(queryGraph, queryGraphWeighting, TraversalMode.EDGE_BASED){

                        @Override
                        protected void initCollections(int size) {
                            super.initCollections(50);
                        }
                    };
                    int activeLM = Math.min(8, landmarks.getLandmarkCount());
                    LMApproximator lmApproximator = LMApproximator.forLandmarks(queryGraph, queryGraphWeighting, landmarks, activeLM);
                    aStarBidirection.setApproximation(lmApproximator);
                    aStarBidirection.setMaxVisitedNodes(maxVisitedNodes);
                    return aStarBidirection.calcPath(fromNode, toNode, fromOutEdge, toInEdge);
                }
                DijkstraBidirectionRef dijkstraBidirectionRef = new DijkstraBidirectionRef(queryGraph, queryGraphWeighting, TraversalMode.EDGE_BASED){

                    @Override
                    protected void initCollections(int size) {
                        super.initCollections(50);
                    }
                };
                dijkstraBidirectionRef.setMaxVisitedNodes(maxVisitedNodes);
                return dijkstraBidirectionRef.calcPath(fromNode, toNode, fromOutEdge, toInEdge);
            }

            @Override
            public Weighting getWeighting() {
                return weighting;
            }
        };
        return router;
    }

    public MapMatching(BaseGraph graph, LocationIndexTree locationIndex, Router router) {
        this.graph = graph;
        this.locationIndex = locationIndex;
        this.router = router;
    }

    public boolean matchingAttempted() {
        return this.processedUpTo > 0;
    }

    public int getProcessedPointsCount() {
        return this.processedUpTo + 1;
    }

    public boolean hasPointsToBeMatched() {
        return this.processedUpTo < this.pointCount - 1;
    }

    public void setTransitionProbabilityBeta(double transitionProbabilityBeta) {
        this.transitionProbabilityBeta = transitionProbabilityBeta;
    }

    public void setMeasurementErrorSigma(double measurementErrorSigma) {
        this.measurementErrorSigma = measurementErrorSigma;
    }

    private void resetCounters(int observationCount, int offset) {
        this.offset = offset;
        this.pointCount = observationCount;
        this.processedUpTo = offset;
        this.filteredIndexMapping.clear();
    }

    public MatchResult match(List<Observation> observations) {
        return this.match(observations, false, 0);
    }

    public MatchResult match(List<Observation> observations, boolean ignoreErrors, int offset) {
        this.offset = offset;
        this.resetCounters(observations.size(), offset);
        List<Observation> observationSubList = observations.subList(offset, observations.size());
        List<Observation> filteredObservations = this.filterObservations(observationSubList);
        this.statistics.put("filteredObservations", filteredObservations.size());
        List<List<Snap>> snapsPerObservation = filteredObservations.stream().map(o -> this.findCandidateSnaps(o.getPoint().lat, o.getPoint().lon)).collect(Collectors.toList());
        this.statistics.put("snapsPerObservation", snapsPerObservation.stream().mapToInt(Collection::size).toArray());
        this.queryGraph = QueryGraph.create(this.graph, snapsPerObservation.stream().flatMap(Collection::stream).collect(Collectors.toList()));
        List<ObservationWithCandidateStates> timeSteps = this.createTimeSteps(filteredObservations, snapsPerObservation);
        List<SequenceState<State, Observation, Path>> seq = this.computeViterbiSequence(timeSteps, ignoreErrors);
        this.statistics.put("transitionDistances", seq.stream().filter(s2 -> s2.transitionDescriptor != null).mapToLong(s2 -> Math.round(((Path)s2.transitionDescriptor).getDistance())).toArray());
        this.statistics.put("visitedNodes", this.router.getVisitedNodes());
        this.statistics.put("snapDistanceRanks", IntStream.range(0, seq.size()).map(i -> ((List)snapsPerObservation.get(i)).indexOf(((State)((SequenceState)seq.get((int)i)).state).getSnap())).toArray());
        this.statistics.put("snapDistances", seq.stream().mapToDouble(s2 -> ((State)s2.state).getSnap().getQueryDistance()).toArray());
        this.statistics.put("maxSnapDistances", IntStream.range(0, seq.size()).mapToDouble(i -> ((List)snapsPerObservation.get(i)).stream().mapToDouble(Snap::getQueryDistance).max().orElse(-1.0)).toArray());
        List<EdgeIteratorState> path = seq.stream().filter(s1 -> s1.transitionDescriptor != null).flatMap(s1 -> ((Path)s1.transitionDescriptor).calcEdges().stream()).collect(Collectors.toList());
        MatchResult result = new MatchResult(this.prepareEdgeMatches(seq));
        Weighting queryGraphWeighting = this.queryGraph.wrapWeighting(this.router.getWeighting());
        result.setMergedPath(new MapMatchedPath(this.queryGraph, queryGraphWeighting, path));
        result.setMatchMillis(seq.stream().filter(s2 -> s2.transitionDescriptor != null).mapToLong(s2 -> ((Path)s2.transitionDescriptor).getTime()).sum());
        result.setMatchLength(seq.stream().filter(s2 -> s2.transitionDescriptor != null).mapToDouble(s2 -> ((Path)s2.transitionDescriptor).getDistance()).sum());
        result.setGPXEntriesLength(this.gpxLength(observations));
        result.setGraph(this.queryGraph);
        result.setWeighting(queryGraphWeighting);
        return result;
    }

    public List<Observation> filterObservations(List<Observation> observations) {
        ArrayList<Observation> filtered = new ArrayList<Observation>();
        Observation prevEntry = null;
        double acc = 0.0;
        int last = observations.size() - 1;
        for (int i = 0; i <= last; ++i) {
            Observation prevObservation;
            Observation observation = observations.get(i);
            if (i == 0 || i == last || this.distanceCalc.calcDist(prevEntry.getPoint().getLat(), prevEntry.getPoint().getLon(), observation.getPoint().getLat(), observation.getPoint().getLon()) > 2.0 * this.measurementErrorSigma) {
                if (i > 0) {
                    prevObservation = observations.get(i - 1);
                    acc += this.distanceCalc.calcDist(prevObservation.getPoint().getLat(), prevObservation.getPoint().getLon(), observation.getPoint().getLat(), observation.getPoint().getLon());
                    acc -= this.distanceCalc.calcDist(prevEntry.getPoint().getLat(), prevEntry.getPoint().getLon(), observation.getPoint().getLat(), observation.getPoint().getLon());
                }
                observation.setAccumulatedLinearDistanceToPrevious(acc);
                filtered.add(observation);
                prevEntry = observation;
                acc = 0.0;
                this.filteredIndexMapping.add(i);
                continue;
            }
            prevObservation = observations.get(i - 1);
            acc += this.distanceCalc.calcDist(prevObservation.getPoint().getLat(), prevObservation.getPoint().getLon(), observation.getPoint().getLat(), observation.getPoint().getLon());
        }
        return filtered;
    }

    public List<Snap> findCandidateSnaps(double queryLat, double queryLon) {
        double rLon = this.measurementErrorSigma * 360.0 / DistanceCalcEarth.DIST_EARTH.calcCircumference(queryLat);
        double rLat = this.measurementErrorSigma / 111194.92664455873;
        Envelope envelope = new Envelope(queryLon, queryLon, queryLat, queryLat);
        for (int i = 0; i < 50; ++i) {
            envelope.expandBy(rLon, rLat);
            List<Snap> snaps = this.findCandidateSnapsInBBox(queryLat, queryLon, BBox.fromEnvelope(envelope));
            if (snaps.isEmpty()) continue;
            return snaps;
        }
        return Collections.emptyList();
    }

    private List<Snap> findCandidateSnapsInBBox(double queryLat, double queryLon, BBox queryShape) {
        EdgeFilter edgeFilter = this.router.getSnapFilter();
        ArrayList<Snap> snaps = new ArrayList<Snap>();
        IntHashSet seenEdges = new IntHashSet();
        IntHashSet seenNodes = new IntHashSet();
        this.locationIndex.query(queryShape, edgeId -> {
            EdgeIteratorState edge = this.graph.getEdgeIteratorStateForKey(edgeId * 2);
            if (seenEdges.add(edgeId) && edgeFilter.accept(edge)) {
                Snap snap = new Snap(queryLat, queryLon);
                this.locationIndex.traverseEdge(queryLat, queryLon, edge, (node, normedDist, wayIndex, pos) -> {
                    if (normedDist < snap.getQueryDistance()) {
                        snap.setQueryDistance(normedDist);
                        snap.setClosestNode(node);
                        snap.setWayIndex(wayIndex);
                        snap.setSnappedPosition(pos);
                    }
                });
                double dist = DistancePlaneProjection.DIST_PLANE.calcDenormalizedDist(snap.getQueryDistance());
                snap.setClosestEdge(edge);
                snap.setQueryDistance(dist);
                if (snap.isValid() && (snap.getSnappedPosition() != Snap.Position.TOWER || seenNodes.add(snap.getClosestNode()))) {
                    snap.calcSnappedPoint(DistanceCalcEarth.DIST_EARTH);
                    if (queryShape.contains(snap.getSnappedPoint().lat, snap.getSnappedPoint().lon)) {
                        snaps.add(snap);
                    }
                }
            }
        });
        snaps.sort(Comparator.comparingDouble(Snap::getQueryDistance));
        return snaps;
    }

    private List<ObservationWithCandidateStates> createTimeSteps(List<Observation> filteredObservations, List<List<Snap>> splitsPerObservation) {
        if (splitsPerObservation.size() != filteredObservations.size()) {
            throw new IllegalArgumentException("filteredGPXEntries and queriesPerEntry must have same size.");
        }
        ArrayList<ObservationWithCandidateStates> timeSteps = new ArrayList<ObservationWithCandidateStates>();
        for (int i = 0; i < filteredObservations.size(); ++i) {
            Observation observation = filteredObservations.get(i);
            Collection splits = splitsPerObservation.get(i);
            ArrayList<State> candidates = new ArrayList<State>();
            for (Snap split : splits) {
                if (this.queryGraph.isVirtualNode(split.getClosestNode())) {
                    ArrayList<VirtualEdgeIteratorState> virtualEdges = new ArrayList<VirtualEdgeIteratorState>();
                    EdgeIterator iter = this.queryGraph.createEdgeExplorer().setBaseNode(split.getClosestNode());
                    while (iter.next()) {
                        if (!this.queryGraph.isVirtualEdge(iter.getEdge())) {
                            throw new RuntimeException("Virtual nodes must only have virtual edges to adjacent nodes.");
                        }
                        virtualEdges.add((VirtualEdgeIteratorState)this.queryGraph.getEdgeIteratorState(iter.getEdge(), iter.getAdjNode()));
                    }
                    if (virtualEdges.size() != 2) {
                        throw new RuntimeException("Each virtual node must have exactly 2 virtual edges (reverse virtual edges are not returned by the EdgeIterator");
                    }
                    candidates.add(new State(observation, split, (VirtualEdgeIteratorState)virtualEdges.get(0), (VirtualEdgeIteratorState)virtualEdges.get(1)));
                    candidates.add(new State(observation, split, (VirtualEdgeIteratorState)virtualEdges.get(1), (VirtualEdgeIteratorState)virtualEdges.get(0)));
                    continue;
                }
                candidates.add(new State(observation, split));
            }
            timeSteps.add(new ObservationWithCandidateStates(observation, candidates));
        }
        return timeSteps;
    }

    private List<SequenceState<State, Observation, Path>> computeViterbiSequence(List<ObservationWithCandidateStates> timeSteps, boolean ignoreErrors) {
        if (timeSteps.isEmpty()) {
            return Collections.emptyList();
        }
        HmmProbabilities probabilities = new HmmProbabilities(this.measurementErrorSigma, this.transitionProbabilityBeta);
        HashMap<State, Label> labels = new HashMap<State, Label>();
        HashMap<Transition<State>, Path> roadPaths = new HashMap<Transition<State>, Path>();
        PriorityQueue<Label> q = new PriorityQueue<Label>(Comparator.comparing(qe -> qe.minusLogProbability));
        for (State candidate : timeSteps.get((int)0).candidates) {
            double distance = candidate.getSnap().getQueryDistance();
            Label label = new Label();
            label.state = candidate;
            label.minusLogProbability = probabilities.emissionLogProbability(distance) * -1.0;
            q.add(label);
            labels.put(candidate, label);
        }
        Label qe2 = null;
        int lastTimeStepCount = 0;
        while (!q.isEmpty()) {
            qe2 = q.poll();
            if (qe2.isDeleted) continue;
            if (qe2.timeStep > lastTimeStepCount) {
                this.processedUpTo = this.offset + this.filteredIndexMapping.get(qe2.timeStep);
                lastTimeStepCount = qe2.timeStep;
            }
            if (qe2.timeStep == timeSteps.size() - 1) break;
            State from = qe2.state;
            ObservationWithCandidateStates timeStep = timeSteps.get(qe2.timeStep);
            ObservationWithCandidateStates nextTimeStep = timeSteps.get(qe2.timeStep + 1);
            double linearDistance = this.distanceCalc.calcDist(timeStep.observation.getPoint().lat, timeStep.observation.getPoint().lon, nextTimeStep.observation.getPoint().lat, nextTimeStep.observation.getPoint().lon) + nextTimeStep.observation.getAccumulatedLinearDistanceToPrevious();
            int fromNode = from.getSnap().getClosestNode();
            int fromOutEdge = from.isOnDirectedEdge() ? from.getOutgoingVirtualEdge().getEdge() : -2;
            int[] toNodes = nextTimeStep.candidates.stream().mapToInt(c -> c.getSnap().getClosestNode()).toArray();
            int[] toInEdges = nextTimeStep.candidates.stream().mapToInt(to -> to.isOnDirectedEdge() ? to.getIncomingVirtualEdge().getEdge() : -2).toArray();
            List<Path> paths = this.router.calcPaths(this.queryGraph, fromNode, fromOutEdge, toNodes, toInEdges);
            for (int i = 0; i < nextTimeStep.candidates.size(); ++i) {
                State to2 = nextTimeStep.candidates.get(i);
                Path path = paths.get(i);
                if (!path.isFound()) continue;
                double transitionLogProbability = probabilities.transitionLogProbability(path.getDistance(), linearDistance);
                Transition<State> transition = new Transition<State>(from, to2);
                roadPaths.put(transition, path);
                double minusLogProbability = qe2.minusLogProbability - probabilities.emissionLogProbability(to2.getSnap().getQueryDistance()) - transitionLogProbability;
                Label label1 = (Label)labels.get(to2);
                if (label1 != null && !(minusLogProbability < label1.minusLogProbability)) continue;
                q.stream().filter(oldQe -> !oldQe.isDeleted && oldQe.state == to2).findFirst().ifPresent(oldQe -> {
                    oldQe.isDeleted = true;
                });
                Label label = new Label();
                label.state = to2;
                label.timeStep = qe2.timeStep + 1;
                label.back = qe2;
                label.minusLogProbability = minusLogProbability;
                q.add(label);
                labels.put(to2, label);
            }
        }
        if (qe2 == null) {
            throw new IllegalArgumentException("Sequence is broken for submitted track at initial time step.");
        }
        if (qe2.timeStep != timeSteps.size() - 1 && !ignoreErrors) {
            throw new IllegalArgumentException("Sequence is broken for submitted track at time step " + qe2.timeStep + ". observation:" + String.valueOf(qe2.state.getEntry()));
        }
        ArrayList<SequenceState<State, Observation, Path>> result = new ArrayList<SequenceState<State, Observation, Path>>();
        while (qe2 != null) {
            SequenceState<State, Observation, Object> ss = new SequenceState<State, Observation, Object>(qe2.state, qe2.state.getEntry(), (qe2.back == null ? null : (Path)roadPaths.get(new Transition<State>(qe2.back.state, qe2.state))));
            result.add(ss);
            qe2 = qe2.back;
        }
        Collections.reverse(result);
        return result;
    }

    private List<EdgeMatch> prepareEdgeMatches(List<SequenceState<State, Observation, Path>> seq) {
        ArrayList<EdgeMatch> edgeMatches = new ArrayList<EdgeMatch>();
        ArrayList<State> states = new ArrayList<State>();
        EdgeIteratorState currentDirectedRealEdge = null;
        for (SequenceState<State, Observation, Path> transitionAndState : seq) {
            if (transitionAndState.transitionDescriptor != null) {
                for (EdgeIteratorState edge : ((Path)transitionAndState.transitionDescriptor).calcEdges()) {
                    EdgeIteratorState newDirectedRealEdge = this.resolveToRealEdge(edge);
                    if (currentDirectedRealEdge != null && !this.equalEdges(currentDirectedRealEdge, newDirectedRealEdge)) {
                        EdgeMatch edgeMatch = new EdgeMatch(currentDirectedRealEdge, states);
                        edgeMatches.add(edgeMatch);
                        states = new ArrayList();
                    }
                    currentDirectedRealEdge = newDirectedRealEdge;
                }
            }
            if (((State)transitionAndState.state).isOnDirectedEdge()) {
                EdgeIteratorState newDirectedRealEdge = this.resolveToRealEdge(((State)transitionAndState.state).getOutgoingVirtualEdge());
                if (currentDirectedRealEdge != null && !this.equalEdges(currentDirectedRealEdge, newDirectedRealEdge)) {
                    EdgeMatch edgeMatch = new EdgeMatch(currentDirectedRealEdge, states);
                    edgeMatches.add(edgeMatch);
                    states = new ArrayList();
                }
                currentDirectedRealEdge = newDirectedRealEdge;
            }
            states.add((State)transitionAndState.state);
        }
        if (currentDirectedRealEdge != null) {
            EdgeMatch edgeMatch = new EdgeMatch(currentDirectedRealEdge, states);
            edgeMatches.add(edgeMatch);
        }
        return edgeMatches;
    }

    private double gpxLength(List<Observation> gpxList) {
        if (gpxList.isEmpty()) {
            return 0.0;
        }
        double gpxLength = 0.0;
        Observation prevEntry = gpxList.get(0);
        for (int i = 1; i < gpxList.size(); ++i) {
            Observation entry = gpxList.get(i);
            gpxLength += this.distanceCalc.calcDist(prevEntry.getPoint().lat, prevEntry.getPoint().lon, entry.getPoint().lat, entry.getPoint().lon);
            prevEntry = entry;
        }
        return gpxLength;
    }

    private boolean equalEdges(EdgeIteratorState edge1, EdgeIteratorState edge2) {
        return edge1.getEdge() == edge2.getEdge() && edge1.getBaseNode() == edge2.getBaseNode() && edge1.getAdjNode() == edge2.getAdjNode();
    }

    private EdgeIteratorState resolveToRealEdge(EdgeIteratorState edgeIteratorState) {
        if (this.queryGraph.isVirtualNode(edgeIteratorState.getBaseNode()) || this.queryGraph.isVirtualNode(edgeIteratorState.getAdjNode())) {
            return this.graph.getEdgeIteratorStateForKey(((VirtualEdgeIteratorState)edgeIteratorState).getOriginalEdgeKey());
        }
        return edgeIteratorState;
    }

    public Map<String, Object> getStatistics() {
        return this.statistics;
    }

    public static interface Router {
        public EdgeFilter getSnapFilter();

        public List<Path> calcPaths(QueryGraph var1, int var2, int var3, int[] var4, int[] var5);

        public Weighting getWeighting();

        default public long getVisitedNodes() {
            return 0L;
        }
    }

    private static class MapMatchedPath
    extends Path {
        MapMatchedPath(Graph graph, Weighting weighting, List<EdgeIteratorState> edges) {
            super(graph);
            int prevEdge = -1;
            for (EdgeIteratorState edge : edges) {
                this.addDistance(edge.getDistance());
                this.addTime(GHUtility.calcMillisWithTurnMillis(weighting, edge, false, prevEdge));
                this.addEdge(edge.getEdge());
                prevEdge = edge.getEdge();
            }
            if (edges.isEmpty()) {
                this.setFound(false);
            } else {
                this.setFromNode(edges.get(0).getBaseNode());
                this.setFound(true);
            }
        }
    }

    static class Label {
        int timeStep;
        State state;
        Label back;
        boolean isDeleted;
        double minusLogProbability;

        Label() {
        }
    }
}

