/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.navigation;

import com.graphhopper.GHRequest;
import com.graphhopper.GHResponse;
import com.graphhopper.GraphHopper;
import com.graphhopper.GraphHopperConfig;
import com.graphhopper.navigation.DistanceConfig;
import com.graphhopper.navigation.DistanceUtils;
import com.graphhopper.navigation.NavigateResponseConverter;
import com.graphhopper.util.Helper;
import com.graphhopper.util.StopWatch;
import com.graphhopper.util.TranslationMap;
import com.graphhopper.util.shapes.GHPoint;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="navigate")
public class NavigateResource {
    private static final Logger logger = LoggerFactory.getLogger(NavigateResource.class);
    private final GraphHopper graphHopper;
    private final TranslationMap translationMap;
    private final Map<String, String> resolverMap;

    @Inject
    public NavigateResource(GraphHopper graphHopper, TranslationMap translationMap, GraphHopperConfig config) {
        this.graphHopper = graphHopper;
        this.resolverMap = config.asPMap().getObject("profiles_mapbox", new HashMap());
        if (this.resolverMap.isEmpty()) {
            this.resolverMap.put("driving", "car");
            this.resolverMap.put("driving-traffic", "car");
            this.resolverMap.put("walking", "foot");
            this.resolverMap.put("cycling", "bike");
        }
        this.translationMap = translationMap;
    }

    @GET
    @Path(value="/directions/v5/gh/{profile}/{coordinatesArray : .+}")
    @Produces(value={"application/json"})
    public Response doGet(@Context HttpServletRequest httpReq, @Context UriInfo uriInfo, @Context ContainerRequestContext rc, @QueryParam(value="steps") @DefaultValue(value="false") boolean enableInstructions, @QueryParam(value="voice_instructions") @DefaultValue(value="false") boolean voiceInstructions, @QueryParam(value="banner_instructions") @DefaultValue(value="false") boolean bannerInstructions, @QueryParam(value="roundabout_exits") @DefaultValue(value="false") boolean roundaboutExits, @QueryParam(value="voice_units") @DefaultValue(value="metric") String voiceUnits, @QueryParam(value="overview") @DefaultValue(value="simplified") String overview, @QueryParam(value="geometries") @DefaultValue(value="polyline") String geometries, @QueryParam(value="bearings") @DefaultValue(value="") String bearings, @QueryParam(value="language") @DefaultValue(value="en") String localeStr, @PathParam(value="profile") String mapboxProfile) {
        StopWatch sw = new StopWatch().start();
        if (!geometries.equals("polyline6")) {
            throw new IllegalArgumentException("Currently, we only support polyline6");
        }
        if (!enableInstructions) {
            throw new IllegalArgumentException("Currently, you need to enable steps");
        }
        if (!roundaboutExits) {
            throw new IllegalArgumentException("Roundabout exits have to be enabled right now");
        }
        if (!voiceInstructions) {
            throw new IllegalArgumentException("You need to enable voice instructions right now");
        }
        if (!bannerInstructions) {
            throw new IllegalArgumentException("You need to enable banner instructions right now");
        }
        double minPathPrecision = overview.equals("full") ? 0.0 : 1.0;
        String ghProfile = this.resolverMap.getOrDefault(mapboxProfile, mapboxProfile);
        List<GHPoint> requestPoints = this.getPointsFromRequest(httpReq, mapboxProfile);
        List<Double> favoredHeadings = NavigateResource.getBearing(bearings);
        if (!favoredHeadings.isEmpty() && favoredHeadings.size() != requestPoints.size()) {
            throw new IllegalArgumentException("Number of bearings and waypoints did not match");
        }
        GHResponse ghResponse = this.calcRouteForGET(favoredHeadings, requestPoints, ghProfile, localeStr, enableInstructions, minPathPrecision);
        if (!ghResponse.hasErrors() && !favoredHeadings.isEmpty()) {
            GHResponse noHeadingResponse = this.calcRouteForGET(Collections.emptyList(), requestPoints, ghProfile, localeStr, enableInstructions, minPathPrecision);
            if (ghResponse.getBest().getDistance() != noHeadingResponse.getBest().getDistance()) {
                ghResponse.getAll().add(noHeadingResponse.getBest());
            }
        }
        float took = sw.stop().getSeconds();
        String infoStr = httpReq.getRemoteAddr() + " " + String.valueOf(httpReq.getLocale()) + " " + httpReq.getHeader("User-Agent");
        String logStr = httpReq.getQueryString() + " " + infoStr + " " + String.valueOf(requestPoints) + ", took:" + took + ", " + ghProfile;
        if (ghResponse.hasErrors()) {
            logger.error(logStr + ", errors:" + String.valueOf(ghResponse.getErrors()));
            return Response.status(422).entity(NavigateResponseConverter.convertFromGHResponseError(ghResponse)).header("X-GH-Took", "" + Math.round(took * 1000.0f)).build();
        }
        DistanceUtils.Unit unit = voiceUnits.equals("metric") ? DistanceUtils.Unit.METRIC : DistanceUtils.Unit.IMPERIAL;
        Locale locale = Helper.getLocale(localeStr);
        DistanceConfig config = new DistanceConfig(unit, this.translationMap, locale, this.graphHopper.getNavigationMode(ghProfile));
        logger.info(logStr);
        return Response.ok(NavigateResponseConverter.convertFromGHResponse(ghResponse, this.translationMap, locale, config)).header("X-GH-Took", "" + Math.round(took * 1000.0f)).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response doPost(@NotNull GHRequest request, @Context HttpServletRequest httpReq) {
        StopWatch sw = new StopWatch().start();
        if (request.getHints().has("geometries")) {
            throw new IllegalArgumentException("Do not set 'geometries'. Per default it is 'polyline6'.");
        }
        if (request.getHints().has("steps")) {
            throw new IllegalArgumentException("Do not set 'steps'. Per default it is true.");
        }
        if (request.getHints().has("roundabout_exits")) {
            throw new IllegalArgumentException("Do not set 'roundabout_exits'. Per default it is true.");
        }
        if (request.getHints().has("voice_instructions")) {
            throw new IllegalArgumentException("Do not set 'voice_instructions'. Per default it is true.");
        }
        if (request.getHints().has("banner_instructions")) {
            throw new IllegalArgumentException("Do not set 'banner_instructions'. Per default it is true.");
        }
        if (request.getHints().has("elevation")) {
            throw new IllegalArgumentException("Do not set 'elevation'. Per default it is false.");
        }
        if (request.getHints().has("overview")) {
            throw new IllegalArgumentException("Do not set 'overview'. Per default it is 'full'.");
        }
        if (request.getHints().has("language")) {
            throw new IllegalArgumentException("Instead of 'language' use 'locale'. Per default it is 'en'.");
        }
        if (request.getHints().has("points_encoded")) {
            throw new IllegalArgumentException("Do not set 'points_encoded'. Per default it is true.");
        }
        if (request.getHints().has("points_encoded_multiplier")) {
            throw new IllegalArgumentException("Do not set 'points_encoded_multiplier'. Per default it is 1e6.");
        }
        if (!request.getHints().getString("type", "").equals("mapbox")) {
            throw new IllegalArgumentException("Currently type=mapbox required.");
        }
        if (request.getPathDetails().isEmpty()) {
            if (this.graphHopper.getEncodingManager().hasEncodedValue("max_speed")) {
                request.setPathDetails(List.of("intersection", "max_speed", "distance", "time", "average_speed"));
            } else {
                request.setPathDetails(List.of("intersection"));
            }
        }
        GHResponse ghResponse = this.graphHopper.route(request);
        double took = sw.stop().getMillisDouble();
        String infoStr = httpReq.getRemoteAddr() + " " + String.valueOf(httpReq.getLocale()) + " " + httpReq.getHeader("User-Agent");
        String logStr = infoStr + " " + request.getPoints().size() + ", took: " + String.format("%.1f", took) + " ms, algo: " + request.getAlgorithm() + ", profile: " + request.getProfile() + ", points: " + String.valueOf(request.getPoints()) + ", custom_model: " + String.valueOf(request.getCustomModel());
        if (ghResponse.hasErrors()) {
            logger.error(logStr + ", errors:" + String.valueOf(ghResponse.getErrors()));
            return Response.status(422).entity(NavigateResponseConverter.convertFromGHResponseError(ghResponse)).header("X-GH-Took", "" + Math.round(took * 1000.0)).build();
        }
        DistanceUtils.Unit unit = request.getHints().getString("voice_units", "metric").equals("metric") ? DistanceUtils.Unit.METRIC : DistanceUtils.Unit.IMPERIAL;
        DistanceConfig config = new DistanceConfig(unit, this.translationMap, request.getLocale(), this.graphHopper.getNavigationMode(request.getProfile()));
        logger.info(logStr);
        return Response.ok(NavigateResponseConverter.convertFromGHResponse(ghResponse, this.translationMap, request.getLocale(), config)).header("X-GH-Took", "" + Math.round(took * 1000.0)).build();
    }

    private GHResponse calcRouteForGET(List<Double> headings, List<GHPoint> requestPoints, String profileStr, String localeStr, boolean enableInstructions, double minPathPrecision) {
        GHRequest request = new GHRequest(requestPoints);
        if (!headings.isEmpty()) {
            request.setHeadings(headings);
        }
        request.setProfile(profileStr).setLocale(localeStr).setPathDetails(List.of("intersection")).putHint("calc_points", true).putHint("instructions", enableInstructions).putHint("way_point_max_distance", minPathPrecision);
        if (requestPoints.size() > 2 || !headings.isEmpty()) {
            request.putHint("ch.disable", true).putHint("pass_through", true);
        }
        return this.graphHopper.route(request);
    }

    private List<GHPoint> getPointsFromRequest(HttpServletRequest httpServletRequest, String profile) {
        String urlStart;
        String url = httpServletRequest.getRequestURI();
        if (!url.startsWith(urlStart = "/navigate/directions/v5/gh/" + profile + "/")) {
            throw new IllegalArgumentException("Incorrect URL " + url);
        }
        url = url.substring(urlStart.length());
        String[] pointStrings = url.split(";");
        ArrayList<GHPoint> points = new ArrayList<GHPoint>(pointStrings.length);
        for (String pointString : pointStrings) {
            points.add(GHPoint.fromStringLonLat(pointString));
        }
        return points;
    }

    static List<Double> getBearing(String bearingString) {
        if (bearingString == null || bearingString.isEmpty()) {
            return Collections.emptyList();
        }
        String[] bearingArray = bearingString.split(";", -1);
        ArrayList<Double> bearings = new ArrayList<Double>(bearingArray.length);
        for (String singleBearing : bearingArray) {
            if (singleBearing.isEmpty()) {
                bearings.add(Double.NaN);
                continue;
            }
            if (!singleBearing.contains(",")) {
                throw new IllegalArgumentException("You passed an invalid bearings parameter " + bearingString);
            }
            String[] singleBearingArray = singleBearing.split(",");
            try {
                bearings.add(Double.parseDouble(singleBearingArray[0]));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("You passed an invalid bearings parameter " + bearingString);
            }
        }
        return bearings;
    }
}

