/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.reader.dem;

import com.graphhopper.reader.dem.AbstractTiffElevationProvider;
import com.graphhopper.util.Helper;
import java.awt.image.Raster;
import java.io.File;
import java.io.FileInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.xmlgraphics.image.codec.tiff.TIFFDecodeParam;
import org.apache.xmlgraphics.image.codec.tiff.TIFFImageDecoder;
import org.apache.xmlgraphics.image.codec.util.SeekableStream;

public class CGIARProvider
extends AbstractTiffElevationProvider {
    private final double invPrecision = 1.0E-7;

    public CGIARProvider() {
        this("");
    }

    public CGIARProvider(String cacheDir) {
        super("https://srtm.csi.cgiar.org/wp-content/uploads/files/srtm_5x5/TIFF/", cacheDir.isEmpty() ? "/tmp/cgiar" : cacheDir, "GraphHopper CGIARReader", 6000, 6000, 5, 5);
    }

    public static void main(String[] args2) {
        CGIARProvider provider = new CGIARProvider();
        System.out.println(provider.getEle(46.0, -20.0));
        System.out.println(provider.getEle(49.949784, 11.57517));
        System.out.println(provider.getEle(49.968668, 11.575127));
        System.out.println(provider.getEle(49.968682, 11.574842));
        System.out.println(provider.getEle(-22.532854, -65.110474));
        System.out.println(provider.getEle(38.065392, -87.099609));
        System.out.println(provider.getEle(40.0, -105.2277023));
        System.out.println(provider.getEle(39.99999999, -105.2277023));
        System.out.println(provider.getEle(39.9999999, -105.2277023));
        System.out.println(provider.getEle(39.999999, -105.2277023));
        System.out.println(provider.getEle(29.840644, -42.890625));
        System.out.println(provider.getEle(48.469123, 9.576393));
    }

    @Override
    Raster readFile(File file, String tifName) {
        Raster raster;
        block6: {
            SeekableStream ss = null;
            try {
                FileInputStream is = new FileInputStream(file);
                ZipInputStream zis = new ZipInputStream(is);
                ZipEntry entry = zis.getNextEntry();
                while (entry != null && !entry.getName().equals(tifName)) {
                    entry = zis.getNextEntry();
                }
                ss = SeekableStream.wrapInputStream(zis, true);
                TIFFImageDecoder imageDecoder = new TIFFImageDecoder(ss, new TIFFDecodeParam());
                raster = imageDecoder.decodeAsRaster();
                if (ss == null) break block6;
            }
            catch (Exception e) {
                try {
                    throw new RuntimeException("Can't decode " + tifName, e);
                }
                catch (Throwable throwable) {
                    if (ss != null) {
                        Helper.close(ss);
                    }
                    throw throwable;
                }
            }
            Helper.close(ss);
        }
        return raster;
    }

    int down(double val) {
        int intVal = (int)(val / (double)this.LAT_DEGREE) * this.LAT_DEGREE;
        if (!(val >= 0.0) && !((double)intVal - val < 1.0E-7)) {
            intVal -= this.LAT_DEGREE;
        }
        return intVal;
    }

    @Override
    boolean isOutsideSupportedArea(double lat, double lon) {
        return lat >= 60.0 || lat <= -56.0;
    }

    @Override
    protected String getFileName(double lat, double lon) {
        lon = 1.0 + (180.0 + lon) / (double)this.LAT_DEGREE;
        int lonInt = (int)lon;
        int latInt = (int)(lat = 1.0 + (60.0 - lat) / (double)this.LAT_DEGREE);
        if (Math.abs((double)latInt - lat) < 1.0E-7 / (double)this.LAT_DEGREE) {
            --latInt;
        }
        Object str = "srtm_";
        str = (String)str + (lonInt < 10 ? "0" : "");
        str = (String)str + lonInt;
        str = (String)str + (latInt < 10 ? "_0" : "_");
        str = (String)str + latInt;
        return str;
    }

    @Override
    int getMinLatForTile(double lat) {
        return this.down(lat);
    }

    @Override
    int getMinLonForTile(double lon) {
        return this.down(lon);
    }

    @Override
    String getDownloadURL(double lat, double lon) {
        return this.baseUrl + "/" + this.getFileName(lat, lon) + ".zip";
    }

    @Override
    String getFileNameOfLocalFile(double lat, double lon) {
        return this.getDownloadURL(lat, lon);
    }

    public String toString() {
        return "cgiar";
    }
}

