/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.reader.osm;

import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.LongArrayList;
import com.carrotsearch.hppc.cursors.IntCursor;
import com.carrotsearch.hppc.cursors.LongCursor;
import com.graphhopper.reader.osm.OSMRestrictionException;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.util.EdgeIteratorState;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.LongFunction;

public class WayToEdgeConverter {
    private final BaseGraph baseGraph;
    private final LongFunction<Iterator<IntCursor>> edgesByWay;

    public WayToEdgeConverter(BaseGraph baseGraph, LongFunction<Iterator<IntCursor>> edgesByWay) {
        this.baseGraph = baseGraph;
        this.edgesByWay = edgesByWay;
    }

    public NodeResult convertForViaNode(LongArrayList fromWays, int viaNode, LongArrayList toWays) throws OSMRestrictionException {
        if (fromWays.isEmpty() || toWays.isEmpty()) {
            throw new IllegalArgumentException("There must be at least one from- and to-way");
        }
        if (fromWays.size() > 1 && toWays.size() > 1) {
            throw new IllegalArgumentException("There can only be multiple from- or to-ways, but not both");
        }
        NodeResult result = new NodeResult(fromWays.size(), toWays.size());
        for (LongCursor fromWay : fromWays) {
            this.edgesByWay.apply(fromWay.value).forEachRemaining(e -> {
                if (this.baseGraph.isAdjacentToNode(e.value, viaNode)) {
                    result.fromEdges.add(e.value);
                }
            });
        }
        if (result.fromEdges.size() < fromWays.size()) {
            throw new OSMRestrictionException("has from-member ways that aren't adjacent to the via-member node");
        }
        if (result.fromEdges.size() > fromWays.size()) {
            throw new OSMRestrictionException("has from-member ways that aren't split at the via-member node");
        }
        for (LongCursor toWay : toWays) {
            this.edgesByWay.apply(toWay.value).forEachRemaining(e -> {
                if (this.baseGraph.isAdjacentToNode(e.value, viaNode)) {
                    result.toEdges.add(e.value);
                }
            });
        }
        if (result.toEdges.size() < toWays.size()) {
            throw new OSMRestrictionException("has to-member ways that aren't adjacent to the via-member node");
        }
        if (result.toEdges.size() > toWays.size()) {
            throw new OSMRestrictionException("has to-member ways that aren't split at the via-member node");
        }
        return result;
    }

    public EdgeResult convertForViaWays(LongArrayList fromWays, LongArrayList viaWays, LongArrayList toWays) throws OSMRestrictionException {
        if (fromWays.isEmpty() || toWays.isEmpty() || viaWays.isEmpty()) {
            throw new IllegalArgumentException("There must be at least one from-, via- and to-way");
        }
        if (fromWays.size() > 1 && toWays.size() > 1) {
            throw new IllegalArgumentException("There can only be multiple from- or to-ways, but not both");
        }
        ArrayList<IntArrayList> solutions = new ArrayList<IntArrayList>();
        for (LongCursor fromWay : fromWays) {
            for (LongCursor toWay : toWays) {
                this.findEdgeChain(fromWay.value, viaWays, toWay.value, solutions);
            }
        }
        if (solutions.size() < fromWays.size() * toWays.size()) {
            throw new OSMRestrictionException("has disconnected member ways");
        }
        if (solutions.size() > fromWays.size() * toWays.size()) {
            throw new OSMRestrictionException("has member ways that do not form a unique path");
        }
        return WayToEdgeConverter.buildResult(solutions, fromWays, viaWays, toWays);
    }

    private static EdgeResult buildResult(List<IntArrayList> edgeChains, LongArrayList fromWays, LongArrayList viaWays, LongArrayList toWays) {
        EdgeResult result = new EdgeResult(fromWays.size(), viaWays.size(), toWays.size());
        IntArrayList firstChain = edgeChains.get(0);
        result.fromEdges.add(firstChain.get(0));
        for (int i = 1; i < firstChain.size() - 3; i += 2) {
            result.nodes.add(firstChain.get(i));
            result.viaEdges.add(firstChain.get(i + 1));
        }
        result.nodes.add(firstChain.get(firstChain.size() - 2));
        result.toEdges.add(firstChain.get(firstChain.size() - 1));
        List<IntArrayList> otherChains = edgeChains.subList(1, edgeChains.size());
        if (fromWays.size() > 1) {
            if (otherChains.stream().anyMatch(chain -> chain.get(chain.size() - 1) != firstChain.get(firstChain.size() - 1))) {
                throw new IllegalArgumentException("edge chains were supposed to be the same except for their first elements, but got: " + String.valueOf(edgeChains) + " - for: " + String.valueOf(fromWays) + ", " + String.valueOf(viaWays) + ", " + String.valueOf(toWays));
            }
            otherChains.forEach(chain -> result.fromEdges.add(chain.get(0)));
        } else if (toWays.size() > 1) {
            if (otherChains.stream().anyMatch(chain -> chain.get(0) != firstChain.get(0))) {
                throw new IllegalArgumentException("edge chains were supposed to be the same except for their last elements, but got: " + String.valueOf(edgeChains) + " - for: " + String.valueOf(fromWays) + ", " + String.valueOf(viaWays) + ", " + String.valueOf(toWays));
            }
            otherChains.forEach(chain -> result.toEdges.add(chain.get(chain.size() - 1)));
        } else if (!otherChains.isEmpty()) {
            throw new IllegalStateException("If there are multiple chains there must be either multiple from- or to-ways.");
        }
        return result;
    }

    private void findEdgeChain(long fromWay, LongArrayList viaWays, long toWay, List<IntArrayList> solutions) {
        IntArrayList viaEdgesForViaWays = new IntArrayList(viaWays.size());
        for (LongCursor c : viaWays) {
            Iterator<IntCursor> iterator2 = this.edgesByWay.apply(c.value);
            viaEdgesForViaWays.add(iterator2.next().value);
            iterator2.forEachRemaining(i -> viaEdgesForViaWays.add(i.value));
        }
        IntArrayList toEdges = WayToEdgeConverter.listFromIterator(this.edgesByWay.apply(toWay));
        this.edgesByWay.apply(fromWay).forEachRemaining(from -> {
            EdgeIteratorState edge = this.baseGraph.getEdgeIteratorState(from.value, Integer.MIN_VALUE);
            this.explore(viaEdgesForViaWays, toEdges, edge.getBaseNode(), 0, IntArrayList.from(edge.getEdge(), edge.getBaseNode()), solutions);
            this.explore(viaEdgesForViaWays, toEdges, edge.getAdjNode(), 0, IntArrayList.from(edge.getEdge(), edge.getAdjNode()), solutions);
        });
    }

    private void explore(IntArrayList viaEdgesForViaWays, IntArrayList toEdges, int node, int viaCount, IntArrayList curr, List<IntArrayList> solutions) {
        if (viaCount == viaEdgesForViaWays.size()) {
            for (IntCursor to : toEdges) {
                if (!this.baseGraph.isAdjacentToNode(to.value, node)) continue;
                IntArrayList solution = new IntArrayList(curr);
                solution.add(to.value);
                solutions.add(solution);
            }
            return;
        }
        for (int i = 0; i < viaEdgesForViaWays.size(); ++i) {
            int viaEdge = viaEdgesForViaWays.get(i);
            if (viaEdge < 0 || !this.baseGraph.isAdjacentToNode(viaEdge, node)) continue;
            int otherNode = this.baseGraph.getOtherNode(viaEdge, node);
            curr.add(viaEdge, otherNode);
            viaEdgesForViaWays.set(i, -1);
            this.explore(viaEdgesForViaWays, toEdges, otherNode, viaCount + 1, curr, solutions);
            curr.elementsCount -= 2;
            viaEdgesForViaWays.set(i, viaEdge);
        }
    }

    private static IntArrayList listFromIterator(Iterator<IntCursor> iterator2) {
        IntArrayList result = new IntArrayList();
        iterator2.forEachRemaining(c -> result.add(c.value));
        return result;
    }

    public static class NodeResult {
        private final IntArrayList fromEdges;
        private final IntArrayList toEdges;

        public NodeResult(int numFrom, int numTo) {
            this.fromEdges = new IntArrayList(numFrom);
            this.toEdges = new IntArrayList(numTo);
        }

        public IntArrayList getFromEdges() {
            return this.fromEdges;
        }

        public IntArrayList getToEdges() {
            return this.toEdges;
        }
    }

    public static class EdgeResult {
        private final IntArrayList fromEdges;
        private final IntArrayList viaEdges;
        private final IntArrayList toEdges;
        private final IntArrayList nodes;

        public EdgeResult(int numFrom, int numVia, int numTo) {
            this.fromEdges = new IntArrayList(numFrom);
            this.viaEdges = new IntArrayList(numVia);
            this.toEdges = new IntArrayList(numTo);
            this.nodes = new IntArrayList(numVia + 1);
        }

        public IntArrayList getFromEdges() {
            return this.fromEdges;
        }

        public IntArrayList getViaEdges() {
            return this.viaEdges;
        }

        public IntArrayList getToEdges() {
            return this.toEdges;
        }

        public IntArrayList getNodes() {
            return this.nodes;
        }
    }
}

