/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.reader.osm;

import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.LongIntMap;
import com.carrotsearch.hppc.LongIntScatterMap;
import com.carrotsearch.hppc.cursors.IntCursor;
import java.util.Collections;
import java.util.Iterator;

public class WayToEdgesMap {
    private static final int RESERVED = -1;
    private final LongIntMap offsetIndexByWay = new LongIntScatterMap();
    private final IntArrayList offsets = new IntArrayList();
    private final IntArrayList edges = new IntArrayList();
    private long lastWay = -1L;

    public void reserve(long way) {
        this.offsetIndexByWay.put(way, -1);
    }

    public void putIfReserved(long way, int edge) {
        if (edge < 0) {
            throw new IllegalArgumentException("edge must be >= 0, but was: " + edge);
        }
        if (way != this.lastWay) {
            int idx = this.offsetIndexByWay.indexOf(way);
            if (idx < 0) {
                return;
            }
            if (this.offsetIndexByWay.indexGet(idx) != -1) {
                throw new IllegalArgumentException("You need to add all edges for way: " + way + " consecutively");
            }
            this.offsetIndexByWay.indexReplace(idx, this.offsets.size());
            this.offsets.add(this.edges.size());
            this.lastWay = way;
        }
        this.edges.add(edge);
    }

    public Iterator<IntCursor> getEdges(long way) {
        int idx = this.offsetIndexByWay.indexOf(way);
        if (idx < 0) {
            return Collections.emptyIterator();
        }
        int offsetIndex = this.offsetIndexByWay.indexGet(idx);
        if (offsetIndex == -1) {
            return Collections.emptyIterator();
        }
        final int offsetBegin = this.offsets.get(offsetIndex);
        final int offsetEnd = offsetIndex + 1 < this.offsets.size() ? this.offsets.get(offsetIndex + 1) : this.edges.size();
        final IntCursor cursor = new IntCursor();
        cursor.index = -1;
        return new Iterator<IntCursor>(){

            @Override
            public boolean hasNext() {
                return offsetBegin + cursor.index + 1 < offsetEnd;
            }

            @Override
            public IntCursor next() {
                ++cursor.index;
                cursor.value = WayToEdgesMap.this.edges.get(offsetBegin + cursor.index);
                return cursor;
            }
        };
    }
}

