/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.resources;

import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.graphhopper.GraphHopper;
import com.graphhopper.GraphHopperConfig;
import com.graphhopper.config.Profile;
import com.graphhopper.http.GHPointParam;
import com.graphhopper.http.ProfileResolver;
import com.graphhopper.isochrone.algorithm.ContourBuilder;
import com.graphhopper.isochrone.algorithm.ShortestPathTree;
import com.graphhopper.isochrone.algorithm.Triangulator;
import com.graphhopper.resources.RouteResource;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.Subnetwork;
import com.graphhopper.routing.querygraph.QueryGraph;
import com.graphhopper.routing.util.DefaultSnapFilter;
import com.graphhopper.routing.util.TraversalMode;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.storage.index.LocationIndex;
import com.graphhopper.storage.index.Snap;
import com.graphhopper.util.JsonFeature;
import com.graphhopper.util.PMap;
import com.graphhopper.util.StopWatch;
import com.graphhopper.util.shapes.GHPoint;
import jakarta.inject.Inject;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.function.ToDoubleFunction;
import org.hibernate.validator.constraints.Range;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="isochrone")
public class IsochroneResource {
    private static final Logger logger = LoggerFactory.getLogger(IsochroneResource.class);
    private final GraphHopperConfig config;
    private final GraphHopper graphHopper;
    private final Triangulator triangulator;
    private final ProfileResolver profileResolver;
    private final String osmDate;

    @Inject
    public IsochroneResource(GraphHopperConfig config, GraphHopper graphHopper, Triangulator triangulator, ProfileResolver profileResolver) {
        this.config = config;
        this.graphHopper = graphHopper;
        this.triangulator = triangulator;
        this.profileResolver = profileResolver;
        this.osmDate = graphHopper.getProperties().get("datareader.data.date");
    }

    @GET
    @Produces(value={"application/json"})
    public Response doGet(@Context UriInfo uriInfo, @QueryParam(value="profile") String profileName, @QueryParam(value="buckets") @Range(min=1L, max=20L) @DefaultValue(value="1") @Range(min=1L, max=20L) OptionalInt nBuckets, @QueryParam(value="reverse_flow") @DefaultValue(value="false") boolean reverseFlow, @QueryParam(value="point") @NotNull GHPointParam point, @QueryParam(value="time_limit") @DefaultValue(value="600") OptionalLong timeLimitInSeconds, @QueryParam(value="distance_limit") @DefaultValue(value="-1") OptionalLong distanceLimitInMeter, @QueryParam(value="weight_limit") @DefaultValue(value="-1") OptionalLong weightLimit, @QueryParam(value="type") @DefaultValue(value="json") ResponseType respType, @QueryParam(value="tolerance") @DefaultValue(value="0") double toleranceInMeter, @QueryParam(value="full_geometry") @DefaultValue(value="false") boolean fullGeometry) {
        ToDoubleFunction<ShortestPathTree.IsoLabel> fz;
        double limit;
        BooleanEncodedValue inSubnetworkEnc;
        StopWatch sw = new StopWatch().start();
        PMap hintsMap = new PMap();
        RouteResource.initHints(hintsMap, uriInfo.getQueryParameters());
        hintsMap.putObject("ch.disable", true);
        hintsMap.putObject("lm.disable", true);
        PMap profileResolverHints = new PMap(hintsMap);
        profileResolverHints.putObject("profile", profileName);
        profileName = this.profileResolver.resolveProfile(profileResolverHints);
        RouteResource.removeLegacyParameters(hintsMap);
        Profile profile = this.graphHopper.getProfile(profileName);
        if (profile == null) {
            throw new IllegalArgumentException("The requested profile '" + profileName + "' does not exist");
        }
        LocationIndex locationIndex = this.graphHopper.getLocationIndex();
        BaseGraph graph = this.graphHopper.getBaseGraph();
        Weighting weighting = this.graphHopper.createWeighting(profile, hintsMap);
        Snap snap = locationIndex.findClosest(((GHPoint)point.get()).lat, ((GHPoint)point.get()).lon, new DefaultSnapFilter(weighting, inSubnetworkEnc = this.graphHopper.getEncodingManager().getBooleanEncodedValue(Subnetwork.key(profileName))));
        if (!snap.isValid()) {
            throw new IllegalArgumentException("Point not found:" + String.valueOf(point));
        }
        QueryGraph queryGraph = QueryGraph.create(graph, snap);
        TraversalMode traversalMode = profile.hasTurnCosts() ? TraversalMode.EDGE_BASED : TraversalMode.NODE_BASED;
        ShortestPathTree shortestPathTree = new ShortestPathTree(queryGraph, queryGraph.wrapWeighting(weighting), reverseFlow, traversalMode);
        if (weightLimit.orElseThrow(() -> new IllegalArgumentException("query param weight_limit is not a number.")) > 0L) {
            limit = weightLimit.getAsLong();
            shortestPathTree.setWeightLimit(limit + Math.max(limit * 0.14, 200.0));
            fz = l -> l.weight;
        } else if (distanceLimitInMeter.orElseThrow(() -> new IllegalArgumentException("query param distance_limit is not a number.")) > 0L) {
            limit = distanceLimitInMeter.getAsLong();
            shortestPathTree.setDistanceLimit(limit + Math.max(limit * 0.14, 2000.0));
            fz = l -> l.distance;
        } else {
            limit = (double)timeLimitInSeconds.orElseThrow(() -> new IllegalArgumentException("query param time_limit is not a number.")) * 1000.0;
            shortestPathTree.setTimeLimit(limit + Math.max(limit * 0.14, 200000.0));
            fz = l -> l.time;
        }
        ArrayList<Double> zs = new ArrayList<Double>();
        double delta = limit / (double)nBuckets.orElseThrow(() -> new IllegalArgumentException("query param buckets is not a number."));
        for (int i = 0; i < nBuckets.getAsInt(); ++i) {
            zs.add((double)(i + 1) * delta);
        }
        Triangulator.Result result = this.triangulator.triangulate(snap, queryGraph, shortestPathTree, fz, IsochroneResource.degreesFromMeters(toleranceInMeter));
        ContourBuilder contourBuilder = new ContourBuilder(result.triangulation);
        ArrayList<Geometry> isochrones = new ArrayList<Geometry>();
        for (Double d : zs) {
            logger.info("Building contour z={}", (Object)d);
            Geometry isochrone = contourBuilder.computeIsoline(d, result.seedEdges);
            if (fullGeometry) {
                isochrones.add(isochrone);
                continue;
            }
            Polygon maxPolygon = this.heuristicallyFindMainConnectedComponent((MultiPolygon)isochrone, isochrone.getFactory().createPoint(new Coordinate(((GHPoint)point.get()).lon, ((GHPoint)point.get()).lat)));
            isochrones.add(isochrone.getFactory().createPolygon(maxPolygon.getExteriorRing()));
        }
        ArrayList<JsonFeature> features = new ArrayList<JsonFeature>();
        for (Geometry isochrone : isochrones) {
            JsonFeature feature = new JsonFeature();
            HashMap<String, Object> properties = new HashMap<String, Object>();
            properties.put("bucket", features.size());
            if (respType == ResponseType.geojson) {
                properties.put("copyrights", this.config.getCopyrights());
            }
            feature.setProperties(properties);
            feature.setGeometry(isochrone);
            features.add(feature);
        }
        ObjectNode objectNode = JsonNodeFactory.instance.objectNode();
        sw.stop();
        ObjectNode finalJson = null;
        if (respType == ResponseType.geojson) {
            objectNode.put("type", "FeatureCollection");
            objectNode.putPOJO("features", features);
            finalJson = objectNode;
        } else {
            objectNode.putPOJO("polygons", features);
            ObjectNode info = objectNode.putObject("info");
            info.putPOJO("copyrights", this.config.getCopyrights());
            info.put("took", Math.round(sw.getMillis()));
            if (!this.osmDate.isEmpty()) {
                info.put("road_data_timestamp", this.osmDate);
            }
            finalJson = objectNode;
        }
        logger.info("took: " + sw.getSeconds() + ", visited nodes:" + shortestPathTree.getVisitedNodes());
        return Response.ok(finalJson).header("X-GH-Took", "" + sw.getSeconds() * 1000.0f).build();
    }

    private Polygon heuristicallyFindMainConnectedComponent(MultiPolygon multiPolygon, Point point) {
        int maxPoints = 0;
        Polygon maxPolygon = null;
        for (int j = 0; j < multiPolygon.getNumGeometries(); ++j) {
            Polygon polygon = (Polygon)multiPolygon.getGeometryN(j);
            if (polygon.contains(point)) {
                return polygon;
            }
            if (polygon.getNumPoints() <= maxPoints) continue;
            maxPoints = polygon.getNumPoints();
            maxPolygon = polygon;
        }
        return maxPolygon;
    }

    static double degreesFromMeters(double distanceInMeters) {
        return distanceInMeters / 111194.92664455873;
    }

    public static enum ResponseType {
        json,
        geojson;

    }
}

