/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.resources;

import com.graphhopper.GraphHopper;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.IntEncodedValue;
import com.graphhopper.routing.ev.RoadClass;
import com.graphhopper.routing.ev.StringEncodedValue;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.search.KVStorage;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.storage.index.LocationIndexTree;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.FetchMode;
import com.graphhopper.util.PointList;
import com.graphhopper.util.StopWatch;
import com.graphhopper.util.shapes.BBox;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import no.ecc.vectortile.VectorTileEncoder;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.util.AffineTransformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="mvt")
public class MVTResource {
    private static final Logger logger = LoggerFactory.getLogger(MVTResource.class);
    private static final MediaType PBF = new MediaType("application", "x-protobuf");
    private final GraphHopper graphHopper;
    private final EncodingManager encodingManager;

    @Inject
    public MVTResource(GraphHopper graphHopper, EncodingManager encodingManager) {
        this.graphHopper = graphHopper;
        this.encodingManager = encodingManager;
    }

    @GET
    @Path(value="{z}/{x}/{y}.mvt")
    @Produces(value={"application/x-protobuf"})
    public Response doGetXyz(@Context HttpServletRequest httpReq, @Context UriInfo uriInfo, @PathParam(value="z") int zInfo, @PathParam(value="x") int xInfo, @PathParam(value="y") int yInfo, @QueryParam(value="render_all") @DefaultValue(value="false") Boolean renderAll) {
        if (zInfo <= 9) {
            byte[] bytes = new VectorTileEncoder().encode();
            return Response.fromResponse(Response.ok((Object)bytes, PBF).build()).header("X-GH-Took", "0").build();
        }
        StopWatch totalSW = new StopWatch().start();
        Coordinate nw = this.num2deg(xInfo, yInfo, zInfo);
        Coordinate se = this.num2deg(xInfo + 1, yInfo + 1, zInfo);
        LocationIndexTree locationIndex = (LocationIndexTree)this.graphHopper.getLocationIndex();
        NodeAccess na = this.graphHopper.getBaseGraph().getNodeAccess();
        BBox bbox = new BBox(nw.x, se.x, se.y, nw.y);
        if (!bbox.isValid()) {
            throw new IllegalStateException("Invalid bbox " + String.valueOf(bbox));
        }
        GeometryFactory geometryFactory = new GeometryFactory();
        if (!this.encodingManager.hasEncodedValue("road_class")) {
            throw new IllegalStateException("You need to configure GraphHopper to store road_class, e.g. graph.encoded_values: road_class,max_speed,... ");
        }
        EnumEncodedValue<RoadClass> roadClassEnc = this.encodingManager.getEnumEncodedValue("road_class", RoadClass.class);
        AtomicInteger edgeCounter = new AtomicInteger(0);
        AffineTransformation affineTransformation = new AffineTransformation();
        affineTransformation.translate(-nw.x, -se.y);
        affineTransformation.scale(256.0 / (se.x - nw.x), -256.0 / (nw.y - se.y));
        affineTransformation.translate(0.0, 256.0);
        VectorTileEncoder vectorTileEncoder = new VectorTileEncoder();
        locationIndex.query(bbox, edgeId -> {
            LineString lineString;
            EdgeIteratorState edge = this.graphHopper.getBaseGraph().getEdgeIteratorStateForKey(edgeId * 2);
            if (renderAll.booleanValue()) {
                PointList pl = edge.fetchWayGeometry(FetchMode.ALL);
                lineString = pl.toLineString(false);
            } else {
                RoadClass rc = (RoadClass)((Object)((Object)edge.get(roadClassEnc)));
                if (zInfo >= 14) {
                    PointList pl = edge.fetchWayGeometry(FetchMode.ALL);
                    lineString = pl.toLineString(false);
                } else if (rc == RoadClass.MOTORWAY || zInfo > 10 && (rc == RoadClass.PRIMARY || rc == RoadClass.TRUNK) || zInfo > 11 && rc == RoadClass.SECONDARY || zInfo > 12) {
                    double lat = na.getLat(edge.getBaseNode());
                    double lon = na.getLon(edge.getBaseNode());
                    double toLat = na.getLat(edge.getAdjNode());
                    double toLon = na.getLon(edge.getAdjNode());
                    lineString = geometryFactory.createLineString(new Coordinate[]{new Coordinate(lon, lat), new Coordinate(toLon, toLat)});
                } else {
                    return;
                }
            }
            edgeCounter.incrementAndGet();
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            for (Map.Entry<String, KVStorage.KValue> e : edge.getKeyValues().entrySet()) {
                map.put(e.getKey(), e.getValue().toString());
            }
            map.put("edge_id", edge.getEdge());
            map.put("edge_key", edge.getEdgeKey());
            map.put("base_node", edge.getBaseNode());
            map.put("adj_node", edge.getAdjNode());
            map.put("distance", edge.getDistance());
            this.encodingManager.getEncodedValues().forEach(ev -> {
                if (ev instanceof EnumEncodedValue) {
                    map.put(ev.getName(), ((Enum)edge.get((EnumEncodedValue)ev)).toString() + (String)(ev.isStoreTwoDirections() ? " | " + ((Enum)edge.getReverse((EnumEncodedValue)ev)).toString() : ""));
                } else if (ev instanceof DecimalEncodedValue) {
                    map.put(ev.getName(), edge.get((DecimalEncodedValue)ev) + (String)(ev.isStoreTwoDirections() ? " | " + edge.getReverse((DecimalEncodedValue)ev) : ""));
                } else if (ev instanceof BooleanEncodedValue) {
                    map.put(ev.getName(), edge.get((BooleanEncodedValue)ev) + (String)(ev.isStoreTwoDirections() ? " | " + edge.getReverse((BooleanEncodedValue)ev) : ""));
                } else if (ev instanceof StringEncodedValue) {
                    map.put(ev.getName(), edge.get((StringEncodedValue)ev) + (String)(ev.isStoreTwoDirections() ? " | " + edge.getReverse((StringEncodedValue)ev) : ""));
                } else if (ev instanceof IntEncodedValue) {
                    map.put(ev.getName(), edge.get((IntEncodedValue)ev) + (String)(ev.isStoreTwoDirections() ? " | " + edge.getReverse((IntEncodedValue)ev) : ""));
                }
            });
            lineString.setUserData(map);
            Geometry g2 = affineTransformation.transform(lineString);
            vectorTileEncoder.addFeature("roads", map, g2, edge.getEdge());
        });
        byte[] bytes = vectorTileEncoder.encode();
        totalSW.stop();
        logger.debug("took: " + totalSW.getMillis() + "ms, edges:" + edgeCounter.get());
        return Response.ok((Object)bytes, PBF).header("X-GH-Took", "" + totalSW.getSeconds() * 1000.0f).build();
    }

    Coordinate num2deg(int xInfo, int yInfo, int zoom) {
        double n = Math.pow(2.0, zoom);
        double lonDeg = (double)xInfo / n * 360.0 - 180.0;
        double latRad = Math.atan(Math.sinh(Math.PI * (1.0 - (double)(2 * yInfo) / n)));
        double latDeg = Math.toDegrees(latRad);
        return new Coordinate(lonDeg, latDeg);
    }
}

