/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.resources;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.graphhopper.GHResponse;
import com.graphhopper.GraphHopperConfig;
import com.graphhopper.gtfs.GHLocation;
import com.graphhopper.gtfs.PtRouter;
import com.graphhopper.gtfs.Request;
import com.graphhopper.http.DurationParam;
import com.graphhopper.http.GHLocationParam;
import com.graphhopper.http.OffsetDateTimeParam;
import com.graphhopper.jackson.ResponsePathSerializer;
import com.graphhopper.util.Helper;
import com.graphhopper.util.StopWatch;
import io.dropwizard.jersey.params.AbstractParam;
import jakarta.inject.Inject;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.lang.annotation.Annotation;
import java.time.Duration;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.glassfish.hk2.api.ServiceLocator;

@Path(value="route-pt")
public class PtRouteResource {
    private final GraphHopperConfig config;
    private final PtRouter ptRouter;
    @Inject
    ServiceLocator serviceLocator;

    @Inject
    public PtRouteResource(GraphHopperConfig config, PtRouter ptRouter) {
        this.config = config;
        this.ptRouter = ptRouter;
    }

    @GET
    @Produces(value={"application/json"})
    public ObjectNode route(@QueryParam(value="point") @Size(min=2, max=2) @Size(min=2, max=2) List<GHLocationParam> requestPoints, @QueryParam(value="pt.earliest_departure_time") @NotNull OffsetDateTimeParam departureTimeParam, @QueryParam(value="pt.profile_duration") DurationParam profileDuration, @QueryParam(value="pt.arrive_by") @DefaultValue(value="false") boolean arriveBy, @QueryParam(value="locale") String localeStr, @QueryParam(value="pt.ignore_transfers") Boolean ignoreTransfers, @QueryParam(value="pt.profile") Boolean profileQuery, @QueryParam(value="pt.limit_solutions") Integer limitSolutions, @QueryParam(value="pt.limit_trip_time") DurationParam limitTripTime, @QueryParam(value="pt.limit_street_time") DurationParam limitStreetTime, @QueryParam(value="pt.access_profile") String accessProfile, @QueryParam(value="pt.beta_access_time") Double betaAccessTime, @QueryParam(value="pt.egress_profile") String egressProfile, @QueryParam(value="pt.beta_egress_time") Double betaEgressTime, @QueryParam(value="pt.algorithm") String algorithm) {
        PtRouter ptRouter = this.serviceLocator.getService(PtRouter.class, algorithm, new Annotation[0]);
        StopWatch stopWatch = new StopWatch().start();
        List<GHLocation> points = requestPoints.stream().map(AbstractParam::get).collect(Collectors.toList());
        Instant departureTime = ((OffsetDateTime)departureTimeParam.get()).toInstant();
        Request request = new Request(points, departureTime);
        request.setArriveBy(arriveBy);
        Optional.ofNullable(profileQuery).ifPresent(request::setProfileQuery);
        Optional.ofNullable((Duration)profileDuration.get()).ifPresent(request::setMaxProfileDuration);
        Optional.ofNullable(ignoreTransfers).ifPresent(request::setIgnoreTransfers);
        Optional.ofNullable(localeStr).ifPresent(s2 -> request.setLocale(Helper.getLocale(s2)));
        Optional.ofNullable(limitSolutions).ifPresent(request::setLimitSolutions);
        Optional.ofNullable((Duration)limitTripTime.get()).ifPresent(request::setLimitTripTime);
        Optional.ofNullable((Duration)limitStreetTime.get()).ifPresent(request::setLimitStreetTime);
        Optional.ofNullable(accessProfile).ifPresent(request::setAccessProfile);
        Optional.ofNullable(betaAccessTime).ifPresent(request::setBetaAccessTime);
        Optional.ofNullable(egressProfile).ifPresent(request::setEgressProfile);
        Optional.ofNullable(betaEgressTime).ifPresent(request::setBetaEgressTime);
        GHResponse route = ptRouter.route(request);
        return ResponsePathSerializer.jsonObject(route, new ResponsePathSerializer.Info(this.config.getCopyrights(), Math.round(stopWatch.stop().getMillis()), null), true, true, false, false, -1.0);
    }
}

