/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.resources;

import com.graphhopper.GHRequest;
import com.graphhopper.GHResponse;
import com.graphhopper.GraphHopper;
import com.graphhopper.GraphHopperConfig;
import com.graphhopper.gpx.GpxConversions;
import com.graphhopper.http.GHPointParam;
import com.graphhopper.http.GHRequestTransformer;
import com.graphhopper.http.ProfileResolver;
import com.graphhopper.jackson.MultiException;
import com.graphhopper.jackson.ResponsePathSerializer;
import com.graphhopper.util.Constants;
import com.graphhopper.util.Helper;
import com.graphhopper.util.InstructionList;
import com.graphhopper.util.PMap;
import com.graphhopper.util.StopWatch;
import com.graphhopper.util.shapes.GHPoint;
import io.dropwizard.jersey.params.AbstractParam;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="route")
public class RouteResource {
    private static final Logger logger = LoggerFactory.getLogger(RouteResource.class);
    private final GraphHopperConfig config;
    private final GraphHopper graphHopper;
    private final ProfileResolver profileResolver;
    private final GHRequestTransformer ghRequestTransformer;
    private final Boolean hasElevation;
    private final String osmDate;
    private final List<String> snapPreventionsDefault;

    @Inject
    public RouteResource(GraphHopperConfig config, GraphHopper graphHopper, ProfileResolver profileResolver, GHRequestTransformer ghRequestTransformer, @Named(value="hasElevation") Boolean hasElevation) {
        this.config = config;
        this.graphHopper = graphHopper;
        this.profileResolver = profileResolver;
        this.ghRequestTransformer = ghRequestTransformer;
        this.hasElevation = hasElevation;
        this.osmDate = graphHopper.getProperties().getAll().get("datareader.data.date");
        this.snapPreventionsDefault = Arrays.stream(config.getString("routing.snap_preventions_default", "").split(",")).map(String::trim).filter(s2 -> !s2.isEmpty()).toList();
    }

    @GET
    @Produces(value={"application/json", "application/xml", "application/gpx+xml"})
    public Response doGet(@Context HttpServletRequest httpReq, @Context UriInfo uriInfo, @QueryParam(value="way_point_max_distance") @DefaultValue(value="0.5") double minPathPrecision, @QueryParam(value="elevation_way_point_max_distance") Double minPathElevationPrecision, @QueryParam(value="point") @NotNull List<GHPointParam> pointParams, @QueryParam(value="type") @DefaultValue(value="json") String type, @QueryParam(value="instructions") @DefaultValue(value="true") boolean instructions, @QueryParam(value="calc_points") @DefaultValue(value="true") boolean calcPoints, @QueryParam(value="elevation") @DefaultValue(value="false") boolean enableElevation, @QueryParam(value="points_encoded") @DefaultValue(value="true") boolean pointsEncoded, @QueryParam(value="points_encoded_multiplier") @DefaultValue(value="1e5") double pointsEncodedMultiplier, @QueryParam(value="profile") String profileName, @QueryParam(value="algorithm") @DefaultValue(value="") String algoStr, @QueryParam(value="locale") @DefaultValue(value="en") String localeStr, @QueryParam(value="point_hint") List<String> pointHints, @QueryParam(value="curbside") List<String> curbsides, @QueryParam(value="snap_prevention") List<String> snapPreventions, @QueryParam(value="details") List<String> pathDetails, @QueryParam(value="heading") @NotNull List<Double> headings, @QueryParam(value="gpx.route") @DefaultValue(value="true") boolean withRoute, @QueryParam(value="gpx.track") @DefaultValue(value="true") boolean withTrack, @QueryParam(value="gpx.waypoints") @DefaultValue(value="false") boolean withWayPoints, @QueryParam(value="gpx.trackname") @DefaultValue(value="GraphHopper Track") String trackName, @QueryParam(value="gpx.millis") String timeString) {
        StopWatch sw = new StopWatch().start();
        List<GHPoint> points = pointParams.stream().map(AbstractParam::get).collect(Collectors.toList());
        boolean writeGPX = "gpx".equalsIgnoreCase(type);
        boolean bl = instructions = writeGPX || instructions;
        if (enableElevation && !this.hasElevation.booleanValue()) {
            throw new IllegalArgumentException("Elevation not supported!");
        }
        GHRequest request = new GHRequest();
        RouteResource.initHints(request.getHints(), uriInfo.getQueryParameters());
        if (minPathElevationPrecision != null) {
            request.getHints().putObject("elevation_way_point_max_distance", minPathElevationPrecision);
        }
        request.setPoints(points).setProfile(profileName).setAlgorithm(algoStr).setLocale(localeStr).setHeadings(headings).setPointHints(pointHints).setCurbsides(curbsides).setPathDetails(pathDetails).getHints().putObject("calc_points", calcPoints).putObject("instructions", instructions).putObject("way_point_max_distance", minPathPrecision);
        if (uriInfo.getQueryParameters().containsKey("snap_prevention")) {
            if (snapPreventions.size() == 1 && snapPreventions.contains("")) {
                request.setSnapPreventions(List.of());
            } else {
                request.setSnapPreventions(snapPreventions);
            }
        } else {
            request.setSnapPreventions(this.snapPreventionsDefault);
        }
        request = this.ghRequestTransformer.transformRequest(request);
        PMap profileResolverHints = new PMap(request.getHints());
        profileResolverHints.putObject("profile", profileName);
        profileResolverHints.putObject("has_curbsides", !curbsides.isEmpty());
        profileName = this.profileResolver.resolveProfile(profileResolverHints);
        RouteResource.removeLegacyParameters(request.getHints());
        request.setProfile(profileName);
        GHResponse ghResponse = this.graphHopper.route(request);
        double took = sw.stop().getMillisDouble();
        String logStr = httpReq.getRemoteAddr() + " " + String.valueOf(httpReq.getLocale()) + " " + httpReq.getHeader("User-Agent") + " " + String.valueOf(points) + ", took: " + String.format("%.1f", took) + "ms, algo: " + algoStr + ", profile: " + profileName;
        if (ghResponse.hasErrors()) {
            logger.info(logStr + " " + String.valueOf(ghResponse));
            return Response.status(Response.Status.BAD_REQUEST).entity(new MultiException(ghResponse.getErrors())).type(writeGPX ? "application/gpx+xml" : "application/json").build();
        }
        logger.info(logStr + ", alternatives: " + ghResponse.getAll().size() + ", distance0: " + ghResponse.getBest().getDistance() + ", weight0: " + ghResponse.getBest().getRouteWeight() + ", time0: " + Math.round((float)ghResponse.getBest().getTime() / 60000.0f) + "min, points0: " + ghResponse.getBest().getPoints().size() + ", debugInfo: " + ghResponse.getDebugInfo());
        return writeGPX ? RouteResource.gpxSuccessResponseBuilder(ghResponse, timeString, trackName, enableElevation, withRoute, withTrack, withWayPoints, Constants.VERSION).header("X-GH-Took", "" + Math.round(took)).build() : Response.ok(ResponsePathSerializer.jsonObject(ghResponse, new ResponsePathSerializer.Info(this.config.getCopyrights(), Math.round(took), this.osmDate), instructions, calcPoints, enableElevation, pointsEncoded, pointsEncodedMultiplier)).header("X-GH-Took", "" + Math.round(took)).type("application/json").build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response doPost(@NotNull GHRequest request, @Context HttpServletRequest httpReq) {
        if (!request.hasSnapPreventions()) {
            request.setSnapPreventions(this.snapPreventionsDefault);
        }
        StopWatch sw = new StopWatch().start();
        if (Helper.isEmpty((request = this.ghRequestTransformer.transformRequest(request)).getProfile()) && request.getCustomModel() != null) {
            throw new IllegalArgumentException("The 'profile' parameter is required when you use the `custom_model` parameter");
        }
        PMap profileResolverHints = new PMap(request.getHints());
        profileResolverHints.putObject("profile", request.getProfile());
        profileResolverHints.putObject("has_curbsides", !request.getCurbsides().isEmpty());
        request.setProfile(this.profileResolver.resolveProfile(profileResolverHints));
        RouteResource.removeLegacyParameters(request.getHints());
        GHResponse ghResponse = this.graphHopper.route(request);
        boolean instructions = request.getHints().getBool("instructions", true);
        boolean enableElevation = request.getHints().getBool("elevation", false);
        boolean calcPoints = request.getHints().getBool("calc_points", true);
        boolean pointsEncoded = request.getHints().getBool("points_encoded", true);
        double pointsEncodedMultiplier = request.getHints().getDouble("points_encoded_multiplier", 100000.0);
        double took = sw.stop().getMillisDouble();
        String infoStr = httpReq.getRemoteAddr() + " " + String.valueOf(httpReq.getLocale()) + " " + httpReq.getHeader("User-Agent");
        String logStr = infoStr + " " + request.getPoints().size() + ", took: " + String.format("%.1f", took) + " ms, algo: " + request.getAlgorithm() + ", profile: " + request.getProfile() + ", custom_model: " + String.valueOf(request.getCustomModel());
        if (ghResponse.hasErrors()) {
            throw new MultiException(ghResponse.getErrors());
        }
        logger.info(logStr + ", alternatives: " + ghResponse.getAll().size() + ", distance0: " + ghResponse.getBest().getDistance() + ", weight0: " + ghResponse.getBest().getRouteWeight() + ", time0: " + Math.round((float)ghResponse.getBest().getTime() / 60000.0f) + "min, points0: " + ghResponse.getBest().getPoints().size() + ", debugInfo: " + ghResponse.getDebugInfo());
        return Response.ok(ResponsePathSerializer.jsonObject(ghResponse, new ResponsePathSerializer.Info(this.config.getCopyrights(), Math.round(took), this.osmDate), instructions, calcPoints, enableElevation, pointsEncoded, pointsEncodedMultiplier)).header("X-GH-Took", "" + Math.round(took)).type("application/json").build();
    }

    public static void removeLegacyParameters(PMap hints) {
        hints.remove("weighting");
        hints.remove("vehicle");
        hints.remove("edge_based");
        hints.remove("turn_costs");
    }

    private static Response.ResponseBuilder gpxSuccessResponseBuilder(GHResponse ghRsp, String timeString, String trackName, boolean enableElevation, boolean withRoute, boolean withTrack, boolean withWayPoints, String version) {
        if (ghRsp.getAll().size() > 1) {
            throw new IllegalArgumentException("Alternatives are currently not yet supported for GPX");
        }
        long time = timeString != null ? Long.parseLong(timeString) : System.currentTimeMillis();
        InstructionList instructions = ghRsp.getBest().getInstructions();
        return Response.ok((Object)GpxConversions.createGPX(instructions, trackName, time, enableElevation, withRoute, withTrack, withWayPoints, version, instructions.getTr()), "application/gpx+xml").header("Content-Disposition", "attachment;filename=GraphHopper.gpx");
    }

    public static void initHints(PMap m4, MultivaluedMap<String, String> parameterMap) {
        for (Map.Entry e : parameterMap.entrySet()) {
            if (((List)e.getValue()).size() != 1) continue;
            m4.putObject(Helper.camelCaseToUnderScore((String)e.getKey()), Helper.toObject((String)((List)e.getValue()).get(0)));
        }
    }
}

