/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing;

import com.carrotsearch.hppc.IntObjectMap;
import com.graphhopper.coll.GHIntObjectHashMap;
import com.graphhopper.routing.EdgeToEdgeRoutingAlgorithm;
import com.graphhopper.routing.Path;
import com.graphhopper.routing.SPTEntry;
import com.graphhopper.routing.util.TraversalMode;
import java.util.Collections;
import java.util.List;
import java.util.PriorityQueue;

public abstract class AbstractBidirAlgo
implements EdgeToEdgeRoutingAlgorithm {
    protected final TraversalMode traversalMode;
    protected int from;
    protected int to;
    protected int fromOutEdge;
    protected int toInEdge;
    protected IntObjectMap<SPTEntry> bestWeightMapFrom;
    protected IntObjectMap<SPTEntry> bestWeightMapTo;
    protected IntObjectMap<SPTEntry> bestWeightMapOther;
    protected SPTEntry currFrom;
    protected SPTEntry currTo;
    protected SPTEntry bestFwdEntry;
    protected SPTEntry bestBwdEntry;
    protected double bestWeight = Double.MAX_VALUE;
    protected int maxVisitedNodes = Integer.MAX_VALUE;
    protected long timeoutMillis = Long.MAX_VALUE;
    private long finishTimeMillis = Long.MAX_VALUE;
    PriorityQueue<SPTEntry> pqOpenSetFrom;
    PriorityQueue<SPTEntry> pqOpenSetTo;
    protected boolean updateBestPath = true;
    protected boolean finishedFrom;
    protected boolean finishedTo;
    int visitedCountFrom;
    int visitedCountTo;
    private boolean alreadyRun;

    public AbstractBidirAlgo(TraversalMode traversalMode) {
        this.traversalMode = traversalMode;
        this.fromOutEdge = -2;
        this.toInEdge = -2;
    }

    protected void initCollections(int size) {
        this.pqOpenSetFrom = new PriorityQueue(size);
        this.bestWeightMapFrom = new GHIntObjectHashMap<SPTEntry>(size);
        this.pqOpenSetTo = new PriorityQueue(size);
        this.bestWeightMapTo = new GHIntObjectHashMap<SPTEntry>(size);
    }

    protected abstract SPTEntry createStartEntry(int var1, double var2, boolean var4);

    @Override
    public List<Path> calcPaths(int from, int to) {
        return Collections.singletonList(this.calcPath(from, to));
    }

    @Override
    public Path calcPath(int from, int to) {
        return this.calcPath(from, to, -2, -2);
    }

    @Override
    public Path calcPath(int from, int to, int fromOutEdge, int toInEdge) {
        if (!(fromOutEdge == -2 && toInEdge == -2 || this.traversalMode.isEdgeBased())) {
            throw new IllegalArgumentException("Restricting the start/target edges is only possible for edge-based graph traversal");
        }
        this.fromOutEdge = fromOutEdge;
        this.toInEdge = toInEdge;
        this.checkAlreadyRun();
        this.setupFinishTime();
        this.init(from, 0.0, to, 0.0);
        this.runAlgo();
        return this.extractPath();
    }

    void init(int from, double fromWeight, int to, double toWeight) {
        this.initFrom(from, fromWeight);
        this.initTo(to, toWeight);
        this.postInit(from, to);
    }

    protected void initFrom(int from, double weight) {
        this.from = from;
        this.currFrom = this.createStartEntry(from, weight, false);
        this.pqOpenSetFrom.add(this.currFrom);
        if (!this.traversalMode.isEdgeBased()) {
            this.bestWeightMapFrom.put(from, this.currFrom);
        }
    }

    protected void initTo(int to, double weight) {
        this.to = to;
        this.currTo = this.createStartEntry(to, weight, true);
        this.pqOpenSetTo.add(this.currTo);
        if (!this.traversalMode.isEdgeBased()) {
            this.bestWeightMapTo.put(to, this.currTo);
        }
    }

    protected void postInit(int from, int to) {
        if (!this.traversalMode.isEdgeBased()) {
            if (this.updateBestPath) {
                this.bestWeightMapOther = this.bestWeightMapFrom;
                this.updateBestPath(Double.POSITIVE_INFINITY, this.currFrom, -1, to, true);
            }
        } else if (from == to && this.fromOutEdge == -2 && this.toInEdge == -2) {
            if (this.currFrom.weight != 0.0 || this.currTo.weight != 0.0) {
                throw new IllegalStateException("If from=to, the starting weight must be zero for from and to");
            }
            this.bestFwdEntry = this.currFrom;
            this.bestBwdEntry = this.currTo;
            this.bestWeight = 0.0;
            this.finishedFrom = true;
            this.finishedTo = true;
            return;
        }
        this.postInitFrom();
        this.postInitTo();
    }

    protected abstract void postInitFrom();

    protected abstract void postInitTo();

    protected void runAlgo() {
        while (!(this.finished() || this.isMaxVisitedNodesExceeded() || this.isTimeoutExceeded())) {
            if (!this.finishedFrom) {
                boolean bl = this.finishedFrom = !this.fillEdgesFrom();
            }
            if (this.finishedTo) continue;
            this.finishedTo = !this.fillEdgesTo();
        }
    }

    protected boolean finished() {
        if (this.finishedFrom || this.finishedTo) {
            return true;
        }
        return this.currFrom.weight + this.currTo.weight >= this.bestWeight;
    }

    abstract boolean fillEdgesFrom();

    abstract boolean fillEdgesTo();

    protected void updateBestPath(double edgeWeight, SPTEntry entry, int origEdgeIdForCH, int traversalId, boolean reverse) {
        assert (this.traversalMode.isEdgeBased() != Double.isInfinite(edgeWeight));
        SPTEntry entryOther = this.bestWeightMapOther.get(traversalId);
        if (entryOther == null) {
            return;
        }
        double weight = entry.getWeightOfVisitedPath() + entryOther.getWeightOfVisitedPath();
        if (this.traversalMode.isEdgeBased()) {
            if (this.getIncomingEdge(entryOther) != this.getIncomingEdge(entry)) {
                throw new IllegalStateException("cannot happen for edge based execution of " + this.getName());
            }
            entry = entry.getParent();
            weight -= edgeWeight;
        }
        if (weight < this.bestWeight) {
            this.bestFwdEntry = reverse ? entryOther : entry;
            this.bestBwdEntry = reverse ? entry : entryOther;
            this.bestWeight = weight;
        }
    }

    protected abstract double getInEdgeWeight(SPTEntry var1);

    protected int getIncomingEdge(SPTEntry entry) {
        return entry.edge;
    }

    protected abstract Path extractPath();

    protected boolean fromEntryCanBeSkipped() {
        return false;
    }

    protected boolean fwdSearchCanBeStopped() {
        return false;
    }

    protected boolean toEntryCanBeSkipped() {
        return false;
    }

    protected boolean bwdSearchCanBeStopped() {
        return false;
    }

    protected double getCurrentFromWeight() {
        return this.currFrom.weight;
    }

    protected double getCurrentToWeight() {
        return this.currTo.weight;
    }

    IntObjectMap<SPTEntry> getBestFromMap() {
        return this.bestWeightMapFrom;
    }

    IntObjectMap<SPTEntry> getBestToMap() {
        return this.bestWeightMapTo;
    }

    void setBestOtherMap(IntObjectMap<SPTEntry> other) {
        this.bestWeightMapOther = other;
    }

    protected void setUpdateBestPath(boolean b) {
        this.updateBestPath = b;
    }

    @Override
    public int getVisitedNodes() {
        return this.visitedCountFrom + this.visitedCountTo;
    }

    void setToDataStructures(AbstractBidirAlgo other) {
        this.to = other.to;
        this.toInEdge = other.toInEdge;
        this.pqOpenSetTo = other.pqOpenSetTo;
        this.bestWeightMapTo = other.bestWeightMapTo;
        this.finishedTo = other.finishedTo;
        this.currTo = other.currTo;
        this.visitedCountTo = other.visitedCountTo;
    }

    @Override
    public void setMaxVisitedNodes(int numberOfNodes) {
        this.maxVisitedNodes = numberOfNodes;
    }

    @Override
    public void setTimeoutMillis(long timeoutMillis) {
        this.timeoutMillis = timeoutMillis;
    }

    protected void checkAlreadyRun() {
        if (this.alreadyRun) {
            throw new IllegalStateException("Create a new instance per call");
        }
        this.alreadyRun = true;
    }

    protected void setupFinishTime() {
        try {
            this.finishTimeMillis = Math.addExact(System.currentTimeMillis(), this.timeoutMillis);
        }
        catch (ArithmeticException e) {
            this.finishTimeMillis = Long.MAX_VALUE;
        }
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    protected boolean isMaxVisitedNodesExceeded() {
        return this.maxVisitedNodes < this.getVisitedNodes();
    }

    protected boolean isTimeoutExceeded() {
        return this.finishTimeMillis < Long.MAX_VALUE && System.currentTimeMillis() > this.finishTimeMillis;
    }
}

