/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing;

import com.carrotsearch.hppc.IntIndexedContainer;
import com.graphhopper.routing.DijkstraBidirectionCH;
import com.graphhopper.routing.DijkstraBidirectionCHNoSOD;
import com.graphhopper.routing.Path;
import com.graphhopper.routing.SPTEntry;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.RoutingCHGraph;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.PMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class AlternativeRouteCH
extends DijkstraBidirectionCHNoSOD {
    private final double maxWeightFactor;
    private final double maxShareFactor;
    private final double localOptimalityFactor;
    private final int maxPaths;
    private final List<AlternativeInfo> alternatives = new ArrayList<AlternativeInfo>();
    private int extraVisitedNodes = 0;

    public AlternativeRouteCH(RoutingCHGraph graph, PMap hints) {
        super(graph);
        this.maxWeightFactor = hints.getDouble("alternative_route.max_weight_factor", 1.25);
        this.maxShareFactor = hints.getDouble("alternative_route.max_share_factor", 0.8);
        this.localOptimalityFactor = hints.getDouble("alternative_route.local_optimality_factor", 0.25);
        this.maxPaths = hints.getInt("alternative_route.max_paths", 3);
    }

    @Override
    public boolean finished() {
        if (this.finishedFrom && this.finishedTo) {
            return true;
        }
        return this.currFrom.weight >= this.bestWeight * this.maxWeightFactor && this.currTo.weight >= this.bestWeight * this.maxWeightFactor;
    }

    @Override
    public int getVisitedNodes() {
        return this.visitedCountFrom + this.visitedCountTo + this.extraVisitedNodes;
    }

    List<AlternativeInfo> calcAlternatives(int s2, int t2) {
        this.checkAlreadyRun();
        this.init(s2, 0.0, t2, 0.0);
        this.runAlgo();
        Path bestPath = this.extractPath();
        if (!bestPath.isFound()) {
            return Collections.emptyList();
        }
        this.alternatives.add(new AlternativeInfo(bestPath, 0.0));
        ArrayList<PotentialAlternativeInfo> potentialAlternativeInfos = new ArrayList<PotentialAlternativeInfo>();
        this.bestWeightMapFrom.forEach((v, fromSPTEntry) -> {
            SPTEntry toSPTEntry = (SPTEntry)this.bestWeightMapTo.get(v);
            if (toSPTEntry == null) {
                return true;
            }
            if (fromSPTEntry.getWeightOfVisitedPath() + toSPTEntry.getWeightOfVisitedPath() > bestPath.getWeight() * this.maxWeightFactor) {
                return true;
            }
            Path preliminaryRoute = this.createPathExtractor().extract((SPTEntry)fromSPTEntry, toSPTEntry, fromSPTEntry.getWeightOfVisitedPath() + toSPTEntry.getWeightOfVisitedPath());
            double preliminaryShare = this.calculateShare(preliminaryRoute);
            if (preliminaryShare > this.maxShareFactor) {
                return true;
            }
            PotentialAlternativeInfo potentialAlternativeInfo = new PotentialAlternativeInfo();
            potentialAlternativeInfo.v = v;
            potentialAlternativeInfo.weight = 2.0 * (fromSPTEntry.getWeightOfVisitedPath() + toSPTEntry.getWeightOfVisitedPath()) + preliminaryShare;
            potentialAlternativeInfos.add(potentialAlternativeInfo);
            return true;
        });
        potentialAlternativeInfos.sort(Comparator.comparingDouble(o -> o.weight));
        for (PotentialAlternativeInfo potentialAlternativeInfo : potentialAlternativeInfos) {
            IntIndexedContainer svNodes;
            int vIndex;
            double share;
            double directLength;
            int v2 = potentialAlternativeInfo.v;
            DijkstraBidirectionCH svRouter = new DijkstraBidirectionCH(this.graph);
            svRouter.setPathExtractorSupplier(this::createPathExtractor);
            Path svPath = svRouter.calcPath(s2, v2);
            this.extraVisitedNodes += svRouter.getVisitedNodes();
            DijkstraBidirectionCH vtRouter = new DijkstraBidirectionCH(this.graph);
            vtRouter.setPathExtractorSupplier(this::createPathExtractor);
            Path vtPath = vtRouter.calcPath(v2, t2);
            Path path = AlternativeRouteCH.concat(this.graph.getBaseGraph(), svPath, vtPath);
            this.extraVisitedNodes += vtRouter.getVisitedNodes();
            double sharedDistanceWithShortest = this.sharedDistanceWithShortest(path);
            double detourLength = path.getDistance() - sharedDistanceWithShortest;
            if (detourLength > (directLength = bestPath.getDistance() - sharedDistanceWithShortest) * this.maxWeightFactor || (share = this.calculateShare(path)) > this.maxShareFactor || !this.tTest(path, vIndex = (svNodes = svPath.calcNodes()).size() - 1)) continue;
            this.alternatives.add(new AlternativeInfo(path, share));
            if (this.alternatives.size() < this.maxPaths) continue;
            break;
        }
        return this.alternatives;
    }

    private double calculateShare(Path path) {
        double sharedDistance = this.sharedDistance(path);
        return sharedDistance / path.getDistance();
    }

    private double sharedDistance(Path path) {
        double sharedDistance = 0.0;
        List<EdgeIteratorState> edges = path.calcEdges();
        for (EdgeIteratorState edge : edges) {
            if (!this.nodesInCurrentAlternativeSetContains(edge.getBaseNode()) || !this.nodesInCurrentAlternativeSetContains(edge.getAdjNode())) continue;
            sharedDistance += edge.getDistance();
        }
        return sharedDistance;
    }

    private double sharedDistanceWithShortest(Path path) {
        double sharedDistance = 0.0;
        List<EdgeIteratorState> edges = path.calcEdges();
        for (EdgeIteratorState edge : edges) {
            if (!this.alternatives.get((int)0).nodes.contains(edge.getBaseNode()) || !this.alternatives.get((int)0).nodes.contains(edge.getAdjNode())) continue;
            sharedDistance += edge.getDistance();
        }
        return sharedDistance;
    }

    private boolean nodesInCurrentAlternativeSetContains(int v) {
        for (AlternativeInfo alternative : this.alternatives) {
            if (!alternative.nodes.contains(v)) continue;
            return true;
        }
        return false;
    }

    private boolean tTest(Path path, int vIndex) {
        if (path.getEdgeCount() == 0) {
            return true;
        }
        double detourDistance = this.detourDistance(path);
        double T = 0.5 * this.localOptimalityFactor * detourDistance;
        int fromNode = this.getPreviousNodeTMetersAway(path, vIndex, T);
        int toNode = this.getNextNodeTMetersAway(path, vIndex, T);
        DijkstraBidirectionCH tRouter = new DijkstraBidirectionCH(this.graph);
        tRouter.setPathExtractorSupplier(this::createPathExtractor);
        Path tPath = tRouter.calcPath(fromNode, toNode);
        this.extraVisitedNodes += tRouter.getVisitedNodes();
        IntIndexedContainer tNodes = tPath.calcNodes();
        int v = path.calcNodes().get(vIndex);
        return tNodes.contains(v);
    }

    private double detourDistance(Path path) {
        return path.getDistance() - this.sharedDistanceWithShortest(path);
    }

    private int getPreviousNodeTMetersAway(Path path, int vIndex, double T) {
        int i;
        List<EdgeIteratorState> edges = path.calcEdges();
        double distance = 0.0;
        for (i = vIndex; i > 0 && distance < T; distance += edges.get(i - 1).getDistance(), --i) {
        }
        return edges.get(i).getBaseNode();
    }

    private int getNextNodeTMetersAway(Path path, int vIndex, double T) {
        int i;
        List<EdgeIteratorState> edges = path.calcEdges();
        double distance = 0.0;
        for (i = vIndex; i < edges.size() - 1 && distance < T; distance += edges.get(i).getDistance(), ++i) {
        }
        return edges.get(i - 1).getAdjNode();
    }

    private static Path concat(Graph graph, Path svPath, Path vtPath) {
        Path path = new Path(graph);
        path.getEdges().addAll(svPath.getEdges());
        path.getEdges().addAll(vtPath.getEdges());
        path.setFromNode(svPath.calcNodes().get(0));
        path.setEndNode(vtPath.getEndNode());
        path.setWeight(svPath.getWeight() + vtPath.getWeight());
        path.setDistance(svPath.getDistance() + vtPath.getDistance());
        path.addTime(svPath.getTime() + vtPath.getTime());
        path.setFound(true);
        return path;
    }

    @Override
    public List<Path> calcPaths(int from, int to) {
        List<AlternativeInfo> alts = this.calcAlternatives(from, to);
        if (alts.isEmpty()) {
            return Collections.singletonList(this.createEmptyPath());
        }
        ArrayList<Path> paths = new ArrayList<Path>(alts.size());
        for (AlternativeInfo a : alts) {
            paths.add(a.path);
        }
        return paths;
    }

    public static class AlternativeInfo {
        final double shareWeight;
        final Path path;
        final IntIndexedContainer nodes;

        AlternativeInfo(Path path, double shareWeight) {
            this.path = path;
            this.shareWeight = shareWeight;
            this.nodes = path.calcNodes();
        }

        public String toString() {
            return "AlternativeInfo{shareWeight=" + this.shareWeight + ", path=" + String.valueOf(this.path.calcNodes()) + "}";
        }

        public Path getPath() {
            return this.path;
        }
    }

    public static class PotentialAlternativeInfo {
        int v;
        double weight;
    }
}

