/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing;

import com.carrotsearch.hppc.IntObjectMap;
import com.graphhopper.coll.GHIntObjectHashMap;
import com.graphhopper.routing.AbstractRoutingAlgorithm;
import com.graphhopper.routing.Path;
import com.graphhopper.routing.PathExtractor;
import com.graphhopper.routing.SPTEntry;
import com.graphhopper.routing.util.TraversalMode;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.Graph;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.GHUtility;
import java.util.PriorityQueue;

public class Dijkstra
extends AbstractRoutingAlgorithm {
    protected IntObjectMap<SPTEntry> fromMap;
    protected PriorityQueue<SPTEntry> fromHeap;
    protected SPTEntry currEdge;
    private int visitedNodes;
    private int to = -1;

    public Dijkstra(Graph graph, Weighting weighting, TraversalMode tMode) {
        super(graph, weighting, tMode);
        int size = Math.min(Math.max(200, graph.getNodes() / 10), 2000);
        this.initCollections(size);
    }

    protected void initCollections(int size) {
        this.fromHeap = new PriorityQueue(size);
        this.fromMap = new GHIntObjectHashMap<SPTEntry>(size);
    }

    @Override
    public Path calcPath(int from, int to) {
        this.checkAlreadyRun();
        this.setupFinishTime();
        this.to = to;
        SPTEntry startEntry = new SPTEntry(from, 0.0);
        this.fromHeap.add(startEntry);
        if (!this.traversalMode.isEdgeBased()) {
            this.fromMap.put(from, this.currEdge);
        }
        this.runAlgo();
        return this.extractPath();
    }

    protected void runAlgo() {
        while (!this.fromHeap.isEmpty()) {
            this.currEdge = this.fromHeap.poll();
            if (this.currEdge.isDeleted()) continue;
            ++this.visitedNodes;
            if (this.isMaxVisitedNodesExceeded() || this.finished() || this.isTimeoutExceeded()) break;
            int currNode = this.currEdge.adjNode;
            EdgeIterator iter = this.edgeExplorer.setBaseNode(currNode);
            while (iter.next()) {
                double tmpWeight;
                if (!this.accept(iter, this.currEdge.edge) || Double.isInfinite(tmpWeight = GHUtility.calcWeightWithTurnWeight(this.weighting, iter, false, this.currEdge.edge) + this.currEdge.weight)) continue;
                int traversalId = this.traversalMode.createTraversalId(iter, false);
                SPTEntry nEdge = this.fromMap.get(traversalId);
                if (nEdge == null) {
                    nEdge = new SPTEntry(iter.getEdge(), iter.getAdjNode(), tmpWeight, this.currEdge);
                    this.fromMap.put(traversalId, nEdge);
                    this.fromHeap.add(nEdge);
                } else {
                    if (!(nEdge.weight > tmpWeight)) continue;
                    nEdge.setDeleted();
                    nEdge = new SPTEntry(iter.getEdge(), iter.getAdjNode(), tmpWeight, this.currEdge);
                    this.fromMap.put(traversalId, nEdge);
                    this.fromHeap.add(nEdge);
                }
                this.updateBestPath(iter, nEdge, traversalId);
            }
        }
    }

    protected boolean finished() {
        return this.currEdge.adjNode == this.to;
    }

    private Path extractPath() {
        if (this.currEdge == null || !this.finished()) {
            return this.createEmptyPath();
        }
        return PathExtractor.extractPath(this.graph, this.weighting, this.currEdge);
    }

    @Override
    public int getVisitedNodes() {
        return this.visitedNodes;
    }

    protected void updateBestPath(EdgeIteratorState edgeState, SPTEntry bestSPTEntry, int traversalId) {
    }

    @Override
    public String getName() {
        return "dijkstra";
    }
}

