/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing;

import com.graphhopper.routing.AStar;
import com.graphhopper.routing.AStarBidirection;
import com.graphhopper.routing.AlgorithmOptions;
import com.graphhopper.routing.AlternativeRoute;
import com.graphhopper.routing.Dijkstra;
import com.graphhopper.routing.DijkstraBidirectionRef;
import com.graphhopper.routing.DijkstraOneToMany;
import com.graphhopper.routing.RoutingAlgorithm;
import com.graphhopper.routing.RoutingAlgorithmFactory;
import com.graphhopper.routing.weighting.BeelineWeightApproximator;
import com.graphhopper.routing.weighting.WeightApproximator;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.util.DistanceCalcEarth;
import com.graphhopper.util.DistancePlaneProjection;
import com.graphhopper.util.Helper;
import com.graphhopper.util.PMap;

public class RoutingAlgorithmFactorySimple
implements RoutingAlgorithmFactory {
    @Override
    public RoutingAlgorithm createAlgo(Graph g2, Weighting w, AlgorithmOptions opts) {
        RoutingAlgorithm ra;
        String algoStr = opts.getAlgorithm();
        Weighting weighting = g2.wrapWeighting(w);
        if ("dijkstrabi".equalsIgnoreCase(algoStr)) {
            ra = new DijkstraBidirectionRef(g2, weighting, opts.getTraversalMode());
        } else if ("dijkstra".equalsIgnoreCase(algoStr)) {
            ra = new Dijkstra(g2, weighting, opts.getTraversalMode());
        } else if ("astarbi".equalsIgnoreCase(algoStr) || Helper.isEmpty(algoStr)) {
            AStarBidirection aStarBi = new AStarBidirection(g2, weighting, opts.getTraversalMode());
            aStarBi.setApproximation(RoutingAlgorithmFactorySimple.getApproximation("astarbi", opts.getHints(), weighting, g2.getNodeAccess()));
            ra = aStarBi;
        } else if ("dijkstra_one_to_many".equalsIgnoreCase(algoStr)) {
            ra = new DijkstraOneToMany(g2, weighting, opts.getTraversalMode());
        } else if ("astar".equalsIgnoreCase(algoStr)) {
            AStar aStar = new AStar(g2, weighting, opts.getTraversalMode());
            aStar.setApproximation(RoutingAlgorithmFactorySimple.getApproximation("astar", opts.getHints(), w, g2.getNodeAccess()));
            ra = aStar;
        } else if ("alternative_route".equalsIgnoreCase(algoStr)) {
            ra = new AlternativeRoute(g2, weighting, opts.getTraversalMode(), opts.getHints());
        } else {
            throw new IllegalArgumentException("Algorithm " + algoStr + " not found in " + this.getClass().getName());
        }
        ra.setMaxVisitedNodes(opts.getMaxVisitedNodes());
        ra.setTimeoutMillis(opts.getTimeoutMillis());
        return ra;
    }

    public static WeightApproximator getApproximation(String prop, PMap opts, Weighting weighting, NodeAccess na) {
        String approxAsStr = opts.getString(prop + ".approximation", "BeelineSimplification");
        double epsilon = opts.getDouble(prop + ".epsilon", 1.0);
        BeelineWeightApproximator approx = new BeelineWeightApproximator(na, weighting);
        approx.setEpsilon(epsilon);
        if ("BeelineSimplification".equals(approxAsStr)) {
            approx.setDistanceCalc(DistancePlaneProjection.DIST_PLANE);
        } else if ("BeelineAccurate".equals(approxAsStr)) {
            approx.setDistanceCalc(DistanceCalcEarth.DIST_EARTH);
        } else {
            throw new IllegalArgumentException("Approximation " + approxAsStr + " not found in " + RoutingAlgorithmFactorySimple.class.getName());
        }
        return approx;
    }
}

