/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing;

import com.graphhopper.config.Profile;
import com.graphhopper.json.Statement;
import com.graphhopper.util.CustomModel;

public class TestProfiles {
    public static Profile constantSpeed(String name) {
        return TestProfiles.constantSpeed(name, 60.0);
    }

    public static Profile constantSpeed(String name, double speed) {
        Profile profile = new Profile(name);
        CustomModel customModel = new CustomModel();
        customModel.addToSpeed(Statement.If("true", Statement.Op.LIMIT, String.valueOf(speed)));
        profile.setCustomModel(customModel);
        return profile;
    }

    public static Profile accessAndSpeed(String vehicle) {
        return TestProfiles.accessAndSpeed(vehicle, vehicle);
    }

    public static Profile accessAndSpeed(String name, String vehicle) {
        Profile profile = new Profile(name);
        CustomModel customModel = new CustomModel().addToPriority(Statement.If("!" + vehicle + "_access", Statement.Op.MULTIPLY, "0")).addToSpeed(Statement.If("true", Statement.Op.LIMIT, vehicle + "_average_speed"));
        profile.setCustomModel(customModel);
        return profile;
    }

    public static Profile accessSpeedAndPriority(String vehicle) {
        return TestProfiles.accessSpeedAndPriority(vehicle, vehicle);
    }

    public static Profile accessSpeedAndPriority(String name, String vehicle) {
        Profile profile = new Profile(name);
        CustomModel customModel = new CustomModel().addToPriority(Statement.If(vehicle + "_access", Statement.Op.MULTIPLY, vehicle + "_priority")).addToPriority(Statement.Else(Statement.Op.MULTIPLY, "0")).addToSpeed(Statement.If("true", Statement.Op.LIMIT, vehicle + "_average_speed"));
        profile.setCustomModel(customModel);
        return profile;
    }
}

