/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.ev;

import com.carrotsearch.hppc.IntArrayList;
import com.graphhopper.routing.ev.EdgeIntAccess;

public class ArrayEdgeIntAccess
implements EdgeIntAccess {
    private final int intsPerEdge;
    private final IntArrayList arr = new IntArrayList();

    public ArrayEdgeIntAccess(int intsPerEdge) {
        this.intsPerEdge = intsPerEdge;
    }

    public static ArrayEdgeIntAccess createFromBytes(int bytes) {
        return new ArrayEdgeIntAccess((int)Math.ceil((double)bytes / 4.0));
    }

    @Override
    public int getInt(int edgeId, int index) {
        int arrIndex = edgeId * this.intsPerEdge + index;
        return arrIndex >= this.arr.size() ? 0 : this.arr.get(arrIndex);
    }

    @Override
    public void setInt(int edgeId, int index, int value) {
        int arrIndex = edgeId * this.intsPerEdge + index;
        if (arrIndex >= this.arr.size()) {
            this.arr.resize(arrIndex + 1);
        }
        this.arr.set(arrIndex, value);
    }
}

