/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.ev;

import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.util.Helper;

public enum BikeRoadAccess {
    MISSING,
    YES,
    DISMOUNT,
    DESIGNATED,
    DESTINATION,
    PRIVATE,
    USE_SIDEPATH,
    NO;

    public static final String KEY = "bike_road_access";

    public static EnumEncodedValue<BikeRoadAccess> create() {
        return new EnumEncodedValue<BikeRoadAccess>(KEY, BikeRoadAccess.class);
    }

    public String toString() {
        return Helper.toLowerCase(super.toString());
    }

    public static BikeRoadAccess find(String name) {
        if (name == null || name.isEmpty()) {
            return MISSING;
        }
        if (name.equalsIgnoreCase("permit") || name.equalsIgnoreCase("customers")) {
            return PRIVATE;
        }
        try {
            return BikeRoadAccess.valueOf(Helper.toUpperCase(name));
        }
        catch (IllegalArgumentException ex) {
            return YES;
        }
    }
}

