/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.ev;

import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.State;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum Country {
    MISSING("missing", "---", "--", true, new State[0]),
    AFG("Afghanistan", "AFG", "AF", true, new State[0]),
    AGO("Angola", "AGO", "AO", true, new State[0]),
    AIA("Anguilla", "AIA", "AI", false, new State[0]),
    ALB("Albania", "ALB", "AL", true, new State[0]),
    AND("Andorra", "AND", "AD", true, new State[0]),
    ARE("United Arab Emirates", "ARE", "AE", true, new State[0]),
    ARG("Argentina", "ARG", "AR", true, new State[0]),
    ARM("Armenia", "ARM", "AM", true, new State[0]),
    ATG("Antigua and Barbuda", "ATG", "AG", false, new State[0]),
    AUS("Australia", "AUS", "AU", false, State.AU_ACT, State.AU_NSW, State.AU_NT, State.AU_QLD, State.AU_SA, State.AU_TAS, State.AU_VIC, State.AU_WA),
    AUT("Austria", "AUT", "AT", true, new State[0]),
    AZE("Azerbaijan", "AZE", "AZ", true, new State[0]),
    BDI("Burundi", "BDI", "BI", true, new State[0]),
    BEL("Belgium", "BEL", "BE", true, new State[0]),
    BEN("Benin", "BEN", "BJ", true, new State[0]),
    BFA("Burkina Faso", "BFA", "BF", true, new State[0]),
    BGD("Bangladesh", "BGD", "BD", true, new State[0]),
    BGR("Bulgaria", "BGR", "BG", true, new State[0]),
    BHR("Bahrain", "BHR", "BH", true, new State[0]),
    BHS("The Bahamas", "BHS", "BS", false, new State[0]),
    BIH("Bosnia and Herzegovina", "BIH", "BA", true, new State[0]),
    BLR("Belarus", "BLR", "BY", true, new State[0]),
    BLZ("Belize", "BLZ", "BZ", true, new State[0]),
    BMU("Bermuda", "BMU", "BM", true, new State[0]),
    BOL("Bolivia", "BOL", "BO", true, new State[0]),
    BRA("Brazil", "BRA", "BR", true, new State[0]),
    BRB("Barbados", "BRB", "BB", false, new State[0]),
    BRN("Brunei", "BRN", "BN", true, new State[0]),
    BTN("Bhutan", "BTN", "BT", false, new State[0]),
    BWA("Botswana", "BWA", "BW", false, new State[0]),
    CAF("Central African Republic", "CAF", "CF", true, new State[0]),
    CAN("Canada", "CAN", "CA", true, State.CA_AB, State.CA_BC, State.CA_MB, State.CA_NB, State.CA_NL, State.CA_NS, State.CA_NT, State.CA_NU, State.CA_ON, State.CA_PE, State.CA_QC, State.CA_SK, State.CA_YT),
    CHE("Switzerland", "CHE", "CH", true, new State[0]),
    CHL("Chile", "CHL", "CL", true, new State[0]),
    CHN("China", "CHN", "CN", true, new State[0]),
    CIV("C\u00f4te d'Ivoire", "CIV", "CI", true, new State[0]),
    CMR("Cameroon", "CMR", "CM", true, new State[0]),
    COD("Democratic Republic of the Congo", "COD", "CD", true, new State[0]),
    COG("Congo-Brazzaville", "COG", "CG", true, new State[0]),
    COK("Cook Islands", "COK", "CK", true, new State[0]),
    COL("Colombia", "COL", "CO", true, new State[0]),
    COM("Comoros", "COM", "KM", true, new State[0]),
    CPV("Cape Verde", "CPV", "CV", true, new State[0]),
    CRI("Costa Rica", "CRI", "CR", true, new State[0]),
    CUB("Cuba", "CUB", "CU", true, new State[0]),
    CYM("Cayman Islands", "CYM", "KY", false, new State[0]),
    CYP("Cyprus", "CYP", "CY", false, new State[0]),
    CZE("Czechia", "CZE", "CZ", true, new State[0]),
    DEU("Germany", "DEU", "DE", true, new State[0]),
    DJI("Djibouti", "DJI", "DJ", true, new State[0]),
    DMA("Dominica", "DMA", "DM", false, new State[0]),
    DNK("Denmark", "DNK", "DK", true, new State[0]),
    DOM("Dominican Republic", "DOM", "DO", true, new State[0]),
    DZA("Algeria", "DZA", "DZ", true, new State[0]),
    ECU("Ecuador", "ECU", "EC", true, new State[0]),
    EGY("Egypt", "EGY", "EG", true, new State[0]),
    ERI("Eritrea", "ERI", "ER", true, new State[0]),
    ESP("Spain", "ESP", "ES", true, new State[0]),
    EST("Estonia", "EST", "EE", true, new State[0]),
    ETH("Ethiopia", "ETH", "ET", true, new State[0]),
    FIN("Finland", "FIN", "FI", true, new State[0]),
    FJI("Fiji", "FJI", "FJ", false, new State[0]),
    FLK("Falkland Islands", "FLK", "FK", false, new State[0]),
    FRA("France", "FRA", "FR", true, new State[0]),
    FRO("Faroe Islands", "FRO", "FO", true, new State[0]),
    FSM("Federated States of Micronesia", "FSM", "FM", true, State.FM_KSA, State.FM_PNI, State.FM_TRK, State.FM_YAP),
    GAB("Gabon", "GAB", "GA", true, new State[0]),
    GBR("United Kingdom", "GBR", "GB", false, new State[0]),
    GEO("Georgia", "GEO", "GE", true, new State[0]),
    GGY("Guernsey", "GGY", "GG", false, new State[0]),
    GHA("Ghana", "GHA", "GH", true, new State[0]),
    GIB("Gibraltar", "GIB", "GI", true, new State[0]),
    GIN("Guinea", "GIN", "GN", true, new State[0]),
    GMB("The Gambia", "GMB", "GM", true, new State[0]),
    GNB("Guinea-Bissau", "GNB", "GW", true, new State[0]),
    GNQ("Equatorial Guinea", "GNQ", "GQ", true, new State[0]),
    GRC("Greece", "GRC", "GR", true, new State[0]),
    GRD("Grenada", "GRD", "GD", false, new State[0]),
    GRL("Greenland", "GRL", "GL", true, new State[0]),
    GTM("Guatemala", "GTM", "GT", true, new State[0]),
    GUY("Guyana", "GUY", "GY", false, new State[0]),
    HND("Honduras", "HND", "HN", true, new State[0]),
    HRV("Croatia", "HRV", "HR", true, new State[0]),
    HTI("Haiti", "HTI", "HT", true, new State[0]),
    HUN("Hungary", "HUN", "HU", true, new State[0]),
    IDN("Indonesia", "IDN", "ID", false, new State[0]),
    IMN("Isle of Man", "IMN", "IM", false, new State[0]),
    IND("India", "IND", "IN", false, new State[0]),
    IOT("British Indian Ocean Territory", "IOT", "IO", true, new State[0]),
    IRL("Ireland", "IRL", "IE", false, new State[0]),
    IRN("Iran", "IRN", "IR", true, new State[0]),
    IRQ("Iraq", "IRQ", "IQ", true, new State[0]),
    ISL("Iceland", "ISL", "IS", true, new State[0]),
    ISR("Israel", "ISR", "IL", true, new State[0]),
    ITA("Italy", "ITA", "IT", true, new State[0]),
    JAM("Jamaica", "JAM", "JM", false, new State[0]),
    JEY("Jersey", "JEY", "JE", false, new State[0]),
    JOR("Jordan", "JOR", "JO", true, new State[0]),
    JPN("Japan", "JPN", "JP", false, new State[0]),
    KAZ("Kazakhstan", "KAZ", "KZ", true, new State[0]),
    KEN("Kenya", "KEN", "KE", false, new State[0]),
    KGZ("Kyrgyzstan", "KGZ", "KG", true, new State[0]),
    KHM("Cambodia", "KHM", "KH", true, new State[0]),
    KIR("Kiribati", "KIR", "KI", false, new State[0]),
    KNA("Saint Kitts and Nevis", "KNA", "KN", false, new State[0]),
    KOR("South Korea", "KOR", "KR", true, new State[0]),
    KWT("Kuwait", "KWT", "KW", true, new State[0]),
    LAO("Laos", "LAO", "LA", true, new State[0]),
    LBN("Lebanon", "LBN", "LB", true, new State[0]),
    LBR("Liberia", "LBR", "LR", true, new State[0]),
    LBY("Libya", "LBY", "LY", true, new State[0]),
    LCA("Saint Lucia", "LCA", "LC", false, new State[0]),
    LIE("Liechtenstein", "LIE", "LI", true, new State[0]),
    LKA("Sri Lanka", "LKA", "LK", false, new State[0]),
    LSO("Lesotho", "LSO", "LS", false, new State[0]),
    LTU("Lithuania", "LTU", "LT", true, new State[0]),
    LUX("Luxembourg", "LUX", "LU", true, new State[0]),
    LVA("Latvia", "LVA", "LV", true, new State[0]),
    MAR("Morocco", "MAR", "MA", true, new State[0]),
    MCO("Monaco", "MCO", "MC", true, new State[0]),
    MDA("Moldova", "MDA", "MD", true, new State[0]),
    MDG("Madagascar", "MDG", "MG", true, new State[0]),
    MDV("Maldives", "MDV", "MV", false, new State[0]),
    MEX("Mexico", "MEX", "MX", true, new State[0]),
    MHL("Marshall Islands", "MHL", "MH", true, new State[0]),
    MKD("North Macedonia", "MKD", "MK", true, new State[0]),
    MLI("Mali", "MLI", "ML", true, new State[0]),
    MLT("Malta", "MLT", "MT", false, new State[0]),
    MMR("Myanmar", "MMR", "MM", true, new State[0]),
    MNE("Montenegro", "MNE", "ME", true, new State[0]),
    MNG("Mongolia", "MNG", "MN", true, new State[0]),
    MOZ("Mozambique", "MOZ", "MZ", false, new State[0]),
    MRT("Mauritania", "MRT", "MR", true, new State[0]),
    MSR("Montserrat", "MSR", "MS", true, new State[0]),
    MUS("Mauritius", "MUS", "MU", false, new State[0]),
    MWI("Malawi", "MWI", "MW", false, new State[0]),
    MYS("Malaysia", "MYS", "MY", false, new State[0]),
    NAM("Namibia", "NAM", "NA", false, new State[0]),
    NER("Niger", "NER", "NE", true, new State[0]),
    NGA("Nigeria", "NGA", "NG", true, new State[0]),
    NIC("Nicaragua", "NIC", "NI", true, new State[0]),
    NIU("Niue", "NIU", "NU", true, new State[0]),
    NLD("Netherlands", "NLD", "NL", true, new State[0]),
    NOR("Norway", "NOR", "NO", true, new State[0]),
    NPL("Nepal", "NPL", "NP", false, new State[0]),
    NRU("Nauru", "NRU", "NR", false, new State[0]),
    NZL("New Zealand", "NZL", "NZ", false, new State[0]),
    OMN("Oman", "OMN", "OM", true, new State[0]),
    PAK("Pakistan", "PAK", "PK", false, new State[0]),
    PAN("Panama", "PAN", "PA", true, new State[0]),
    PCN("Pitcairn Islands", "PCN", "PN", false, new State[0]),
    PER("Peru", "PER", "PE", true, new State[0]),
    PHL("Philippines", "PHL", "PH", true, new State[0]),
    PLW("Palau", "PLW", "PW", true, new State[0]),
    PNG("Papua New Guinea", "PNG", "PG", false, new State[0]),
    POL("Poland", "POL", "PL", true, new State[0]),
    PRK("North Korea", "PRK", "KP", true, new State[0]),
    PRT("Portugal", "PRT", "PT", true, new State[0]),
    PRY("Paraguay", "PRY", "PY", true, new State[0]),
    PSE("Palestinian Territories", "PSE", "PS", true, new State[0]),
    QAT("Qatar", "QAT", "QA", true, new State[0]),
    ROU("Romania", "ROU", "RO", true, new State[0]),
    RUS("Russia", "RUS", "RU", true, new State[0]),
    RWA("Rwanda", "RWA", "RW", true, new State[0]),
    SAU("Saudi Arabia", "SAU", "SA", true, new State[0]),
    SDN("Sudan", "SDN", "SD", true, new State[0]),
    SEN("Senegal", "SEN", "SN", true, new State[0]),
    SGP("Singapore", "SGP", "SG", false, new State[0]),
    SGS("South Georgia and the South Sandwich Islands", "SGS", "GS", true, new State[0]),
    SHN("Saint Helena, Ascension and Tristan da Cunha", "SHN", "SH", true, new State[0]),
    SLB("Solomon Islands", "SLB", "SB", false, new State[0]),
    SLE("Sierra Leone", "SLE", "SL", true, new State[0]),
    SLV("El Salvador", "SLV", "SV", true, new State[0]),
    SMR("San Marino", "SMR", "SM", true, new State[0]),
    SOM("Somalia", "SOM", "SO", true, new State[0]),
    SRB("Serbia", "SRB", "RS", true, new State[0]),
    SSD("South Sudan", "SSD", "SS", true, new State[0]),
    STP("S\u00e3o Tom\u00e9 and Pr\u00edncipe", "STP", "ST", true, new State[0]),
    SUR("Suriname", "SUR", "SR", false, new State[0]),
    SVK("Slovakia", "SVK", "SK", true, new State[0]),
    SVN("Slovenia", "SVN", "SI", true, new State[0]),
    SWE("Sweden", "SWE", "SE", true, new State[0]),
    SWZ("Eswatini", "SWZ", "SZ", false, new State[0]),
    SYC("Seychelles", "SYC", "SC", false, new State[0]),
    SYR("Syria", "SYR", "SY", true, new State[0]),
    TCA("Turks and Caicos Islands", "TCA", "TC", false, new State[0]),
    TCD("Chad", "TCD", "TD", true, new State[0]),
    TGO("Togo", "TGO", "TG", true, new State[0]),
    THA("Thailand", "THA", "TH", false, new State[0]),
    TJK("Tajikistan", "TJK", "TJ", true, new State[0]),
    TKL("Tokelau", "TKL", "TK", true, new State[0]),
    TKM("Turkmenistan", "TKM", "TM", true, new State[0]),
    TLS("Timor-Leste", "TLS", "TL", false, new State[0]),
    TON("Tonga", "TON", "TO", false, new State[0]),
    TTO("Trinidad and Tobago", "TTO", "TT", false, new State[0]),
    TUN("Tunisia", "TUN", "TN", true, new State[0]),
    TUR("Turkey", "TUR", "TR", true, new State[0]),
    TUV("Tuvalu", "TUV", "TV", false, new State[0]),
    TWN("Taiwan", "TWN", "TW", true, new State[0]),
    TZA("Tanzania", "TZA", "TZ", false, new State[0]),
    UGA("Uganda", "UGA", "UG", false, new State[0]),
    UKR("Ukraine", "UKR", "UA", true, new State[0]),
    URY("Uruguay", "URY", "UY", true, new State[0]),
    USA("United States", "USA", "US", true, State.US_AL, State.US_AK, State.US_AZ, State.US_AR, State.US_CA, State.US_CO, State.US_CT, State.US_DE, State.US_DC, State.US_FL, State.US_GA, State.US_HI, State.US_ID, State.US_IL, State.US_IN, State.US_IA, State.US_KS, State.US_KY, State.US_LA, State.US_ME, State.US_MD, State.US_MA, State.US_MI, State.US_MN, State.US_MS, State.US_MO, State.US_MT, State.US_NE, State.US_NV, State.US_NH, State.US_NJ, State.US_NM, State.US_NY, State.US_NC, State.US_ND, State.US_OH, State.US_OK, State.US_OR, State.US_PA, State.US_RI, State.US_SC, State.US_SD, State.US_TN, State.US_TX, State.US_UT, State.US_VT, State.US_VA, State.US_WA, State.US_WV, State.US_WI, State.US_WY),
    UZB("Uzbekistan", "UZB", "UZ", true, new State[0]),
    VAT("Vatican City", "VAT", "VA", true, new State[0]),
    VCT("Saint Vincent and the Grenadines", "VCT", "VC", false, new State[0]),
    VEN("Venezuela", "VEN", "VE", true, new State[0]),
    VGB("British Virgin Islands", "VGB", "VG", false, new State[0]),
    VNM("Vietnam", "VNM", "VN", true, new State[0]),
    VUT("Vanuatu", "VUT", "VU", true, new State[0]),
    WSM("Samoa", "WSM", "WS", false, new State[0]),
    XKX("Kosovo", "XKX", "XK", true, new State[0]),
    YEM("Yemen", "YEM", "YE", true, new State[0]),
    ZAF("South Africa", "ZAF", "ZA", false, new State[0]),
    ZMB("Zambia", "ZMB", "ZM", false, new State[0]),
    ZWE("Zimbabwe", "ZWE", "ZW", false, new State[0]);

    public static final String KEY = "country";
    private static final Map<String, Country> ALPHA2_MAP;
    private final String countryName;
    private final String alpha2;
    private final String alpha3;
    private final List<State> states;
    private final boolean isRightHandTraffic;

    private Country(String countryName, String alpha3, String alpha2, boolean isRightHandTraffic, State ... states) {
        this.countryName = countryName;
        this.alpha2 = alpha2;
        this.alpha3 = alpha3;
        this.isRightHandTraffic = isRightHandTraffic;
        this.states = Arrays.asList(states);
    }

    public String getCountryName() {
        return this.countryName;
    }

    public String getAlpha2() {
        return this.alpha2;
    }

    public String getAlpha3() {
        return this.alpha3;
    }

    public boolean isRightHandTraffic() {
        return this.isRightHandTraffic;
    }

    public List<State> getStates() {
        return this.states;
    }

    public static EnumEncodedValue<Country> create() {
        return new EnumEncodedValue<Country>(KEY, Country.class);
    }

    public static Country find(String iso) {
        return ALPHA2_MAP.get(iso);
    }

    public String toString() {
        return this.alpha3;
    }

    static {
        ALPHA2_MAP = new HashMap<String, Country>();
        for (Country country : Country.values()) {
            if (country == MISSING) continue;
            ALPHA2_MAP.put(country.alpha2, country);
        }
    }
}

