/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.ev;

import com.graphhopper.routing.ev.ImportUnit;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ImportUnitSorter {
    Set<String> permanentMarked = new HashSet<String>();
    Set<String> temporaryMarked = new HashSet<String>();
    List<String> result = new ArrayList<String>();
    final Map<String, ImportUnit> map;

    public ImportUnitSorter(Map<String, ImportUnit> map) {
        this.map = map;
    }

    public List<String> sort() {
        for (String strN : this.map.keySet()) {
            this.visit(strN);
        }
        return this.result;
    }

    private void visit(String strN) {
        if (this.permanentMarked.contains(strN)) {
            return;
        }
        ImportUnit importUnit = this.map.get(strN);
        if (importUnit == null) {
            throw new IllegalArgumentException("cannot find import unit " + strN);
        }
        if (this.temporaryMarked.contains(strN)) {
            throw new IllegalArgumentException("import units with cyclic dependencies are not allowed: " + String.valueOf(importUnit) + " " + String.valueOf(importUnit.getRequiredImportUnits()));
        }
        this.temporaryMarked.add(strN);
        for (String strM : importUnit.getRequiredImportUnits()) {
            this.visit(strM);
        }
        this.temporaryMarked.remove(strN);
        this.permanentMarked.add(strN);
        this.result.add(strN);
    }
}

